/*
 * File:		m51em256evb.h
 * Purpose:		Evaluation board definitions and memory map information
 *
 * Notes:
 */

#ifndef _M51EM256EVB_H
#define _M51EM256EVB_H

/********************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "mcf5xxx.h"
#include "derivative.h" /* include peripheral declarations */

/********************************************************************/

/*
 * Debug prints ON (#undef) or OFF (#define)
 */
#undef DEBUG

/*
 * System Bus Clock Info
 */
#define	SYSTEM_CLOCK		48000000UL/* system frequency in Hz */
//#define PERIOD					20	/* system bus period in ns */

#define UART_BAUD				19200	/* 19200 */
#define UART_PORT				1/*second SCI port (SCI2)*/

/*
 * ColdFire Port specific
 */
#define TIMEOUT_VALUE   0xFFFF 


/*Handy: check for nucleous*/


#define SW1 PTED_PTED1
#define SW2 PTED_PTED2
#define SW3 PTBD_PTBD6
#define SW4 PTBD_PTBD7

#define SW1_DD PTEDD_PTEDD1
#define SW2_DD PTEDD_PTEDD2
#define SW3_DD PTBDD_PTBDD6
#define SW4_DD PTBDD_PTBDD7

#define SW1_PE PTEPE_PTEPE1
#define SW2_PE PTEPE_PTEPE2
#define SW3_PE PTBPE_PTBPE6
#define SW4_PE PTBPE_PTBPE7



#define SW1_ON()   !SW1
#define SW2_ON()   !SW2
#define SW3_ON()   !SW3
#define SW4_ON()   !SW4

#define SW1_OFF()   SW1
#define SW2_OFF()   SW2
#define SW3_OFF()   SW3
#define SW4_OFF()   SW4




///////
#define LED1 PTAD_PTAD5
#define LED2 PTAD_PTAD6
#define LED3 PTED_PTED4
#define LED4 PTED_PTED5

#define LED1_DD PTADD_PTADD5
#define LED2_DD PTADD_PTADD6
#define LED3_DD PTEDD_PTEDD4
#define LED4_DD PTEDD_PTEDD5

#define LED1_PE PTAPE_PTAPE5
#define LED2_PE PTAPE_PTAPE6
#define LED3_PE PTEPE_PTEPE4
#define LED4_PE PTEPE_PTEPE5


#define LED1_ON()  LED1 = 0
#define LED1_OFF() LED1 = 1
#define LED2_ON()  LED2 = 0
#define LED2_OFF() LED2 = 1
#define LED3_ON()  LED3 = 0
#define LED3_OFF() LED3 = 1
#define LED4_ON()  LED4 = 0
#define LED4_OFF() LED4 = 1


#define LED1_TOGGLE()  LED1 = !LED1;
#define LED2_TOGGLE()  LED2 = !LED2;
#define LED3_TOGGLE()  LED3 = !LED3;
#define LED4_TOGGLE()  LED4 = !LED4;






/*
 * Memory map definitions from linker command files
 */

/********************************************************************/

#endif /* _M51CN128EVB_H_ */
