/*
  sci.c 
*/

#include "m51em256evb.h"
#include "sci.h"
#include "low_power.h"

/*
    switch(port)
    {
      //SCI functions
      case 1:

        break;
        
      case 2:
     
        break;
        
      case 3:
      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
*/

void SCI_init(uint8 port, unsigned short br)
{

    switch(port)
    {
      /*SCI function*/
      case 1:
        /*SCI function*/
        PTBPF2_B2 = 3;
        PTBPF2_B3 = 3;    

        /*starting SCI clock*/
        SCGC1_SCI1 = 1;

        SCI1BD = br;
        SCI1C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
        SCI1C2_TE = 1;      //enable transmitter
        SCI1C2_RE = 1;      //enable transmitter
        break;
        
      case 2:
        /*SCI function*/
        PTBPF2_B0 = 3;
        PTBPF2_B1 = 3;    

        /*starting SCI clock*/
        SCGC1_SCI2 = 1;

        SCI2BD = br;
        SCI2C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
        SCI2C2_TE = 1;      //enable transmitter
        SCI2C2_RE = 1;      //enable transmitter      
        break;
        
      case 3:
        /*SCI function*/
        PTFPF2_F2 = 3;
        PTFPF2_F3 = 3;    

        /*starting SCI clock*/
        SCGC1_SCI3 = 1;

        SCI3BD = br;
        SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
        SCI3C2_TE = 1;      //enable transmitter
        SCI3C2_RE = 1;      //enable transmitter            
        break;
        
      default:
        for(;;)
        ; /*error*/
        break;
    }
     
}                        

uint8 SCI_SendChr(uint8 port, char _char)
{
    uint16 timeout = TIMEOUT_VALUE;
    
    switch(port)
    {
      //SCI functions
      case 1:
        while(!SCI1S1_TDRE)             
        {
           if(!(--timeout))
           {
               return -1;
           }
        };/*wait until  we have space*/
        SCI1D = (byte)_char;    //2nd part of the cleaning procedure for TRDE
        break;
        
      case 2:
        while(!SCI2S1_TDRE)        
        {
           if(!(--timeout))
           {
               return -1;
           }
        };/*wait until  we have space*/
        SCI2D = (byte)_char;    //2nd part of the cleaning procedure for TRDE
        break;
        
      case 3:
        while(!SCI3S1_TDRE)        
        {
           if(!(--timeout))
           {
               return -1;
           }
        };/*wait until  we have space*/
        SCI3D = (byte)_char;    //2nd part of the cleaning procedure for TRDE
        break;
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   
}

void SCI_SendMsg(uint8 port, char *str)
{
    while(*str) SCI_SendChr(port,*str++);        
}

/*  */
unsigned char SCI_ReceiveChar(uint8 port, unsigned char *p_rx)
{
    switch(port)
    {
      //SCI functions
      case 1:
         if (SCI1S1_RDRF) 
         {
           *p_rx = SCI1D;
           return 0;
         }   
         else
           return 1;  //NO data received
        break;
        
      case 2:
         if (SCI2S1_RDRF) 
         {
           *p_rx = SCI2D;
           return 0;
         }   
         else
           return 1;  //NO data received     
        break;
        
      case 3:
         if (SCI3S1_RDRF) 
         {
           *p_rx = SCI3D;
           return 0;
         }   
         else
           return 1;  //NO data received      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}    


