/*
 * File:
 *
 * Notes:       
 *              
 */
#include "m51em256evb.h"
#include "uart.h"

/********************************************************************/
/*
 * Initialize the UART for 8N1 operation, interrupts disabled, and
 * no hardware flow-control
 *
 * Parameters:
 *  uartch      UART channel to initialize
 *  sysclk      UART System Clock (khz, used to calculate baud)
 *  baud        UART baud rate
 *  settings    Initialization parameters
 */
void uart_init() 
{
	/*
	 * Initialize all three UARTs for serial communications
	 */
	register uint16 ubgs;
  
  switch(UART_PORT)
  {
    case 0:
      /*SCI function*/
      PTBPF2_B2 = 3;
      PTBPF2_B3 = 3;    

      /*starting SCI clock*/
      SCGC1_SCI1 = 1;

    	/*
    	 * Calculate baud settings
    	 */
    	//FSL:check this formula!!!
    	ubgs = (uint16)((SYSTEM_CLOCK)/(UART_BAUD * 32));

    	SCI1BDH = (uint8)((ubgs & 0xFF00) >> 8);
    	SCI1BDL = (uint8)(ubgs & 0x00FF);
    
      /* 8-bit mode. Normal operation */
      SCI1C1 = NULL;
      /* Receiver interrupt enable. Transmitter and receiver enable */
      SCI1C2 = (0
               | SCI1C2_TE_MASK
               | SCI1C2_RE_MASK
               );
      /* Disable all errors interrupts */  
      SCI1C3 = NULL;

    	break;
    case 1:
      /*SCI function*/
      PTBPF2_B0 = 3;
      PTBPF2_B1 = 3;    

      /*starting SCI clock*/
      SCGC1_SCI2 = 1;
    	/*
    	 * Calculate baud settings
    	 */
    	//FSL:check this formula!!!
    	ubgs = (uint16)((SYSTEM_CLOCK)/(UART_BAUD * 32));

    	SCI2BDH = (uint8)((ubgs & 0xFF00) >> 8);
    	SCI2BDL = (uint8)(ubgs & 0x00FF);
    
      /* 8-bit mode. Normal operation */
      SCI2C1 = NULL;
      /* Receiver interrupt enable. Transmitter and receiver enable */
      SCI2C2 = (0
               | SCI1C2_TE_MASK
               | SCI1C2_RE_MASK
               );
      /* Disable all errors interrupts */  
      SCI2C3 = NULL;
    	break;    
    case 2:
      /*SCI function*/
      PTFPF2_F2 = 3;
      PTFPF2_F3 = 3;    

      /*starting SCI clock*/
      SCGC1_SCI3 = 1;
    	/*
    	 * Calculate baud settings
    	 */
    	//FSL:check this formula!!!
    	ubgs = (uint16)((SYSTEM_CLOCK)/(UART_BAUD * 32));

    	SCI3BDH = (uint8)((ubgs & 0xFF00) >> 8);
    	SCI3BDL = (uint8)(ubgs & 0x00FF);
    
      /* 8-bit mode. Normal operation */
      SCI3C1 = NULL;
      /* Receiver interrupt enable. Transmitter and receiver enable */
      SCI3C2 = (0
               | SCI1C2_TE_MASK
               | SCI1C2_RE_MASK
               );
      /* Disable all errors interrupts */  
      SCI3C3 = NULL;
    	break;   
  }
}

/********************************************************************/
/*
 * Wait for a character to be received on the specified UART
 *
 * Return Values:
 *  the received character
 */
unsigned char uart_getchar (int channel)
{
 switch(channel)
 {
    case 0:
       /* Wait until character has been received */
       while(!SCI1S1_RDRF)
       ; /*wait*/
       return SCI1D;
       break;
    case 1:
       /* Wait until character has been received */
       while(!SCI2S1_RDRF)
       ; /*wait*/
       return SCI2D;
       break;  
    case 2:
       /* Wait until character has been received */
       while(!SCI3S1_RDRF)
       ; /*wait*/
       return SCI3D;
       break;  
 }
}
/********************************************************************/
/*
 * Wait for space in the UART Tx FIFO and then send a character
 */ 
void uart_putchar (int channel, char ch)
{    
 switch(channel)
 {
    case 0:
       while (!SCI1S1_TDRE)
       ;/* Wait for the transmitter to be empty */
 
       SCI1D = (uint8)ch;               /* Send a character by SCI */
       break;
    case 1:
       while (!SCI2S1_TDRE)
       ;/* Wait for the transmitter to be empty */
 
       SCI2D = (uint8)ch;               /* Send a character by SCI */
       break; 
    case 2:
       while (!SCI3S1_TDRE)
       ;/* Wait for the transmitter to be empty */
 
       SCI3D = (uint8)ch;               /* Send a character by SCI */
       break;  
 }    
}
/********************************************************************/
/*
 * Check to see if a character has been received
 *
 * Return values:
 *  0       No character received
 *  1       Character has been received
 */
int uart_getchar_present (int channel)
{
    
 switch(channel)
 {
    case 0:
       return SCI1S1_RDRF;
       break;
    case 1:
       return SCI2S1_RDRF;
       break; 
    case 2:
       return SCI3S1_RDRF;
       break;  
 } 
}

/********************************************************************/