
#include "m51em256evb.h"
#include "task_mgr.h"
#include "inputdata.h"
#include "metering_algorithms.h"
#include "Metering_algorithm_Tests.h"
#include "tpm.h"

/*Defines*/ 

//Global Variables//
word Number_of_interactions[N_SAMPLES];     //Debug purposes
word Interactions;
dword OutputVec[N_SAMPLES],time;
word i, InputA[256], Vrms, Irms, Vrms_f, Irms_f, V_THD, I_THD;
Power_vec Power_out1;
Power_time Power_time1;
Complex V_DFT_Out, I_DFT_Out;
long Mac_result;
long ErrorTotal=0, ErrorCount=0;
short mac1[] = {32000, -32000, 32000, -32000, 6, 7, 8, 9};
short mac2[] = {-32000, 32000, -32000, 32000, 7, 8, 9, 10};
long long temp_A,temp_B;  

void tsk_welcome(void) 

 {
   vfnLCD_Write_New_Msg("MC51EM256");
   printf("\n\r\n\r**** MC51EM256 Performance Test ****\n\r\n\r");  // Send mesage via SCI1
   
   printf("Buffer size::\n\r");
   printf("RMS Samples Buffer: %i x 16-bits words\n\r",SAMPLE_FOR_RMS);
   printf("Power Calc Samples Buffer: %i x 16-bits words\n\r",N_SAMPLES);   
   printf("DFT and THD Samples Buffer: %i x 16-bits words\n\r\n\r",SAMPLE_FOR_DFT);

   printf("Available Tests:\n\r");
   printf("1.Root Square Algorithm Test \n\r");
   printf("2.RMS Algorithm Test \n\r");
   printf("3.Power Algorithms Test \n\r");
   printf("4.DFT and THD Algorithms Test \n\r");  
   
   printf("\n\rPress SW1... \n\r");
   StartTPM();
   while(SW1_OFF())asm(nop);
   TPM_delay(4);
   (void)Stop_Read_TPM();
   printf("\n\r*** 1. Square Root Test***\n\rPress SW1 to Start\n\r");
   printf("Press SW2 to go to '2.RMS Test'\n\r");
   next_task_t(tsk_TestSqrRoot,1); 
  
 }

void tsk_TestSqrRoot(void){
   
    if(SW1_ON()){
      TPM_delay(4);
      //Square Root Test - 1st Data Set--------------------------------------- 
      StartTPM();
      for(i=0;i<N_SAMPLES;i++){
         OutputVec[i]= SquareRoot(InputVec[i]);
      }
      time = Stop_Read_TPM();  
      
      //Error Calculation
      ErrorTotal = 0;
      ErrorCount = 0;
      Interactions = 0;
      for(i=0;i<N_SAMPLES;i++){
         Interactions += Number_of_interactions[i];
         if(OutputVec[i]!=ExpectedVec[i]){
             ErrorCount++;
             ErrorTotal +=  (OutputVec[i] - ExpectedVec[i])*(OutputVec[i] - ExpectedVec[i]);
         }  
      }      
      printf("\n\r**First Data Set**\n\r");
      printf("# results with error = %i \n\r",ErrorCount);
      printf("Sum(E^2)= %i \n\r", ErrorTotal);
      printf("Total Time = %i uS \n\r", time);
      printf("Average Time = %i.%i uS\n\r", time/256, (((time *100)/256) - ((time/256)*100)));
      printf("Average # of interactions = %i.%i \n\r",Interactions/256, (((Interactions *100)/256) - ((Interactions/256)*100)));
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4);
      
      //Square Root Test - 2nd Data Set--------------------------------------- 
      StartTPM();
      for(i=0;i<N_SAMPLES;i++){
         OutputVec[i]= SquareRoot(InputVec1[i]);
      }
      time = Stop_Read_TPM();  
      
      //Error Calculation
      ErrorTotal = 0;
      ErrorCount = 0;
      Interactions = 0;
      for(i=0;i<N_SAMPLES;i++){
         Interactions += Number_of_interactions[i];
         if(OutputVec[i]!=ExpectedVec1[i]){
             ErrorCount++;
             ErrorTotal +=  (OutputVec[i] - ExpectedVec1[i])*(OutputVec[i] - ExpectedVec1[i]);
         }  
      }      
      printf("\n\r**Second Data Set**\n\r");
      printf("# results with error = %i \n\r",ErrorCount);
      printf("Sum(E^2)= %i \n\r", ErrorTotal);
      printf("Total Time = %i uS \n\r", time);
      printf("Average Time = %i.%i uS\n\r", time/256, (((time *100)/256) - ((time/256)*100)));
      printf("Average # of interactions = %i.%i \n\r",Interactions/256,(((Interactions *100)/256) - ((Interactions/256)*100)));
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4);
      
     //Square Root Test - 3rd Data Set--------------------------------------- 
      StartTPM();
      for(i=0;i<N_SAMPLES;i++){
         OutputVec[i]= SquareRoot(InputVec2[i]);
      }
      time = Stop_Read_TPM();  
      
      //Error Calculation
      ErrorTotal = 0;
      ErrorCount = 0;
      Interactions = 0;
      for(i=0;i<N_SAMPLES;i++){
         Interactions += Number_of_interactions[i];
         if(OutputVec[i]!=ExpectedVec2[i]){
             ErrorCount++;
             ErrorTotal +=  (OutputVec[i] - ExpectedVec2[i])*(OutputVec[i] - ExpectedVec2[i]);
         }  
      }      
      printf("\n\r**Third Data Set**\n\r");
      printf("# results with error = %i \n\r",ErrorCount);
      printf("Sum(E^2)= %i \n\r", ErrorTotal);
      printf("Total Time = %i uS \n\r", time);
      printf("Average Time = %i.%i uS\n\r", time/256, (((time *100)/256) - ((time/256)*100)));
      printf("Average # of interactions = %i.%i \n\r",Interactions/256,(((Interactions *100)/256) - ((Interactions/256)*100)));
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4);
      
     //Square Root Test - 4th Data Set--------------------------------------- 
      StartTPM();
      for(i=0;i<N_SAMPLES;i++){
         OutputVec[i]= SquareRoot(InputVec3[i]);
      }
      time = Stop_Read_TPM();  
      
      //Error Calculation
      ErrorTotal = 0;
      ErrorCount = 0;
      Interactions = 0;
      for(i=0;i<N_SAMPLES;i++){
         Interactions += Number_of_interactions[i];
         if(OutputVec[i]!=ExpectedVec3[i]){
             ErrorCount++;
             ErrorTotal +=  (OutputVec[i] - ExpectedVec3[i])*(OutputVec[i] - ExpectedVec3[i]);
         }  
      }      
      printf("\n\r**Forth Data Set**\n\r");
      printf("# results with error = %i \n\r",ErrorCount);
      printf("Sum(E^2)= %i \n\r", ErrorTotal);
      printf("Total Time = %i uS \n\r", time);
      printf("Average Time = %i.%i uS\n\r", time/256, (((time *100)/256) - ((time/256)*100)));
      printf("Average # of interactions = %i.%i \n\r",Interactions/256,(((Interactions *100)/256) - ((Interactions/256)*100)));

      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4); 
      //--------------------------------------------------------
      printf("\n\r*** 2.RMS Test***\n\r Press SW1 to Start\n\r");
      printf("Press SW2 to go to '3.Power Calculation Test'\n\r");
      next_task_t(tsk_TestRMS,1);
    }

    if(SW2_ON()){
         printf("\n\r*** 2.RMS Test***\n\r Press SW1 to Start\n\r");
         printf("Press SW2 to go to '3.Power Calculation Test'\n\r");
         next_task_t(tsk_TestRMS,1);
         TPM_delay(4);
  
    }
}

void tsk_TestRMS(void){

  if(SW1_ON()){
      TPM_delay(4);
      printf("\n\r**First Data Set**\n\r");
      StartTPM();
      Vrms = RMS_calc((short *)&InputVecRMS[0]);
      time = Stop_Read_TPM();
      printf("Total Time = %i uS \n\r", time);
      printf("RMS result = %i \n\r", Vrms);
      
      printf("\n\r**Second Data Set**\n\r");
      StartTPM();
      Irms = RMS_calc((short *)&InputVecRMS1[0]);
      time = Stop_Read_TPM();
      printf("Total Time = %i uS \n\r", time);
      printf("RMS result = %i \n\r", Irms);

      printf("\n\r**Third Data Set**\n\r");
      StartTPM();
      Vrms = RMS_calc((short *)&InputVecRMS2[0]);
      time = Stop_Read_TPM();
      printf("Total Time = %i uS \n\r", time);
      printf("RMS result = %i \n\r", Vrms);
      
      printf("\n\r**Fourth Data Set**\n\r");
      StartTPM();
      Irms = RMS_calc((short *)&InputVecRMS3[0]);
      time = Stop_Read_TPM();
      printf("Total Time = %i uS \n\r", time);
      printf("RMS result = %i \n\r", Irms);
      
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4);       
      printf("\n\r*** 3.Power Calculation Test***\n\r Press SW1 to Start\n\r");
      printf("Press SW2 to go to '4.DFT Test'\n\r");
      next_task_t(tsk_TestPowerCalc,1);
      
  }
  
  if(SW2_ON()){
       printf("\n\r*** 3.Power Calculation Test***\n\r Press SW1 to Start\n\r");
       printf("Press SW2 to go to '4.DFT Test'\n\r");
       next_task_t(tsk_TestPowerCalc,1);
       TPM_delay(4);
  
  }  
}


void tsk_TestPowerCalc(void){       

  if(SW1_ON()){
      TPM_delay(4);
     
      //1st----------------------
      printf("\n\rFirst Dataset\n\r");
      Power_Calc((short *)&InputVecRMS[0], (short *)&InputVecRMS[0], &Power_out1, &Power_time1);

      temp_A = (Power_out1.Act_Eng/1000000000); 
      temp_B = -(temp_A*1000000000);
      temp_B += (Power_out1.Act_Eng);
      
      printf("Active Energy: %i%000000000u @%i uS\n\r",(dword)temp_A,(dword)temp_B ,Power_time1.Act_Eng);
      printf("Active Power: %i @%i uS\n\r",Power_out1.Act_Pwr,Power_time1.Act_Pwr);
      printf("React. Power: %i @%i uS\n\r",Power_out1.React_Pwr,Power_time1.React_Pwr);
      printf("Apare. Power: %i @%i uS\n\r",Power_out1.Apr_Pwr,Power_time1.Apr_Pwr);
      printf("Vrms: %i @%i uS\n\r",Power_out1.Vrms,Power_time1.Vrms);
      printf("Irms: %i @%i uS\n\r",Power_out1.Irms,Power_time1.Irms);
      printf("Power Factor: %i@ %i uS\n\r",Power_out1.Pwr_fct,Power_time1.Pwr_fct);
      
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4);   

      //2nd----------------------
      printf("\n\rSecond Dataset\n\r");
      Power_Calc((short *)&inputsignal1[0], (short *)&inputsignal2[0], &Power_out1, &Power_time1);

      temp_A = (Power_out1.Act_Eng/1000000000); 
      temp_B = -(temp_A*1000000000);
      temp_B += (Power_out1.Act_Eng);
      
      printf("Active Energy: %i%000000000u @%i uS\n\r",(dword)temp_A,(dword)temp_B ,Power_time1.Act_Eng);
      printf("Active Power: %i @%i uS\n\r",Power_out1.Act_Pwr,Power_time1.Act_Pwr);
      printf("React. Power: %i @%i uS\n\r",Power_out1.React_Pwr,Power_time1.React_Pwr);
      printf("Apare. Power: %i @%i uS\n\r",Power_out1.Apr_Pwr,Power_time1.Apr_Pwr);
      printf("Vrms: %i @%i uS\n\r",Power_out1.Vrms,Power_time1.Vrms);
      printf("Irms: %i @%i uS\n\r",Power_out1.Irms,Power_time1.Irms);
      printf("Power Factor: %i@ %i uS\n\r",Power_out1.Pwr_fct,Power_time1.Pwr_fct);
      
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4); 

       //3rd----------------------
      printf("\n\rThird Dataset\n\r");
      Power_Calc((short *)&inputsignal3[0], (short *)&inputsignal4[0], &Power_out1, &Power_time1);
      temp_A = (Power_out1.Act_Eng/1000000000); 
      temp_B = -(temp_A*1000000000);
      temp_B += (Power_out1.Act_Eng);
      
      printf("Active Energy: %i%000000000u @%i uS\n\r",(dword)temp_A,(dword)temp_B ,Power_time1.Act_Eng);
      printf("Active Power: %i @%i uS\n\r",Power_out1.Act_Pwr,Power_time1.Act_Pwr);
      printf("React. Power: %i @%i uS\n\r",Power_out1.React_Pwr,Power_time1.React_Pwr);
      printf("Apare. Power: %i @%i uS\n\r",Power_out1.Apr_Pwr,Power_time1.Apr_Pwr);
      printf("Vrms: %i @%i uS\n\r",Power_out1.Vrms,Power_time1.Vrms);
      printf("Irms: %i @%i uS\n\r",Power_out1.Irms,Power_time1.Irms);
      printf("Power Factor: %i@ %i uS\n\r",Power_out1.Pwr_fct,Power_time1.Pwr_fct);
      
      printf("\n\rPress SW1 to continue...\n\r");
      while(SW1_OFF())asm(nop);
      TPM_delay(4); 
      printf("\n\r*** 4.DFT Test***\n\r Press SW1 to Start\n\r");
      printf("Press SW2 to go back to Main Menu \n\r");
      next_task_t(tsk_TestDFT,1);
  }
  
  if(SW2_ON()){
       printf("\n\r*** 4.DFT Test***\n\r Press SW1 to Start\n\r");
       printf("Press SW2 to go back to Main Menu \n\r");
       next_task_t(tsk_TestDFT,1);
       TPM_delay(4);
  
  }  

}

void tsk_TestDFT(void){
  if(SW1_ON()){
     TPM_delay(4);
          
   //DFT Calculation
    //1st Dataset
    StartTPM();
    V_DFT_Out = DFT((short *)&inputsignal1[0]);
    time = Stop_Read_TPM();
    printf("\n\rDFT input signal 1: (%i + %ij) @%i uS\n\r",V_DFT_Out.Real, V_DFT_Out.Img, time);
    
    Vrms = RMS_calc((short *)&inputsignal1[0]); 
    
    StartTPM();
    Vrms_f = RMS_DFT_calc(V_DFT_Out);
    V_THD = THD_calc(Vrms,Vrms_f);
    time = Stop_Read_TPM();
    printf("DFT input signal 1: Fundamental RMS (%i), THD (%i%) @%i uS\n\r",Vrms_f,V_THD,time);

    //2nd Dataset
    
    StartTPM();
    I_DFT_Out = DFT((short *)&inputsignal2[0]);
    time = Stop_Read_TPM();
    printf("\n\rDFT input signal 2: (%i + %ij) @%i uS\n\r",I_DFT_Out.Real, I_DFT_Out.Img, time);

    Irms = RMS_calc((short *)&inputsignal2[0]);
    
    StartTPM();
    Irms_f = RMS_DFT_calc(I_DFT_Out);
    I_THD = THD_calc(Irms,Irms_f);
    time = Stop_Read_TPM();
    printf("DFT input signal 2: Fundamental RMS (%i), THD (%i%) @%i uS\n\r",Irms_f,I_THD,time);
   
    
    //3rd Dataset
    StartTPM();
    V_DFT_Out = DFT((short *)&inputsignal3[0]);
    time = Stop_Read_TPM();
    printf("\n\rDFT input signal 3: (%i + %ij) @%i uS\n\r",V_DFT_Out.Real, V_DFT_Out.Img, time);
    
    Vrms = RMS_calc((short *)&inputsignal3[0]); 
    
    StartTPM();
    Vrms_f = RMS_DFT_calc(V_DFT_Out);
    V_THD = THD_calc(Vrms,Vrms_f);
    time = Stop_Read_TPM();
    printf("DFT input signal 3: Fundamental RMS (%i), THD (%i%) @%i uS\n\r",Vrms_f,V_THD,time);
    
    //4th Dataset
    StartTPM();
    I_DFT_Out = DFT((short *)&inputsignal4[0]);
    time = Stop_Read_TPM();
    printf("\n\rDFT input signal 4: (%i + %ij) @%i uS\n\r",I_DFT_Out.Real, I_DFT_Out.Img, time);

    Irms = RMS_calc((short *)&inputsignal4[0]);
    
    StartTPM();
    Irms_f = RMS_DFT_calc(I_DFT_Out);
    I_THD = THD_calc(Irms,Irms_f);
    time = Stop_Read_TPM();
    printf("DFT input signal 4: Fundamental RMS (%i), THD (%i%) @%i uS\n\r",Irms_f,I_THD,time);
 
    
    //5th Dataset    
    StartTPM();
    I_DFT_Out = DFT((short *)&inputsignal5[0]);
    time = Stop_Read_TPM();
    printf("\n\rDFT input signal 5: (%i + %ij) @%i uS\n\r",I_DFT_Out.Real, I_DFT_Out.Img, time);

    Irms = RMS_calc((short *)&inputsignal5[0]);
    
    StartTPM();
    Irms_f = RMS_DFT_calc(I_DFT_Out);
    I_THD = THD_calc(Irms,Irms_f);
    time = Stop_Read_TPM();
    printf("DFT input signal 5: Fundamental RMS (%i), THD (%i%) @%i uS\n\r",Irms_f,I_THD,time);
    
    
    //-----------------------------------------
    printf("\n\rPress SW1 to continue...\n\r");
    while(SW1_OFF())asm(nop);
    TPM_delay(4);       
    next_task_t(tsk_welcome,1);
  }
  
  if(SW2_ON()){
       next_task_t(tsk_welcome,1);
       TPM_delay(4);
  }
}
#if 0


#if POWER == 1 
    //---------------------------------------------------------
    // Active Power
    //---------------------------------------------------------
    Power_Calc((short *)&InputVecRMS[0], (short *)&InputVecRMS[0], &Power_out1);
    Power_Calc((short *)&inputsignal1[0], (short *)&inputsignal2[0], &Power_out1);
    Power_Calc((short *)&inputsignal3[0], (short *)&inputsignal4[0], &Power_out1);

#endif
   
#if TEST_DFT == 1        
    //---------------------------------------------------------
    // DFT Test
    //---------------------------------------------------------
 
    //---------------------------------------------------------
#endif
  
  }  
  

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/
#endif
/* END Atom_Nucleus_Metering_Perf */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.01 [03.92]
**     for the Freescale ColdFireV1 series of microcontrollers.
**
** ###################################################################
*/
