
 





#include "LCDConfig.h"
#include "LCDHDW.h"


/*~|~|~|~|~|~|~|~|~|~|~|~|~|~  LCD  Control Register 0  ~|~|~|~|~|~|~|~|~|~|~|~|~*/
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|*/

#define _LCDENABLE           (0)                                                 //0 All frontplanes and backplanes are disable
                                                                                                        //1 LCD module is enable
#define _LCDCLKSOURCE  (0)                                                  // 0 -- External clock       1 --  Alternate clock
#define _LCDCLKPSL            (1)                                                 //  Clock divider to generate the LCD Waveforms
#define  _LCDDUTY              (_LCDBACKPLANES)                 //# of Backplanes 

/*~|~|~|~|~|~|~|~|~|~|~|~|~|~  LCD  Control Register 1  ~|~|~|~|~|~|~|~|~|~|~|~|~|*/
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|*/
#define _LCDFRAMEINTERRUPT (0)        //0 Disabel Frame Frequency Interrupt
                                                                       //1 Enable an LCD interrupt that coincides with the LCD frame frequency
#define _LCDFULLCPLDIRIVE     (0)        // 0 GPIO shared with the LCD. Inputs levels and internal pullup reference to VDD
                                                                      // 1 If VSUPPLY=11and RVEN=0. Inputs levels and internal pullup reference to VLL3
#define _LCDWAITMODE            (0)       // 0 Allows the LCD driver and charge pump to conitnue running during wait mode
                                                                     //  1 Disable the LCD when the MCU goes into wait mode
#define _LCDSTOPMODE             (0)     // 0 Allows the LCD driver and charge pump to conitnue running during stop2 or stop3
                                                                     //  1 Disable the LCD when and charge pump when the MCU goes into stop2 or stop3                                                               

/*~|~|~|~|~|~|~|~|~|~|~|~|~|~  LCD  Voltage Supply Register  ~|~|~|~|~|~|~|~|~|~|~|~*/
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|*/
#define _LCDHIGHREF                  (0)      //0 Divide input VIREG=1.0v
                                                                       //1 Do not divide the input VIREG=1.67v
#define _LCDBBYPASS                    (0)      //Determines wheter the internal LCD op amp buffer is bypassed
                                                                      //0 Buffered mode
                                                                      //1 Unbuffered mode
                            
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~  LCD  Regulated Voltage Control |~|~|~|~|~|~|~|~|~|~*/
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|*/
#define _LCDCONTRAST                    (1)       //Contrast by software   0 -- Disable    1-- Enable
#define _LVLCONTRAST                     (0)       //Any number between 0  and 15, if the number is bigger the glass get darker

/*~|~|~|~|~|~|~|~|~|~|~|~|~|~  LCD  Blink Control Register ~|~|~|~|~|~|~|~|~|~|~|~*/
/*~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|~|*/
#define _LCDBLINKCONTROL         (0)   //0 Disable blink mode
                                                                       //1 Enable blink mode
#define _LCDALTMODE                    (0)   //0 Normal display 
                                                                      //1 Alternate display for 4 backplanes or less the LCD backplane sequencer changes to otuput an alternate display
#define _LCDBLANKDISP                  (0)  //0 Do not blank display
                                                                      //1 Blank display if you put it in 0 the text before blank is manteined     
#define _LCDBLINKMODE                (0)  //0 Display blank during the blink period 
                                                                       //1 Display alternate displat during blink period (Ignored if duty is 5 or greater)


/*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{        Macros            }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}*/
/*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{   ----------------------------  }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}*/
#define LCDBCTL_INIT     (LCDBCTL = (_LCDBLINKCONTROL<<7) | (_LCDALTMODE<<6) | (_LCDBLANKDISP<<5)  | (_LCDBLINKMODE<<3) | (_LCDBLINKRATE))  
#define LCDC1_INIT         (LCDC1 =  (_LCDFRAMEINTERRUPT<<7) | (_LCDFULLCPLDIRIVE<<2)   | (_LCDWAITMODE<<1) | (_LCDSTOPMODE) )
#define LCDRVC_INIT       (LCDRVC = (_LCDCONTRAST<<7) |   (_LVLCONTRAST))    
#define LCDSUPPLY_INIT (LCDSUPPLY =  (_LCDCPSEL<<7)  | (_LCDHIGHREF<<6)   | (_LCDLOADADJUST<<5) | (_LCDBBYPASS<<2)  | (_LCDVSUPPLY)) 
#define LCDC0_INIT         (LCDC0 = (_LCDENABLE<<7) | (_LCDCLKSOURCE<<6) | (_LCDCLKPSL<<3) | (_LCDDUTY))  
#define LCDEN                  (LCDC0_LCDEN=1)
#define LCDDISABLE        (LCDC0_LCDEN=0)




 // LCD call samples
 //  vfnLCD_Home();
 //  vfnLCD_Write_Char ('0');
 //  vfnLCD_All_Segments_ON();
 //  vfnLCD_All_Segments_OFF();
 //  vfnLCD_Write_New_Msg("@@@@@@@@@");  // TURN ON all characters
 //  vfnLCD_All_Segments_OFF();

