#include "derivative.h" /* include peripheral declarations */
#include "LCD.h"


#define pause_write()  (void)LCDC0  // dummy read to give time to



byte bLCD_CharPosition;
volatile byte bflgLCD_Scroll = 0x01;



byte *bpaPlace[ ] =
{
 (unsigned char *)&Char1a,   // LCDn4 --- Pin:5    ADDR_offset :1A
 (unsigned char *)&Char1b,   // LCDn5 --- Pin:6    ADDR_offset :1B
 (unsigned char *)&Char1c,   // LCDn6 --- Pin:7    ADDR_offset :1C
 (unsigned char *)&Char1d,   // LCDn7 --- Pin:8    ADDR_offset :1D
 (unsigned char *)&Char2a,   // LCDn8 --- Pin:9    ADDR_offset :1E
 (unsigned char *)&Char2b,   // LCDn9 --- Pin:10    ADDR_offset :1F
 (unsigned char *)&Char2c,   // LCDn10 --- Pin:11    ADDR_offset :20
 (unsigned char *)&Char2d,   // LCDn11 --- Pin:12    ADDR_offset :21
 (unsigned char *)&Char3a,   // LCDn12 --- Pin:44    ADDR_offset :22
 (unsigned char *)&Char3b,   // LCDn13 --- Pin:43    ADDR_offset :23
 (unsigned char *)&Char3c,   // LCDn14 --- Pin:42    ADDR_offset :24
 (unsigned char *)&Char3d,   // LCDn15 --- Pin:41    ADDR_offset :25
 (unsigned char *)&Char4a,   // LCDn16 --- Pin:40    ADDR_offset :26
 (unsigned char *)&Char4b,   // LCDn17 --- Pin:39    ADDR_offset :27
 (unsigned char *)&Char4c,   // LCDn18 --- Pin:38    ADDR_offset :28
 (unsigned char *)&Char4d,   // LCDn19 --- Pin:37    ADDR_offset :29
 (unsigned char *)&Char5a,   // LCDn20 --- Pin:36    ADDR_offset :2A
 (unsigned char *)&Char5b,   // LCDn21 --- Pin:35    ADDR_offset :2B
 (unsigned char *)&Char5c,   // LCDn22 --- Pin:34    ADDR_offset :2C
 (unsigned char *)&Char5d,   // LCDn23 --- Pin:33    ADDR_offset :2D
 (unsigned char *)&Char6a,   // LCDn24 --- Pin:32    ADDR_offset :2E
 (unsigned char *)&Char6b,   // LCDn25 --- Pin:31    ADDR_offset :2F
 (unsigned char *)&Char6c,   // LCDn26 --- Pin:30    ADDR_offset :30
 (unsigned char *)&Char6d,   // LCDn27 --- Pin:29    ADDR_offset :31
 (unsigned char *)&Char7a,   // LCDn28 --- Pin:13    ADDR_offset :32
 (unsigned char *)&Char7b,   // LCDn29 --- Pin:14    ADDR_offset :33
 (unsigned char *)&Char7c,   // LCDn30 --- Pin:15    ADDR_offset :34
 (unsigned char *)&Char7d,   // LCDn31 --- Pin:16    ADDR_offset :35
 (unsigned char *)&Char8a,   // LCDn32 --- Pin:17    ADDR_offset :36
 (unsigned char *)&Char8b,   // LCDn33 --- Pin:18    ADDR_offset :37
 (unsigned char *)&Char8c,   // LCDn34 --- Pin:19    ADDR_offset :38
 (unsigned char *)&Char8d,   // LCDn35 --- Pin:20    ADDR_offset :39
 (unsigned char *)&Char9a,   // LCDn36 --- Pin:21    ADDR_offset :3A
 (unsigned char *)&Char9b,   // LCDn37 --- Pin:22    ADDR_offset :3B
 (unsigned char *)&Char9c,   // LCDn38 --- Pin:23    ADDR_offset :3C
 (unsigned char *)&Char9d,   // LCDn39 --- Pin:24    ADDR_offset :3D
};




/*
Codification from Ascci code 0 to Z   
This Display has 4COM/BackPlane.  It requires 4 values to complete one character
':' = SPACE

*/

const byte baAscii [ ] =
{
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 0,   offset=0
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 1,   offset=4
(!SEGN+ SEGE+!SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , (!SEGC+ SEGB),     //Char = 2,   offset=8
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 3,   offset=12
(!SEGN+!SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 4,   offset=16
(!SEGN+!SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = 5,   offset=20
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = 6,   offset=24
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+ SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 7,   offset=28
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 8,   offset=32
(!SEGN+!SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = 9,   offset=36
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = 2Points,   offset=40
(!SEGN+!SEGE+!SEGF+!SEGH) , ( SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+ SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = Semicolon,   offset=44
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+ SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = LessThan,   offset=48
(!SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = Equal,   offset=52
( SEGN+!SEGE+!SEGF+ SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = GreaterThan,   offset=56
( SEGN+!SEGE+!SEGF+ SEGH) , (!SEGM+!SEGG+!SEGJ+ SEGA) , (!SEGD+!SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = Question,   offset=60
( SEGN+ SEGE+ SEGF+ SEGH) , ( SEGM+ SEGG+ SEGJ+ SEGA) , ( SEGD+ SEGL+ SEGK) , ( SEGC+ SEGB),     //Char = At,   offset=64
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = A,   offset=68
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = B,   offset=72
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = C,   offset=76
(!SEGN+ SEGE+!SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = D,   offset=80
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = E,   offset=84
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , (!SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = F,   offset=88
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = G,   offset=92
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = H,   offset=96
(!SEGN+!SEGE+!SEGF+!SEGH) , ( SEGM+!SEGG+ SEGJ+!SEGA) , (!SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = I,   offset=100
(!SEGN+ SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = J,   offset=104
(!SEGN+!SEGE+!SEGF+!SEGH) , ( SEGM+!SEGG+ SEGJ+!SEGA) , (!SEGD+ SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = K,   offset=108
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = L,   offset=112
(!SEGN+ SEGE+ SEGF+ SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+ SEGK) , ( SEGC+ SEGB),     //Char = M,   offset=116
(!SEGN+ SEGE+ SEGF+ SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+ SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = N,   offset=120
(!SEGN+ SEGE+!SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = O,   offset=124
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , (!SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = P,   offset=128
(!SEGN+!SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = Q,   offset=132
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , (!SEGD+ SEGL+!SEGK) , (!SEGC+ SEGB),     //Char = R,   offset=136
(!SEGN+!SEGE+ SEGF+!SEGH) , (!SEGM+ SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = S,   offset=140
(!SEGN+!SEGE+!SEGF+!SEGH) , ( SEGM+!SEGG+ SEGJ+ SEGA) , (!SEGD+!SEGL+!SEGK) , (!SEGC+!SEGB),     //Char = T,   offset=144
(!SEGN+ SEGE+ SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , ( SEGD+!SEGL+!SEGK) , ( SEGC+ SEGB),     //Char = U,   offset=148
(!SEGN+!SEGE+!SEGF+ SEGH) , ( SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = V,   offset=152
( SEGN+ SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+ SEGL+!SEGK) , ( SEGC+!SEGB),     //Char = W,   offset=156
( SEGN+!SEGE+!SEGF+ SEGH) , (!SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+ SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = X,   offset=160
(!SEGN+!SEGE+!SEGF+ SEGH) , ( SEGM+!SEGG+!SEGJ+!SEGA) , (!SEGD+!SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = Y,   offset=164
( SEGN+!SEGE+!SEGF+!SEGH) , (!SEGM+!SEGG+!SEGJ+ SEGA) , ( SEGD+!SEGL+ SEGK) , (!SEGC+!SEGB),     //Char = Z,   offset=168

};





/*
void interrupt VectorNumber_Vlcd LCD_isrv() 
 {
  LCDS_LCDIF = 1;  // Clear interrupt flag
  counter2++;
 
 }


*/




void vfnLCD_Init(void)
{

 // Disable LCD frame frequency interrupt and configure LCD Module to continue running
  // during wait and stop3 mode
  LCDC1 = 0x00;// | LCDC1_LCDIEN_MASK;
  
  pause_write();  
  
  // Configures 1/4 duty cycle and 128 as LCD clock input divider (LCLK=3)
  // LCD Waveform Base Clock = 256 Hz
  LCDC0 = 0x1B;
  pause_write();  
  
  //Enable charge pump (The internal 1/3-bias is forced)
  LCDSUPPLY |= 0x80;
  
  
  
  //LCDSUPPLY_VSUPPLY = 3;  // Vireg 
  //LCDRVC_RVEN = 1; 
  
  pause_write();  
  
  

  
  
  //Configures 2 Hz as LCD blink frequency (blink only individual LCD segments)
  LCDBCTL = 0x02;
  pause_write();  

  //Enable the LCD module frontplane waveform output (FP[39:0])
  LCDPEN0 = 0xFF;
  pause_write();  
  
  LCDPEN1 = 0xFF;
  pause_write();  
  LCDPEN2 = 0xFF;
  pause_write();  
  LCDPEN3 = 0xFF;
  
  pause_write();  
  LCDPEN4 = 0xFF;
  pause_write();  
  LCDPEN5 = 0x0F;
  pause_write();  
  
  LCDBPEN0 = 0x0F;
  pause_write();  
          
  LCDWF0 = 1;
  pause_write();  
  LCDWF1 = 2;
  pause_write();  
  LCDWF2 = 4;
  pause_write();  
  LCDWF3 = 8;
  pause_write();  
   
    
  //Enables LCD driver module
  LCDC0  |= 0x80;
  pause_write();  


      
      /*
          LCDC0_INIT;          
          LCDRVC_INIT;
          LCDSUPPLY_INIT;
          LCDC1_INIT;
          LCDBCTL_INIT; 
           vfnEnablePins ();
          vfnEnableBackplanes ();
          vfnSetBackplanes ();
          LCDEN;*/
          
          

  }
  
  void vfnEnablePins (void)
  {
  
        LCDPEN0 = 0xFF;
        pause_write();  
        LCDPEN1 = 0xFF;
        pause_write();  
        LCDPEN2 = 0xFF;
        pause_write();  
        LCDPEN3 = 0xFF;
        pause_write();  
        LCDPEN4 = 0xFF;
        pause_write();  
        LCDPEN5 = 0xFF;
        pause_write();  
        
        
   /*     
        EnablePin1;
        EnablePin2;
        EnablePin3;
        EnablePin4;
        EnablePin5;
        EnablePin6;
        EnablePin7;
        EnablePin8;
        EnablePin9;
        EnablePin10;
        EnablePin11;
        EnablePin12;
        EnablePin13;
        EnablePin14;
        EnablePin15;
        EnablePin16;
        EnablePin17;
        EnablePin18;
        EnablePin19;
        EnablePin20;
        EnablePin21;
        EnablePin22;
        EnablePin23;
        EnablePin24;
        EnablePin25;
        EnablePin26;
        EnablePin27;
        EnablePin28;
        EnablePin29;
        EnablePin30;
        EnablePin31;
        EnablePin32;      
        
     */
        
  }
  
 void vfnEnableBackplanes (void)
  {
  
          LCDBPEN0 = 0x0F;
          
  
   /*
          EnableCom1;
          EnableCom2;
          EnableCom3;
          EnableCom4;
     */
  }
  
  void vfnSetBackplanes (void)
  {
  
         LCDWF0 = 1;
         pause_write();  
         LCDWF1 = 2;
         pause_write();  
         LCDWF2 = 4;
         pause_write();  
         LCDWF3 = 8;
         pause_write();  
         
  
  /*
          SetCom1;
          SetCom2;
          SetCom3;
          SetCom4;
          
         */ 
  }

 void vfnLCD_Home (void)
{
      bLCD_CharPosition =  0;
}

void vfnLCD_Contrast (byte lbContrast)
{
       lbContrast &= 0x0F;                                                                                                                  //Forced to the only values accepted 
       LCDRVC_RVTRIM   = lbContrast;                                                                                            // Write the contrast value to the register on the mcu
}



 
 void  vfnLCD_Write_Msg (byte *lbpMessage, byte lbSize )
 {
          
          if (lbSize > _CHARNUM)
          {
               vfnLCD_Scroll(lbpMessage, lbSize);
          }
          else
          {
            do
            {
                    vfnLCD_Write_Char (*lbpMessage);
                    lbpMessage ++;     
             }while (--lbSize);
          }

 }
 
 
 
 /*
 vfnLCD_Write_New_Msg.  Display a Message starting at the fisrt character of display
   until _CHARNUM  or End of string.
 */
 
 void  vfnLCD_Write_New_Msg (byte *lbpMessage)
 {

          byte lbSize = 0;          
          bLCD_CharPosition=0;  //Home display
          while (lbSize<_CHARNUM && *lbpMessage) 
          {
            vfnLCD_Write_Char (*lbpMessage++);
            lbSize++;     
          }
          
          if (lbSize<_CHARNUM) {
            
          while (lbSize++< _CHARNUM) vfnLCD_Write_Char (':');  // complete data with blanks
          }
          
          
          
}
 
 
 
 
 void vfnLCD_Scroll (byte *lbpMessage, byte lbSize)
 {
         byte  *lbpPtr;
         byte  *lbpEnd;
         byte  lbCounter = 0;
         byte  lbDistance;
         byte  Times = _CHARNUM;
         
         lbDistance =   lbSize - _CHARNUM + 1;
         lbpPtr = lbpMessage ;
         lbpEnd =  lbpMessage + lbSize;
         while (1)
         {
             vfnLCD_Home();
             if (lbpPtr >= lbpEnd)                                                                                                                              //Verify not passing the size of the message
             {
                    lbCounter = 0;
                    lbpPtr = lbpMessage;
                    Times = _CHARNUM;
             }
             
                    if (lbCounter < lbDistance)
                    {
                         lbCounter++;
                         vfnLCD_Write_Msg (lbpPtr,_CHARNUM);
                    }
                    else
                    {
                              Times --;
                              vfnLCD_Write_Msg (lbpPtr, Times);
                              vfnLCD_Write_Char (':');
                              if (bLCD_CharPosition < (_CHARNUM *_LCDTYPE))
                              {
                                 vfnLCD_Write_Msg (lbpMessage,(_CHARNUM - Times-1));      
                              }
                    }
              lbpPtr ++;
         }
         
         
         
 }




/*

 Write a Char at position bLCD_CharPosition;
 After write is complete  bLCD_CharPosition point to next position 
 
 Verify Char is a Valid character  between '0'  and 'z'
 in this case char is between 'a' to 'z' are taken as upper case
 
 If the char is a invalid char it is taken as ':'  code, in this case as SPACE
    

*/


void vfnLCD_Write_Char (byte lbValue)
{
          byte char_val;   //for test only
          byte *lbpLCDWF;
          byte lbCounter;
         

/*only ascci character if value not writeable write as @*/

          if (lbValue>='a' && lbValue<='z') lbValue -= 32; // UpperCase
          if (lbValue<'0' || lbValue >'Z') lbValue = ':';  // default value as space

          lbValue -= '0';       // Remove the offset to search in the ascci table
          lbValue *= _LCDTYPE; // Compensate matrix offset
          
          
          
// ensure bLCD position is in valid limit
          
          lbCounter = _LCDTYPE;  //number of writings to complete one char
          while (lbCounter--  && bLCD_CharPosition < _CHARNUM )
          {
                    lbpLCDWF =  bpaPlace[lbCounter + bLCD_CharPosition*_LCDTYPE] ;
                    char_val = baAscii[lbValue + lbCounter];
                    *lbpLCDWF = char_val ;
          }

          bLCD_CharPosition++; //point to next Char position to write

}



/*
void vfnLCD_All_Segments_ON (void)
{              
          byte lbCounter = _CHARNUM * _LCDTYPE;
          byte *lbpLCDWF;
          
          while (lbCounter --)
          {
              lbpLCDWF  = bpaPlace[lbCounter]; //Fail it is loading the                                                                    //Point to the Waveform
              *lbpLCDWF = _ALLON;                                                                                      //All the segments on
          }
}
*/

void vfnLCD_All_Segments_ON (void)
{              
byte lbCounter = _CHARNUM * _LCDTYPE;
          byte *lbpLCDWF;

          while (lbCounter --)
          {
              lbpLCDWF  = bpaPlace[0] + lbCounter; //Fail it is loading the                                                                    //Point to the Waveform
              *lbpLCDWF = _ALLON;                                                                                      //All the segments on
          }
          
}


void vfnLCD_All_Segments_OFF (void)
{              
byte lbCounter = _CHARNUM * _LCDTYPE;
          byte *lbpLCDWF;

          while (lbCounter --)
          {
              lbpLCDWF  = bpaPlace[0] + lbCounter; //Fail it is loading the                                                                    //Point to the Waveform
              *lbpLCDWF = 0;                                                                                      //All the segments on
          }
          
          
}
