/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name:  intflash.ld$
*
* $Date: $
*
* $Version: $
*
* Description: MPC5604B Linker Command File for Internal FLASH
*
*******************************************************************************/
MEMORY {
    /* 512k Internal Flash */
    flash_rsvd1       : ORIGIN = 0x00000000, LENGTH = 8
    flash_memory      : ORIGIN = .,          LENGTH = 0x20000 - 8
    flash_vec         : ORIGIN = 0x00020000, LENGTH = 0x0D00
    flash_pbcan_cfg   : ORIGIN = 0x00060D00, LENGTH = 0x0100
    flash_pbcan_data  : ORIGIN = 0x00060E00, LENGTH = 0x0200
    flash_pbadc_cfg   : ORIGIN = 0x00070D00, LENGTH = 0x0100
    flash_pbadc_data  : ORIGIN = 0x00070E00, LENGTH = 0x0200
    flash_pbport_cfg  : ORIGIN = 0x00071000, LENGTH = 0x0100
    flash_pbport_data : ORIGIN = 0x00071100, LENGTH = 0x0200
    flash_pbgpt_cfg   : ORIGIN = 0x00071300, LENGTH = 0x0100
    flash_pbgpt_data  : ORIGIN = 0x00071400, LENGTH = 0x0200
    flash_pbicu_cfg   : ORIGIN = 0x00071600, LENGTH = 0x0100
    flash_pbicu_data  : ORIGIN = 0x00071700, LENGTH = 0x0200
    flash_pbpwm_cfg   : ORIGIN = 0x00071900, LENGTH = 0x0100
    flash_pbpwm_data  : ORIGIN = 0x00071a00, LENGTH = 0x0200
    flash_pbfls_cfg   : ORIGIN = 0x00071c00, LENGTH = 0x0100
    flash_pbfls_data  : ORIGIN = 0x00071d00, LENGTH = 0x0200
    flash_pbfee_cfg   : ORIGIN = 0x00071f00, LENGTH = 0x0100
    flash_pbfee_data  : ORIGIN = 0x00072000, LENGTH = 0x0200
    flash_pbspi_cfg   : ORIGIN = 0x00072200, LENGTH = 0x0100
    flash_pbspi_data  : ORIGIN = 0x00072300, LENGTH = 0x0200
    flash_pbmcu_cfg   : ORIGIN = 0x00072500, LENGTH = 0x0200
    flash_pbmcu_data  : ORIGIN = 0x00072700, LENGTH = 0x0100
    flash_pbwdg_cfg   : ORIGIN = 0x00072800, LENGTH = 0x0100
    flash_pbwdg_data  : ORIGIN = 0x00072900, LENGTH = 0x0200
    flash_pbfr_cfg    : ORIGIN = 0x00072B00, LENGTH = 0x0400
    flash_pbfr_data   : ORIGIN = 0x00072F00, LENGTH = 0x0800
    flash_pblin_cfg   : ORIGIN = 0x00073B00, LENGTH = 0x0400
    flash_pblin_data  : ORIGIN = 0x00073F00, LENGTH = 0x0800
    flash_rsvd2       : ORIGIN = .,          LENGTH = 0 

    /* 64KB of internal SRAM */
    ram_rsvd1    :     ORIGIN = 0x40000000, LENGTH = 0
    int_sram     :     ORIGIN = 0x40000000, LENGTH = 0x3000
    fr_memory    :     ORIGIN = 0x40003000, LENGTH = 0x3000
    int_results  :     ORIGIN = 0x40006000, LENGTH = 0x1000
    iram_stack   :     ORIGIN = 0x40007000, LENGTH = 0x1000
    ram_rsvd2    :     ORIGIN = .,          LENGTH = 0
}

//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0         	ABS   : > int_sram
    .PPC.EMB.sbss0        	CLEAR ABS : > .
    .sdabase         	  	ALIGN(8)  : > .
    .sdata                            : > .
    .sbss                             : > .
    .data                             : > .
    .bss                              : > .
    .stack                	ALIGN(16) : > .

//
// ROM SECTIONS
//
    .rcw                        : > flash_rsvd1
    .text                       : > flash_memory
    .vletext                    : > .
    .rodata                     : > .
    .syscall                    : > .
    .sdata2                     : > .
    .secinfo                    : > .
    .fixaddr                    : > .
    .fixtype                    : > .

    .ROM.PPC.EMB.sdata0        ROM(.PPC.EMB.sdata0) : > .
    .ROM.sdata                          ROM(.sdata) : > .
    .ROM.data                            ROM(.data) : > .

    .pbcan_cfg                  : > flash_pbcan_cfg
    .pbcan_data                 : > flash_pbcan_data
    .pbadc_cfg                  : > flash_pbadc_cfg
    .pbadc_data                 : > flash_pbadc_data
    .pbport_cfg                 : > flash_pbport_cfg
    .pbport_data                : > flash_pbport_data
    .pbgpt_cfg                  : > flash_pbgpt_cfg
    .pbgpt_data                 : > flash_pbgpt_data
    .pbicu_cfg                  : > flash_pbicu_cfg
    .pbicu_data                 : > flash_pbicu_data
    .pbpwm_cfg                  : > flash_pbpwm_cfg
    .pbpwm_data                 : > flash_pbpwm_data
    .pbfls_cfg                  : > flash_pbfls_cfg
    .pbfls_data                 : > flash_pbfls_data
    .pbfee_cfg                  : > flash_pbfee_cfg
    .pbfee_data                 : > flash_pbfee_data
    .pbspi_cfg                  : > flash_pbspi_cfg
    .pbspi_data                 : > flash_pbspi_data
    .pbmcu_cfg                  : > flash_pbmcu_cfg
    .pbmcu_data                 : > flash_pbmcu_data
    .pbwdg_cfg                  : > flash_pbwdg_cfg
    .pbwdg_data                 : > flash_pbwdg_data
    .pbfr_cfg                   : > flash_pbfr_cfg
    .pbfr_data                  : > flash_pbfr_data
    .pblin_cfg                  : > flash_pblin_cfg
    .pblin_data                 : > flash_pblin_data
//    .xcptn      ALIGN(0x1000) : > flash_vec
    .isrvectbl    ALIGN(0x1000) : > flash_vec


//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(ram_rsvd1);
    __ghs_ramend    = MEMENDADDR(ram_rsvd2);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

    __IV_ADDR       = MEMADDR(flash_vec);
    
    PB_ADC_CFG1     = MEMADDR(flash_pbadc_cfg);
    PB_WDG_CFG1     = MEMADDR(flash_pbwdg_cfg);
    PB_MCU_CFG1     = MEMADDR(flash_pbmcu_cfg);
    PB_SPI_CFG1     = MEMADDR(flash_pbspi_cfg);
    PB_FEE_CFG1     = MEMADDR(flash_pbfee_cfg);
    PB_FLS_CFG1     = MEMADDR(flash_pbfls_cfg);
    PB_PORT_CFG1    = MEMADDR(flash_pbport_cfg);
    PB_GPT_CFG1     = MEMADDR(flash_pbgpt_cfg);
    PB_ICU_CFG1     = MEMADDR(flash_pbicu_cfg);
    PB_PWM_CFG1     = MEMADDR(flash_pbpwm_cfg);
    PB_FR_CFG1      = MEMADDR(flash_pbfr_cfg);

    INT_SRAM_START  = ADDR(int_sram);
    INT_SRAM_SIZE   = 32K/128;                        // Init 128 bytes at a time
    SBSS_SRAM_START = ADDR(.sbss);
    SBSS_SRAM_SIZE  = (SIZEOF(.sbss)+3)/4;            // Init 4 bytes at a time
    BSS_SRAM_START  = ADDR(.bss);
    BSS_SRAM_SIZE   = (SIZEOF(.bss)+3)/4;             // Init 4 bytes at a time
    SDATA_RW_START  = ADDR(.sdata);
    SDATA_RO_START  = ADDR(.sdata2);

    RC_PPC_SDATA2_SRC  = ADDR(.ROM.PPC.EMB.sdata0);
    RC_PPC_SDATA2_DEST = ADDR(.PPC.EMB.sdata0);
    RC_PPC_SDATA2_SIZE = (SIZEOF(.ROM.PPC.EMB.sdata0)+3)/4; // Copy 4 bytes at a time
    RC_SDATA_SRC       = ADDR(.ROM.sdata);
    RC_SDATA_DEST      = ADDR(.sdata);
    RC_SDATA_SIZE      = (SIZEOF(.ROM.sdata)+3)/4;          // Copy 4 bytes at a time
    RC_DATA_SRC        = ADDR(.ROM.data);
    RC_DATA_DEST       = ADDR(.data);
    RC_DATA_SIZE       = (SIZEOF(.ROM.data)+3)/4;           // Copy 4 bytes at a time

    __SP_INIT      = ADDR(iram_stack) + SIZEOF(iram_stack);
    __SP_END       = ADDR(iram_stack);
    __STACK_SIZE   = SIZEOF(iram_stack);

    MEMSEC_0_ADDR  = ADDR(iram_stack);
    MEMSEC_0_SIZE  = 0x20;
}
