/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2007 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name:  Startup_vle.c$
*
* $Date: 2007/12/21 00:13:33 $
*
* $Version:    1.0.2.0$
*
* Design Reference: AUTOSAR_SWS_MCU_Driver.pdf V2.1.0 R2.1 Rev 0014
*
* Description: MPC5516 Startup Code VLE
*
*******************************************************************************/
void StartupCode(void)
{
/*****************************************************/
/* Skip normal entry point as nothing is initialized */
/*****************************************************/
    asm(" .globl _start");
    asm("_start:");

/******************************************************************/
/* Autosar Guidance 3 - The start-up code shall initialize the    */
/* user stack pointer. The user stack pointer base address and    */
/* the stack size are provided as configuration parameter or      */
/* linker/locator setting.                                        */
/******************************************************************/
    asm(" e_lis   r1, __SP_INIT@h");
    asm(" e_or2i    r1, __SP_INIT@l");

/******************************************************************/
/* Autosar Guidance 13 - The start-up code shall initialize a     */
/* minimum amount of RAM in order to allow proper execution of    */
/* the MCU driver services and the caller of these services.      */
/******************************************************************/
/* MPC55xx - internal ram must be initialized for error correction*/
/******************************************************************/
#if 1
//#ifndef SINTRAM    /* SINTRAM defined by compiler option -DSINTRAM only for INTRAM build */
     asm(" e_lis   r5, INT_SRAM_SIZE@h");     /* Number of 128 byte segments */
     asm(" e_or2i    r5, INT_SRAM_SIZE@l"); /* Number of 128 byte segments */
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* start address of the internal SRAM */
     asm(" e_lis   r5,INT_SRAM_START@h");
     asm(" e_or2i    r5, INT_SRAM_START@l");

/* Repeat */
     asm("sram_loop:");
     asm(" e_stmw  r0,0(r5)"); /* write all 32 registers to L2RAM */
     asm(" e_addi  r5,r5,128"); /* increment the ram ptr */
     asm(" e_bdnz   sram_loop"); /* loop for 64k of L2RAM */
//#endif
#endif

/************************/
/* Erase ".sbss Section" */
/************************/
     asm(" e_lis  r5, SBSS_SRAM_SIZE@h");       /* Number of words */
     asm(" e_or2i   r5, SBSS_SRAM_SIZE@l");   /* Number of words */
     asm(" or.  r5, r5, r5");                 /* Number of words */
     asm(" e_beq    sram_erase1");
     asm(" se_mtctr r5");                        /* configure control register for use with e_bdnz */

/* start address of the sbss section */
     asm(" e_lis   r5,SBSS_SRAM_START@h");
     asm(" e_or2i    r5, SBSS_SRAM_START@l");
     asm(" xor   r0, r0, r0 ");
     asm(" e_subi  r5,r5,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("sram_loop1:");
     asm(" e_stwu   r0,4(r5)");                 /* write 0 to RAM and update r5 address */
     asm(" e_bdnz   sram_loop1");
     asm("sram_erase1:");

/************************/
/* Erase ".bss Section" */
/************************/
     asm(" e_lis   r5, BSS_SRAM_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, BSS_SRAM_SIZE@l");  /* Number of words */
     asm(" or.   r5, r5, r5");               /* Number of words */
     asm(" e_beq   sram_erase2");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* start address of the bss section */
     asm(" e_lis   r5, BSS_SRAM_START@h");
     asm(" e_or2i    r5, BSS_SRAM_START@l");
     asm(" e_subi  r5,r5,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("sram_loop2:");
     asm(" e_stwu r0,4(r5)");                  /* write 0 to RAM and update r5 address, r0 must be zero */
     asm(" e_bdnz   sram_loop2");
     asm("sram_erase2:");

/******************************************************************/
/* Copy  initialized data from Flash to SRAM                      */
/******************************************************************/
/*******************/
/* .PPC.EMB.sdata0 */
/*******************/
     asm(" e_lis   r5, RC_PPC_SDATA2_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_PPC_SDATA2_SIZE@l");  /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy1");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_PPC_SDATA2_SRC@h");
     asm(" e_or2i    r8, RC_PPC_SDATA2_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_PPC_SDATA2_DEST@h");
     asm(" e_or2i    r9, RC_PPC_SDATA2_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop1:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop1");
    asm("data_copy1:");
/**********/
/* .sdata */
/**********/
     asm(" e_lis   r5, RC_SDATA_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_SDATA_SIZE@l");      /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy2");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_SDATA_SRC@h");
     asm(" e_or2i    r8, RC_SDATA_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_SDATA_DEST@h");
     asm(" e_or2i    r9, RC_SDATA_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop2:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop2");
     asm("data_copy2:");
/**********/
/* .data */
/**********/
     asm(" e_lis   r5, RC_DATA_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_DATA_SIZE@l");      /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy3");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_DATA_SRC@h");
     asm(" e_or2i    r8, RC_DATA_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_DATA_DEST@h");
     asm(" e_or2i    r9, RC_DATA_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop3:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop3");
     asm("data_copy3:");

/*********************************/
/* Set the small ro data pointer */
/*********************************/
     asm(" e_lis   r2, SDATA_RO_START@h");
     asm(" e_or2i    r2, SDATA_RO_START@l");

/*********************************/
/* Set the small rw data pointer */
/*********************************/
     asm(" e_lis   r13, SDATA_RW_START@h");
     asm(" e_or2i    r13, SDATA_RW_START@l");

/******************************************************************/
/* Call Main Routine                                              */
/******************************************************************/
     /* Prepare a terminating stack record. */
     asm (" e_li r0, -1");
     asm (" e_stwu r1, -8(r1)"); /* Decrement stack by 8 bytes, (write word) */
     asm (" e_stw  r0, 4(r1)");  /* Make an illegal return address of 0xFFFFFFFF */
     asm (" e_stw  r0, 0(r1)");  /* Make an illegal back chain address of 0xFFFFFFFF */

     main();

     while (1)
     {
     }
}
