/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      ctu.h
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     CTU routines.
*
******************************************************************************/

/******************************************************************************
* Include
******************************************************************************/

#include "jdp.h"
#include "ctu.h"

/***************************************************************************//*!
*
* @brief   CTU initialization.
*
* @return  N/A
*
******************************************************************************/

void Mcu_Ctu_Init(void)
{
	// EMIOS[1] triggers ADC ANP[0]
	CTU.EVTCFGR[1].R = 0x00008000;
	CTU.EVTCFGR[1].B.CHANNELVALUE = 0;

	// EMIOS[3] triggers ADC ANP[1]
	CTU.EVTCFGR[3].R = 0x00008000;
	CTU.EVTCFGR[3].B.CHANNELVALUE = 1;

	// EMIOS[5] triggers ADC ANP[2]
	CTU.EVTCFGR[5].R = 0x00008000;
	CTU.EVTCFGR[5].B.CHANNELVALUE = 2;
}
