/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      adc.c
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     ADC 0 routines.
*
******************************************************************************/

/******************************************************************************
* Include
******************************************************************************/

#include "jdp.h"
#include "adc.h"
#include "gpio.h"

/***************************************************************************//*!
*
* @brief   ADC 0 init.
*
* @return  N/A
*
******************************************************************************/
void Mcu_Adc_0_Init(void)
{
	// Init configuration registers, ADCclk = 64MHz/2 = 32MHz
	// Clear MCR regidte, Disable power down
	ADC.MCR.R = 0;
	// Converted data overwritten by a new conversion
	ADC.MCR.B.OWREN = 1;
	// Right aligned data
	ADC.MCR.B.WLSIDE = 0;
	// One shot conversion mode
	ADC.MCR.B.MODE = 0;
	// Enable CTU
	ADC.MCR.B.CTUEN = 1;

	// Reset NCMR registers
    ADC.NCMR[0].R = 0x00000000;
    ADC.NCMR[1].R = 0x00000000;
    ADC.NCMR[2].R = 0x00000000;

    // Configure ANP[0] to normal mode
    ADC.NCMR[0].B.CH0 = 1;
    // Configure ANP[1] to normal mode
    ADC.NCMR[0].B.CH1 = 1;
    // Configure ANP[2] to normal mode
    ADC.NCMR[0].B.CH2 = 1;

    // Conversion timing registers
    // ANP[x], 1.126us @ 32MHz (Teval ~ 938ns, Tsample ~ 172ns)
    ADC.CTR[0].R = 0x00008C06;
    // ANS[x], 1.126us @ 32MHz (Teval ~ 938ns, Tsample ~ 172ns)
    ADC.CTR[1].R = 0x00008C06;
    // ANX[x], 1.126us @ 32MHz (Teval ~ 938ns, Tsample ~ 172ns)
    ADC.CTR[2].R = 0x00008C06;
}

/***************************************************************************//*!
*
* @brief   Read ADC 0 AN[x] channel data
*
* @return  N/A
*
******************************************************************************/

vuint16_t Mcu_Adc_0_Data(vuint8_t ch)
{
	return (ADC.CDR[ch].B.CDATA);
}
