/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      mcu.h
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     MCU init related function.
*
******************************************************************************/

#ifndef _TIME_H_
#define _TIME_H_

/******************************************************************************
* Include
******************************************************************************/

#include "typedefs.h"

/******************************************************************************
* Defines
******************************************************************************/

#define   DELAY_4mS     40000

/******************************************************************************
* Function Prototypes
******************************************************************************/

// Enable peripherals and initialize system clock
void Mcu_Per_Enb_Osc_Init(void);

// Disable MCU Watchdog
void Wd_Disable(void);

// Initialize MCU interrupts
void MCU_Int_Init(void);

// ~4 ms software delay loop
void Delay_4ms(void);


#endif /* _TIME_H_ */


