/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE SEMICONDUCTOR "AS IS" AND ANY
* EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED.  IN NO EVENT SHALL FREESCALE SEMICONDUCTOR OR ITS CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      main.c
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     MPC5604B Lighting Application Demonstration.
*
*******************************************************************************/

/******************************************************************************
* Include
******************************************************************************/

#include "main.h"
#include "typedefs.h"
#include "jdp.h"
#include "adc.h"
#include "ctu.h"
#include "emios.h"
#include "gpio.h"
#include "mcu.h"
#include "pin.h"

/******************************************************************************
* External objects
******************************************************************************/

// Vector Table
extern const vuint32_t IntcIsrVectorTable[];

/******************************************************************************
* Global variables
******************************************************************************/

// Channels parameters array
extern chPar ch[];

/******************************************************************************
* Local variables
******************************************************************************/

// ADC 0 ANP[0], ANP[1], ANP[2] data
vuint16_t data0, data1, data2;

/***************************************************************************//*!
*
* @brief   Control on board LED2, LED3, LED4.
*
* @return  N/A
*
******************************************************************************/

void Board_Led_Ctrl(vuint16_t data)
{
	// Control on board LEDs
	if(data <= THR1)
	{
		LED2 = 1;
		LED3 = 1;
		LED4 = 1;
	}
	else if ((data > THR1) && (data <= THR2))
	{
		LED2 = 0;
		LED3 = 1;
		LED4 = 1;
	}
	else if ((data > THR2) && (data <= THR3))
	{
		LED2 = 0;
		LED3 = 0;
		LED4 = 1;
	}
	else
	{
		LED2 = 0;
		LED3 = 0;
		LED4 = 0;
	}
}

/***************************************************************************//*!
*
* @brief   Init: OSC, PLL, I/O, eMIOS, ADC, CTU.
*
* @return  N/A
*
******************************************************************************/

void Mcu_Init(void)
{
	// Enable peripherals, system clock initialization
	Mcu_Per_Enb_Osc_Init();

	// Interrupt related initialization
	//MCU_Int_Init();

	// Configure I/O ports
	Mcu_Pin_Config();

	// EMIOS initialization
	Mcu_Emios_0_Init();

	// ADC 0 initialization
	Mcu_Adc_0_Init();

	// CTU initialization
	Mcu_Ctu_Init();
}

/***************************************************************************//*!
*
* @brief   Main function.
*
* @return  N/A
*
******************************************************************************/

void main(void)
{
	// Disable Watchdog
	Wd_Disable();

	// Init MCU: OSC, PLL, I/O, ADC0, eMIOS0, CTU
	Mcu_Init();

	// Turn ON LED1
	LED1 = 0;

	// Enable interrupts
	//ENABLE_INTERRUPTS();

	// Main Loop
	while(1)
	{
		// Read PWM1 data (ADC ANP[0], EMIOS[1])
		data0 = Mcu_Adc_0_Data(0);

		// Control on board LEDs based on W1 trimmer value
		Board_Led_Ctrl(data0);

		// Channel PWM1 parameters
		// Period 100Hz
		ch[PWM1].perSel = 100;
		// Leading edge at begin of counting cycle
		ch[PWM1].startDelayTime = 0;
		// Duty cycle 50%
		ch[PWM1].dutyCycle = 100;
		// ADC trigger point 25%
		ch[PWM1].triggerAdc = 50;

		// Configure eMIOS channel PWM1
		Mcu_Emios_0_Channel_OPWMT_Init(PWM1);
	} // While
} // Main
