/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      pin.c
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     MCU pins function control.
*
******************************************************************************/

/******************************************************************************
* Include
******************************************************************************/

#include "jdp.h"
#include "pin.h"

/***************************************************************************//*!
*
* @brief   MCU pins function control.
*
* @return  N/A
*
******************************************************************************/

void Mcu_Pin_Config(void)
{
	/************************************************************/
	/*  Port A                                                  */
	/*                                                          */
	/*  RST   0x0000   Initial state                            */
	/*  GPI   0x0100   GP Input mode                            */
	/*  GPO   0x0200   GP Output mode                           */
	/*  F1O   0x0400   Alternative Function 1                   */
	/*  F2O   0x0800   Alternative Function 2                   */
	/*  F3O   0x0C00   Alternative Function 3                   */
	/*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
	/*                                                          */
	/************************************************************/

    SIU.PCR[0].R    = F2O;    /* PA0 - CLKOUT */
    SIU.PCR[1].R    = F1O;    /* PA1 - eMIOS 0, channel 1 */
    SIU.PCR[2].R    = RST;    /* PA2 */
    SIU.PCR[3].R    = F1O;    /* PA3 - eMIOS 0, channel 3 */
    SIU.PCR[4].R    = RST;    /* PA4 */
    SIU.PCR[5].R    = F1O;    /* PA5 - eMIOS 0, channel 5 */
    SIU.PCR[6].R    = RST;    /* PA6 */
    SIU.PCR[7].R    = RST;    /* PA7 */
    SIU.PCR[8].R    = RST;    /* PA8 */
    SIU.PCR[9].R    = RST;    /* PA9 */
    SIU.PCR[10].R   = RST;    /* PA10 */
    SIU.PCR[11].R   = RST;    /* PA11 */
    SIU.PCR[12].R   = RST;    /* PA12 */
    SIU.PCR[13].R   = RST;    /* PA13 */
    SIU.PCR[14].R   = RST;    /* PA14 */
    SIU.PCR[15].R   = RST;    /* PA15 */

    /************************************************************/
    /*  Port B                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[16].R   = RST;    /* PB0 */
    SIU.PCR[17].R   = RST;    /* PB1 */
    SIU.PCR[18].R   = RST;    /* PB2 */
    SIU.PCR[19].R   = RST;    /* PB3 */
    SIU.PCR[20].R   = FAI;    /* PB4 - ANP[0] */
    SIU.PCR[21].R   = FAI;    /* PB5 - ANP[1] */
    SIU.PCR[22].R   = FAI;    /* PB6 - ANP[2] */
    SIU.PCR[23].R   = RST;    /* PB7 */
    SIU.PCR[24].R   = RST;    /* PB8 */
    SIU.PCR[25].R   = RST;    /* PB9 */
    SIU.PCR[26].R   = RST;    /* PB10 */
    SIU.PCR[27].R   = RST;    /* PB11 */
    SIU.PCR[28].R   = RST;    /* PB12 */
    SIU.PCR[29].R   = RST;    /* PB13 */
    SIU.PCR[30].R   = RST;    /* PB14 */
    SIU.PCR[31].R   = RST;    /* PB15 */

    /************************************************************/
    /*  Port C                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    //SIU.PCR[32].R   = RST;    /* PC0 - JTAG TDI */
    //SIU.PCR[33].R   = RST;    /* PC1 - JTAG TDO */
    SIU.PCR[34].R   = RST;    /* PC2 */
    SIU.PCR[35].R   = RST;    /* PC3 */
    SIU.PCR[36].R   = RST;    /* PC4 */
    SIU.PCR[37].R   = RST;    /* PC5 */
    SIU.PCR[38].R   = RST;    /* PC6 */
    SIU.PCR[39].R   = RST;    /* PC7 */
    SIU.PCR[40].R   = RST;    /* PC8 */
    SIU.PCR[41].R   = RST;    /* PC9 */
    SIU.PCR[42].R   = RST;    /* PC10 */
    SIU.PCR[43].R   = RST;    /* PC11 */
    SIU.PCR[44].R   = RST;    /* PC12 */
    SIU.PCR[45].R   = RST;    /* PC13 */
    SIU.PCR[46].R   = RST;    /* PC14 */
    SIU.PCR[47].R   = RST;    /* PC15 */

    /************************************************************/
    /*  Port D                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[48].R   = RST;    /* PD0 */
    SIU.PCR[49].R   = RST;    /* PD1 */
    SIU.PCR[50].R   = RST;    /* PD2 */
    SIU.PCR[51].R   = RST;    /* PD3 */
    SIU.PCR[52].R   = RST;    /* PD4 */
    SIU.PCR[53].R   = RST;    /* PD5 */
    SIU.PCR[54].R   = RST;    /* PD6 */
    SIU.PCR[55].R   = RST;    /* PD7 */
    SIU.PCR[56].R   = RST;    /* PD8 */
    SIU.PCR[57].R   = RST;    /* PD9 */
    SIU.PCR[58].R   = RST;    /* PD10 */
    SIU.PCR[59].R   = RST;    /* PD11 */
    SIU.PCR[60].R   = RST;    /* PD12 */
    SIU.PCR[61].R   = RST;    /* PD13 */
    SIU.PCR[62].R   = RST;    /* PD14 */
    SIU.PCR[63].R   = RST;    /* PD15 */

    /************************************************************/
    /*  Port E                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[64].R   = RST;    /* PE0 */
    SIU.PCR[65].R   = RST;    /* PE1 */
    SIU.PCR[66].R   = RST;    /* PE2 */
    SIU.PCR[67].R   = RST;    /* PE3 */
    SIU.PCR[68].R   = GPO;    /* PE4 - LED1 */
    SIU.PCR[69].R   = GPO;    /* PE5 - LED2 */
    SIU.PCR[70].R   = GPO;    /* PE6 - LED3 */
    SIU.PCR[71].R   = GPO;    /* PE7 - LED4 */
    SIU.PCR[72].R   = RST;    /* PE8 */
    SIU.PCR[73].R   = RST;    /* PE9 */
    SIU.PCR[74].R   = RST;    /* PE10 */
    SIU.PCR[75].R   = RST;    /* PE11 */
    SIU.PCR[76].R   = RST;    /* PE12 */
    SIU.PCR[77].R   = RST;    /* PE13 */
    SIU.PCR[78].R   = RST;    /* PE14 */
    SIU.PCR[79].R   = RST;    /* PE15 */

    /************************************************************/
    /*  Port F                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[80].R   = RST;    /* PF0 */
    SIU.PCR[81].R   = RST;    /* PF1 */
    SIU.PCR[82].R   = RST;    /* PF2 */
    SIU.PCR[83].R   = RST;    /* PF3 */
    SIU.PCR[84].R   = RST;    /* PF4 */
    SIU.PCR[85].R   = RST;    /* PF5 */
    SIU.PCR[86].R   = RST;    /* PF6 */
    SIU.PCR[87].R   = RST;    /* PF7 */
    SIU.PCR[88].R   = RST;    /* PF8 */
    SIU.PCR[89].R   = RST;    /* PF9 */
    SIU.PCR[90].R   = RST;    /* PF10 */
    SIU.PCR[91].R   = RST;    /* PF11 */
    SIU.PCR[92].R   = RST;    /* PF12 */
    SIU.PCR[93].R   = RST;    /* PF13 */
    SIU.PCR[94].R   = RST;    /* PF14 */
    SIU.PCR[95].R   = RST;    /* PF15 */

    /************************************************************/
    /*  Port G                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[96].R   = RST;    /* PG0 */
    SIU.PCR[97].R   = RST;    /* PG1 */
    SIU.PCR[98].R   = RST;    /* PG2 */
    SIU.PCR[99].R   = RST;    /* PG3 */
    SIU.PCR[100].R  = RST;    /* PG4 */
    SIU.PCR[101].R  = RST;    /* PG5 */
    SIU.PCR[102].R  = RST;    /* PG6 */
    SIU.PCR[103].R  = RST;    /* PG7 */
    SIU.PCR[104].R  = RST;    /* PG8 */
    SIU.PCR[105].R  = RST;    /* PG9 */
    SIU.PCR[106].R  = RST;    /* PG10 */
    SIU.PCR[107].R  = RST;    /* PG11 */
    SIU.PCR[108].R  = RST;    /* PG12 */
    SIU.PCR[109].R  = RST;    /* PG13 */
    SIU.PCR[110].R  = RST;    /* PG14 */
    SIU.PCR[111].R  = RST;    /* PG15 */

    /************************************************************/
    /*  Port H                                                  */
    /*                                                          */
    /*  RST   0x0000   Initial state                            */
    /*  GPI   0x0100   GP Input mode                            */
    /*  GPO   0x0200   GP Output mode                           */
    /*  F1O   0x0400   Alternative Function 1                   */
    /*  F2O   0x0800   Alternative Function 2                   */
    /*  F3O   0x0C00   Alternative Function 3                   */
    /*  FXI   0x0100   Alternative Function 1, 2, 3 Input mode  */
	/*  FAI   0x2000   Alternative Function ADC input pin       */
    /*                                                          */
    /************************************************************/

    SIU.PCR[112].R  = RST;    /* PH0 */
    SIU.PCR[113].R  = RST;    /* PH1 */
    SIU.PCR[114].R  = RST;    /* PH2 */
    SIU.PCR[115].R  = RST;    /* PH3 */
    SIU.PCR[116].R  = RST;    /* PH4 */
    SIU.PCR[117].R  = RST;    /* PH5 */
    SIU.PCR[118].R  = RST;    /* PH6 */
    SIU.PCR[119].R  = RST;    /* PH7 */
    SIU.PCR[120].R  = RST;    /* PH8 */
}
