/******************************************************************************
*                                                  COPYRIGHT (c) Freescale 2009
* FILE NAME: stepper_int.h     REVISION 1.0
*                                                                           
* PURPOSE: Contains the Stepper motor driver internal functions
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  

*******************************************************************************
Freescale reserves the right	to make	changes	without	further	notice to any
product	herein to improve reliability, function	or design. Freescale	does not
assume any liability arising out of	the	application	or use of any product,
circuit, or software described	herein;	neither	does it	convey any license
under its patent rights	nor	the	rights of others. Freescale products are	not
designed, intended,	or authorized for use as components	in systems  intended for
surgical implant into the body, or	other applications intended to support life,
or	for	any	other application in which the failure of the  Freescale product
could create a	situation where	personal injury	or death may occur. Should
Buyer	purchase or	use	Freescale products for any such unintended or
unauthorized	application, Buyer shall idemnify and hold Freescale	and	its
officers, employees, subsidiaries, affiliates, and distributors	harmless
against	all	claims costs, damages, and expenses, and reasonable	attorney fees 
arising	out	of,	directly or	indirectly,	any	claim of personal injury or	death
associated with	such unintended	or unauthorized use,	even if	such claim alleges
that Freescale was negligent	regarding the design or	manufacture	of the part.
Freescale and the Freescale logo*	are	registered trademarks of Freescale Ltd.
*******************************************************************************
*******************************************************************************
*
*
* DESCRIPTION:  Internal file for Stepper Motor driver
*
* NOTE:
*
* AUTHOR: Saurabh Jhamb        LOCATION: IDC      LAST EDIT DATE: 09JAN09
*
******************************************************************************/
#ifndef _STEPPER_INT_H_
#define _STEPPER_INT_H_

/****************************************************************************
 * Function Name: motor_micro_update_pwm
 *
 * Agruments:
 * 1.current_pos: It holds motor's current position in number of microsteps
 * 2.direction: It holds the direction in which the specified step is moved
 *
 * Return Type: VOID
 *
 * Description:
 *    It is the function providing movement of stepper motor in 1 microstep
 * that is 1/12 degree in specified direction
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm(unsigned int current_pos, unsigned char direction);

/****************************************************************************
 * Function Name: motor_partial_update_pwm
 *
 * Agruments:
 * 1.current_pos: It holds motor's current position in number of microsteps
 * 2.direction: It holds the direction in which the specified step is moved
 *
 * Return Type: VOID
 *
 * Description:
 *    It is the function providing movement of stepper motor in 1 partialstep
 * that is 1/3 degree in specified direction.
 * If the currentposition is not aligned to a partial step then it takes
 * microsteps to align it to the partial step boundary.
 *
 * 
 ****************************************************************************/
void motor_partial_update_pwm(unsigned int current_pos, unsigned char direction);

/****************************************************************************
 * Function Name: motor_micro_update_pwm_init_speedup
 *
 * Agruments:
 * 1.current_pos: It holds motor's current position in number of microsteps
 * 3.speedlevel: It indicates speed with which to move the stepper motor
 *
 * Return Type: VOID
 *
 * Description:
 *    It is the function providing movement of stepper motor with 1 microstep
 * anticlkwise with increasing speed (max 450degrees/sec) of the pointer
 * It is the routine for a special movement of stepper motor to its ZERO
 * position at start.
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm_init_speedup(unsigned int current_pos, unsigned char speedlevel);

/****************************************************************************
 * Function Name: StepperSpeedUpAntiClkwise
 *
 * Agruments:
 * NONE
 *
 * Return Type: VOID
 *
 * Description:
 *    It is the function providing movement of stepper motor to 308 degrees
 * anticlkwise with increasing speed (max 450degrees/sec) of the pointer
 * It is the routine for a special movement of stepper motor to its ZERO
 * position at start.
 *
 * 
 ****************************************************************************/
void StepperSpeedUpAntiClkwise(void);

/****************************************************************************
 * Function Name: StepperSpeedUpClkwise
 *
 * Agruments:
 * NONE
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 8 degrees clkwise (with increasing speed) as a
 * part of the initial Zero search process.
 *
 * 
 ****************************************************************************/
void StepperSpeedUpClkwise(void);

/****************************************************************************
 * Function Name: motor_micro_update_pwm_speedup_clkwise
 *
 * Agruments:
 * 1.current_pos: It holds the current position of the motor
 * 2.speedlevel: It specifies the speed with which to move the motor
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 1 microstep further with the speed requested and in
 * the clkwise direction
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm_speedup_clkwise(unsigned int current_pos, unsigned char speedlevel);

/****************************************************************************
 * Function Name: Move10DegreesClkwise
 *
 * Agruments:
 * NONE
 *
 * Return Type: VOID
 *
 * Description:
 *    It is the function providing movement of stepper motor to 10 degrees
 * clkwise with intial speed (less than 160degrees/sec) of the pointer
 * It is the routine for a special movement of stepper motor to its ZERO
 * position at start.
 *
 * 
 ****************************************************************************/
void Move10DegreesClkwise(void);

extern unsigned int ShiftedCosTbl4[], CosTbl4[], speedCosTable[][24], shiftedSpeedCosTable[][24];

extern unsigned int num_steps_taken, current_position;
extern unsigned char pin3val, pin2val;
extern unsigned char fullstepmode_partstep, microstep_active, wait;

#endif /* #ifndef _STEPPER_INT_H_ */