/******************************************************************************
*                                                  COPYRIGHT (c) Freescale 2009
* FILE NAME: stepper_int.c     REVISION 1.0
*                                                                           
* PURPOSE: Contains the Stepper motor driver internal APIs
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  

*******************************************************************************
Freescale reserves the right	to make	changes	without	further	notice to any
product	herein to improve reliability, function	or design. Freescale	does not
assume any liability arising out of	the	application	or use of any product,
circuit, or software described	herein;	neither	does it	convey any license
under its patent rights	nor	the	rights of others. Freescale products are	not
designed, intended,	or authorized for use as components	in systems  intended for
surgical implant into the body, or	other applications intended to support life,
or	for	any	other application in which the failure of the  Freescale product
could create a	situation where	personal injury	or death may occur. Should
Buyer	purchase or	use	Freescale products for any such unintended or
unauthorized	application, Buyer shall idemnify and hold Freescale	and	its
officers, employees, subsidiaries, affiliates, and distributors	harmless
against	all	claims costs, damages, and expenses, and reasonable	attorney fees 
arising	out	of,	directly or	indirectly,	any	claim of personal injury or	death
associated with	such unintended	or unauthorized use,	even if	such claim alleges
that Freescale was negligent	regarding the design or	manufacture	of the part.
Freescale and the Freescale logo*	are	registered trademarks of Freescale Ltd.
*******************************************************************************
*******************************************************************************
*
*
* DESCRIPTION:  file for Stepper Motor Driver
*
* NOTE:
*
* AUTHOR: Saurabh Jhamb        LOCATION: IDC      LAST EDIT DATE: 09JAN09
*
******************************************************************************/
#include "stepper_driver.h"

/****************************************************************************
 * Function Name: motor_micro_update_pwm
 *
 * Agruments:
 * 1.current_pos: It holds the current position of the motor
 * 2.direction: it specifies the direction of motor rotation
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 1 microstep further in the direction requested
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm(unsigned int current_pos, unsigned char direction)
{
 	volatile unsigned char	microstep;

  microstep = (current_pos%STEP5);

  if(STEPPER_MOVE_ANTICLKWISE == direction)// direction clockwise
  {
    microstep = (STEP5 - 1 - microstep);
  }
  if((microstep<STEP0))
  {
    if(2 == microstep)//Invert 2- and invert high true pwm pulse to low.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 0;
    PTAD_PTAD5 = 1;
  }
  else if((microstep>=STEP0)&&(microstep<STEP1))
  {
    if(6 == microstep)//Invert 1- and invert high true pwm pulse to low.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 0;
    PTAD_PTAD4 = 1;
  }
  else if((microstep>=STEP1)&&(microstep<STEP2))
  {
    
  }
  else if((microstep>=STEP2)&&(microstep<STEP3))
  {
    if(14 == microstep)//Invert 2- and invert low true pwm pulse to high.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 1;
    PTAD_PTAD5 = 0;
  }
  else if((microstep>=STEP3)&&(microstep<STEP4))
  {
    if(18 == microstep)//Invert 1- and invert low true pwm pulse to high.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 1;
    PTAD_PTAD4 = 0;
  }
  else if((microstep>=STEP4)&&(microstep<STEP5))
  {
    
  }
  // duty cycle will be cos value according to micro step waveform
  TPM1C0V = CosTbl4[microstep];
  TPM1C1V = ShiftedCosTbl4[microstep];
  wait = 1;
}

/****************************************************************************
 * Function Name: motor_partial_update_pwm
 *
 * Agruments:
 * 1.current_pos: It holds the current position of the motor
 * 2.direction: it specifies the direction of motor rotation
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 1 partialstep further in the direction requested
 *
 * 
 ****************************************************************************/
void motor_partial_update_pwm(unsigned int current_pos, unsigned char direction)
{  
  fullstepmode_partstep = (current_pos/4)%6;

  if(STEPPER_MOVE_CLKWISE == direction)// direction check
  {          // direction clockwise
    switch(fullstepmode_partstep)
    {
      case 0:         //partial step 1
        //TPM1C0SC_ELS0x = 0x1;
        //TPM1C1SC_ELS1x = 0x2;
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x1;
        //pin2val = 1;
        //pin3val = 0;
        pin2val = 0;
        pin3val = 1;
        break;
      case 1:         //partial step 2
        //TPM1C0SC_ELS0x = 0x2;
        //TPM1C1SC_ELS1x = 0x2;
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x1;
        //pin2val = 1;
        //pin3val = 0;
        pin2val = 0;
        pin3val = 1;
        break;
      case 2:         //partial step 3
        //TPM1C0SC_ELS0x = 0x2;
        //TPM1C1SC_ELS1x = 0x2;
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x1;
        //pin2val = 0;
        //pin3val = 1;
        pin2val = 1;
        pin3val = 0;
        break;
      case 3:         //partial step 4
        //TPM1C0SC_ELS0x = 0x2;
        //TPM1C1SC_ELS1x = 0x1;
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x2;
        //pin2val = 0;
        //pin3val = 1;
        pin2val = 1;
        pin3val = 0;
        break;
      case 4:         //partial step 5
        //TPM1C0SC_ELS0x = 0x2;
        //TPM1C1SC_ELS1x = 0x1;
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x2;
        //pin2val = 1;
        //pin3val = 1;
        pin2val = 0;
        pin3val = 0;
        break;
      case 5:         //partial step 6
        //TPM1C0SC_ELS0x = 0x1;
        //TPM1C1SC_ELS1x = 0x2;
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x1;
        //pin2val = 1;
        //pin3val = 1;
        pin2val = 0;
        pin3val = 0;
    }
  }
  else          // direction anticlockwise
  {
    switch(fullstepmode_partstep)
    {
      case 5:
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x2;
        pin2val = 1;
        pin3val = 0;
        break;
      case 4:
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x2;
        pin2val = 1;
        pin3val = 0;
        break;
      case 3:
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x2;
        pin2val = 0;
        pin3val = 1;
        break;
      case 2:
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x1;
        pin2val = 0;
        pin3val = 1;
        break;
      case 1:
        TPM1C0SC_ELS0x = 0x2;
        TPM1C1SC_ELS1x = 0x1;
        pin2val = 1;
        pin3val = 1;
        break;
      case 0:
        TPM1C0SC_ELS0x = 0x1;
        TPM1C1SC_ELS1x = 0x2;
        pin2val = 1;
        pin3val = 1;
    }
  }
  wait = 1;
}


void Move10DegreesClkwise()
{
  microstep_active = 1;
  num_steps_taken = 0;

  //Start the already configured TPM and GPIOs
  //PTAD_PTAD4 = 0x1;
  //PTAD_PTAD5 = 0x1;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;
  TPM1MOD = 862;
  TPM1CNT = 0x01;
  TPM1SC_CLKSA = 1;
  
  wait = 1;
  
  while(num_steps_taken < 120)
  {
    while(wait);//cleared by interrupt
    motor_micro_update_pwm(num_steps_taken, STEPPER_MOVE_CLKWISE);

    num_steps_taken++;
  }
  TPM1C0SC_ELS0x = 0x0;
  TPM1C1SC_ELS1x = 0x0;
  TPM1SC_CLKSA = 0x0;
  PTHD_PTHD4 = 0;
  PTFD_PTFD1 = 0;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;

  microstep_active = 0;
  current_position+= num_steps_taken;
}


/****************************************************************************
 * Function Name: StepperSpeedUpAntiClkwise
 *
 * Agruments:
 * NONE
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 8 degrees anticlkwise (with increasing speed) as a
 * part of the initial Zero search process.
 *
 * 
 ****************************************************************************/
void StepperSpeedUpAntiClkwise()
{
  unsigned char speedlevel = 0;
  
  while(speedlevel<8)
  {
    microstep_active = 1;
    num_steps_taken = 0;

    //Start the already configured TPM and GPIOs
    //PTAD_PTAD4 = 0x1;
    //PTAD_PTAD5 = 0x1;
    PTAD_PTAD4 = 0x0;
    PTAD_PTAD5 = 0x0;
    TPM1MOD = speedCosTable[speedlevel][0];
    TPM1CNT = 0x01;
    TPM1C0SC_ELS0x = 0x1;
    TPM1C1SC_ELS1x = 0x1;
    TPM1SC_CLKSA = 1;
    
    wait = 1;
    
    while(num_steps_taken < 12)
    {
      while(wait);//cleared by interrupt
      motor_micro_update_pwm_init_speedup(current_position + num_steps_taken, speedlevel);
      //direction always anticlockwise

      num_steps_taken++;
    }
    current_position+= num_steps_taken;
    speedlevel++;
  }
  
  //now 300 degrees anticlkwise
  num_steps_taken = 0;

  //Start the already configured TPM and GPIOs
  //PTAD_PTAD4 = 0x1;
  //PTAD_PTAD5 = 0x1;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;
  TPM1MOD = speedCosTable[7][0];
  TPM1CNT = 0x01;
  TPM1C0SC_ELS0x = 0x1;
  TPM1C1SC_ELS1x = 0x1;
  TPM1SC_CLKSA = 1;
  
  wait = 1;
  
  while(num_steps_taken < 3600)
  {
    while(wait);//cleared by interrupt
    motor_micro_update_pwm_init_speedup(current_position + num_steps_taken, 7);
    //direction always anticlockwise

    num_steps_taken++;
  }
  //switch off the TPM and GPIO waveform to 0.
  TPM1C0SC_ELS0x = 0x0;
  TPM1C1SC_ELS1x = 0x0;
  TPM1SC_CLKSA = 0x0;
  PTHD_PTHD4 = 0;
  PTFD_PTFD1 = 0;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;
  current_position = 0;
  microstep_active = 0;
}

/****************************************************************************
 * Function Name: StepperSpeedUpClkwise
 *
 * Agruments:
 * NONE
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 8 degrees clkwise (with increasing speed) as a
 * part of the initial Zero search process.
 *
 * 
 ****************************************************************************/
void StepperSpeedUpClkwise()
{
  unsigned char speedlevel = 0;
  
  while(speedlevel<8)
  {
    microstep_active = 1;
    num_steps_taken = 0;

    //Start the already configured TPM and GPIOs
    //PTAD_PTAD4 = 0x1;
    //PTAD_PTAD5 = 0x1;
    PTAD_PTAD4 = 0x0;
    PTAD_PTAD5 = 0x0;
    TPM1MOD = speedCosTable[speedlevel][0];
    TPM1CNT = 0x01;
    TPM1C0SC_ELS0x = 0x1;
    TPM1C1SC_ELS1x = 0x1;
    TPM1SC_CLKSA = 1;
    
    wait = 1;
    
    while(num_steps_taken < 12)
    {
      while(wait);//cleared by interrupt
      motor_micro_update_pwm_speedup_clkwise(current_position + num_steps_taken, speedlevel);
      //direction always clockwise

      num_steps_taken++;
    }
    current_position+= num_steps_taken;
    speedlevel++;
  }
  
  //now 300 degrees clkwise
  num_steps_taken = 0;

  //Start the already configured TPM and GPIOs
  //PTAD_PTAD4 = 0x1;
  //PTAD_PTAD5 = 0x1;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;
  TPM1MOD = speedCosTable[7][0];
  TPM1CNT = 0x01;
  TPM1C0SC_ELS0x = 0x1;
  TPM1C1SC_ELS1x = 0x1;
  TPM1SC_CLKSA = 1;
  
  wait = 1;
  
  while(num_steps_taken < 3600)
  {
    while(wait);//cleared by interrupt
    motor_micro_update_pwm_speedup_clkwise(current_position + num_steps_taken, 7);
    //direction always clockwise

    num_steps_taken++;
  }
  //switch off the TPM and GPIO waveform to 0.
  TPM1C0SC_ELS0x = 0x0;
  TPM1C1SC_ELS1x = 0x0;
  TPM1SC_CLKSA = 0x0;
  PTHD_PTHD4 = 0;
  PTFD_PTFD1 = 0;
  PTAD_PTAD4 = 0x0;
  PTAD_PTAD5 = 0x0;
  microstep_active = 0;
}

/****************************************************************************
 * Function Name: motor_micro_update_pwm_speedup_clkwise
 *
 * Agruments:
 * 1.current_pos: It holds the current position of the motor
 * 2.speedlevel: It specifies the speed with which to move the motor
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 1 microstep further with the speed requested and in
 * the clkwise direction
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm_speedup_clkwise(unsigned int current_pos, unsigned char speedlevel)
{
 	unsigned char	microstep;

  microstep = (current_pos%STEP5);

  if((microstep<STEP0))
  {
    if(2 == (23-microstep))//Invert 2- and invert high true pwm pulse to low.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 0;
    PTAD_PTAD5 = 1;
  }
  else if((microstep>=STEP0)&&(microstep<STEP1))
  {
    if(6 == microstep)//Invert 1- and invert high true pwm pulse to low.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 0;
    PTAD_PTAD4 = 1;
  }
  else if((microstep>=STEP1)&&(microstep<STEP2))
  {
    
  }
  else if((microstep>=STEP2)&&(microstep<STEP3))
  {
    if(14 == microstep)//Invert 2- and invert low true pwm pulse to high.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 1;
    PTAD_PTAD5 = 0;
  }
  else if((microstep>=STEP3)&&(microstep<STEP4))
  {
    if(18 == microstep)//Invert 1- and invert low true pwm pulse to high.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 1;
    PTAD_PTAD4 = 0;
  }
  else if((microstep>=STEP4)&&(microstep<STEP5))
  {
    
  }
  //select the duty cycle based on speedlevel and number of microstep
  TPM1C0V = speedCosTable[speedlevel][microstep];
  TPM1C1V = shiftedSpeedCosTable[speedlevel][microstep];
  wait = 1;
}

/****************************************************************************
 * Function Name: motor_micro_update_pwm_init_speedup
 *
 * Agruments:
 * 1.current_pos: It holds the current position of the motor
 * 2.speedlevel: It specifies the speed with which to move the motor
 *
 * Return Type: VOID
 *
 * Description:
 *    It moves the motor 1 microstep further with the speed requested and in
 * the anticlkwise direction
 *
 * 
 ****************************************************************************/
void motor_micro_update_pwm_init_speedup(unsigned int current_pos, unsigned char speedlevel)
{
 	unsigned char	microstep;

  microstep = (STEP5 - 1 - (current_pos%STEP5));

  if((microstep<STEP0))
  {
    if(2 == (23-microstep))//Invert 2- and invert high true pwm pulse to low.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 0;
    PTAD_PTAD5 = 1;
  }
  else if((microstep>=STEP0)&&(microstep<STEP1))
  {
    if(6 == microstep)//Invert 1- and invert high true pwm pulse to low.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 0;
    PTAD_PTAD4 = 1;
  }
  else if((microstep>=STEP1)&&(microstep<STEP2))
  {
    
  }
  else if((microstep>=STEP2)&&(microstep<STEP3))
  {
    if(14 == microstep)//Invert 2- and invert low true pwm pulse to high.
    TPM1C1SC_ELS1x = ~TPM1C1SC_ELS1x;
    //PTAD_PTAD5 = 1;
    PTAD_PTAD5 = 0;
  }
  else if((microstep>=STEP3)&&(microstep<STEP4))
  {
    if(18 == microstep)//Invert 1- and invert low true pwm pulse to high.
    TPM1C0SC_ELS0x = ~TPM1C0SC_ELS0x;
    //PTAD_PTAD4 = 1;
    PTAD_PTAD4 = 0;
  }
  else if((microstep>=STEP4)&&(microstep<STEP5))
  {
    
  }
  //select the duty cycle based on speedlevel and number of microstep
  TPM1C0V = speedCosTable[speedlevel][microstep];
  TPM1C1V = shiftedSpeedCosTable[speedlevel][microstep];
  wait = 1;
}