/******************************************************************************
*                                                  COPYRIGHT (c) Freescale 2009
* FILE NAME: stepper_data.c     REVISION 1.0
*                                                                           
* PURPOSE: Contains the Stepper motor driver external APIs
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  

*******************************************************************************
Freescale reserves the right	to make	changes	without	further	notice to any
product	herein to improve reliability, function	or design. Freescale	does not
assume any liability arising out of	the	application	or use of any product,
circuit, or software described	herein;	neither	does it	convey any license
under its patent rights	nor	the	rights of others. Freescale products are	not
designed, intended,	or authorized for use as components	in systems  intended for
surgical implant into the body, or	other applications intended to support life,
or	for	any	other application in which the failure of the  Freescale product
could create a	situation where	personal injury	or death may occur. Should
Buyer	purchase or	use	Freescale products for any such unintended or
unauthorized	application, Buyer shall idemnify and hold Freescale	and	its
officers, employees, subsidiaries, affiliates, and distributors	harmless
against	all	claims costs, damages, and expenses, and reasonable	attorney fees 
arising	out	of,	directly or	indirectly,	any	claim of personal injury or	death
associated with	such unintended	or unauthorized use,	even if	such claim alleges
that Freescale was negligent	regarding the design or	manufacture	of the part.
Freescale and the Freescale logo*	are	registered trademarks of Freescale Ltd.
*******************************************************************************
*******************************************************************************
*
*
* DESCRIPTION:  file for Stepper Motor Driver containing global variables
*
* NOTE:
*
* AUTHOR: Saurabh Jhamb        LOCATION: IDC      LAST EDIT DATE: 09JAN09
*
******************************************************************************/

const unsigned int ShiftedCosTbl4[24]={431, 222, 0, 222, 431, 609, 747, 832,\
 						            862, 832, 747, 609, 431, 222, 0, 222,\
 						            431, 609, 747, 832, 862, 832, 747, 609};
 						            //COS values ={1, 0.965, 0.866, 0.707, 0.5, 0.258, 0}

const unsigned int CosTbl4[24]={862, 832, 747, 609, 431, 222, 0, 222, 431,\
                        609, 747, 832, 862, 832, 747, 609, 431,\
                        222, 0, 222, 431, 609, 747, 832};
                        //COS values ={1, 0.965, 0.866, 0.707, 0.5, 0.258, 0}

const unsigned int speedCosTable[][24] = 
{
{
1796, 1733, 1555, 1270, 898, 463, 0, 463, 898, 1270, 1555, 1733,   //160
1796, 1733, 1555, 1270, 898, 463, 0, 463, 898, 1270, 1555, 1733
},

{
1149, 1110, 995, 812, 575, 296, 0, 296, 575, 812, 995, 1110,      //250
1149, 1110, 995, 812, 575, 296, 0, 296, 575, 812, 995, 1110
},

{
927, 895, 803, 655, 464, 239, 0, 239, 464, 655, 803, 895,       //310
927, 895, 803, 655, 464, 239, 0, 239, 464, 655, 803, 895
},

{
798, 771, 691, 564, 399, 206, 0, 206, 399, 564, 691, 770,       //360
798, 771, 691, 564, 399, 206, 0, 206, 399, 564, 691, 770
},

{
737, 712, 638, 521, 369, 190, 0, 190, 369, 521, 638, 712,       //390
737, 712, 638, 521, 369, 190, 0, 190, 369, 521, 638, 712
},

{
684, 661, 592, 484, 342, 176, 0, 176, 342, 484, 592, 661,       //420
684, 661, 592, 484, 342, 176, 0, 176, 342, 484, 592, 661
},

{
653, 631, 565, 462, 327, 168, 0, 168, 327, 462, 565, 631,       //440
653, 631, 565, 462, 327, 168, 0, 168, 327, 462, 565, 631
},

{
639, 617, 553, 452, 320, 165, 0, 165, 320, 452, 617, 639,       //450
639, 617, 553, 452, 320, 165, 0, 165, 320, 452, 617, 639
}
};

const unsigned int shiftedSpeedCosTable[][24] = 
{
{
898, 463, 0, 463, 898, 1270, 1555, 1733,   //160
1796, 1733, 1555, 1270, 898, 463, 0, 463,
898, 1270, 1555, 1733, 1796, 1733, 1555, 1270
},

{
575, 296, 0, 296, 575, 812, 995, 1110,      //250
1149, 1110, 995, 812, 575, 296, 0, 296,
575, 812, 995, 1110, 1149, 1110, 995, 812
},

{
464, 239, 0, 239, 464, 655, 803, 895,       //310
927, 895, 803, 655, 464, 239, 0, 239,
464, 655, 803, 895, 927, 895, 803, 655
},

{
399, 206, 0, 206, 399, 564, 691, 770,       //360
798, 771, 691, 564, 399, 206, 0, 206,
399, 564, 691, 770, 798, 771, 691, 564
},

{
369, 190, 0, 190, 369, 521, 638, 712,       //390
737, 712, 638, 521, 369, 190, 0, 190,
369, 521, 638, 712, 737, 712, 638, 521
},

{
342, 176, 0, 176, 342, 484, 592, 661,       //420
684, 661, 592, 484, 342, 176, 0, 176,
342, 484, 592, 661, 684, 661, 592, 484
},

{
327, 168, 0, 168, 327, 462, 565, 631,       //440
653, 631, 565, 462, 327, 168, 0, 168,
327, 462, 565, 631, 653, 631, 565, 462
},

{
320, 165, 0, 165, 320, 452, 617, 639,       //450
639, 617, 553, 452, 320, 165, 0, 165,
320, 452, 617, 639, 639, 617, 553, 452
}
};

unsigned int num_steps_taken, current_position;
unsigned char pin3val, pin2val;
unsigned char fullstepmode_partstep, microstep_active, wait;