;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  FlashProgram.asm                                     *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;*************************************************************************
;*   UINT8 ByteProgram  (UINT16 dest, 
;*                       UINT16 size, 
;*                       UINT16 source, 
;*                       UINT8 (*HighVoltage)(void),
;*                       void (*CallBack)(void))
;*   
;*   Calling convention:
;*       dest, size, source and high voltage function are pushed into stack; 
;*       CallBack is passed in H:X
;*
;*   Return code:
;*       return 8-bit value through A
;*   
;*   Stack map:
;*         |                 | <- sp (after local space allocated)
;*         | CALLBACK msb    | 
;*         | CALLBACK lsb    | <- sp (after jsr)
;*         | ReturnAddr msb  | 
;*         | ReturnAddr lsb  | <- sp (after rts)
;*         | HighVoltage msb | 
;*         | HighVoltage lsb | 
;*         | source msb      | 
;*         | source lsb      | 
;*         | size msb        | 
;*         | size lsb        |  
;*         | dest msb        |  
;*         | dest lsb        |  
;*   
;*   Changes: A, H and X 
;*************************************************************************

        XDEF FlashProgram
        INCLUDE "ssd_sgf.inc"

FlashProgram:
            pshx              ;SP <- (SP) - 1; push low byte of CallBack into stack 
            pshh              ;SP <- (SP) - 1; push high byte of CallBack into stack
    
            lda   #(SGF_ERROR_PVIOL|SGF_ERROR_ACCERR) ;clear FSTAT[PVIOL,ACCERR]
            ldhx  #SGF_FCNFG  ;load address of FCNFG
            sta   2,x         ;double-write FSTAT ensures FSTAT[PVIOL,ACCERR] are cleared
            sta   2,x          

            clr  ,x           ;write $00 to FCNFG to clear FCNFG[KEYACC]

            clra              ;clear return code
checkSize:
            ldhx  9,sp        ;check if size of left bytes to be programmed is zero
            beq   bytePgmEnd  ;if size is 0, terminate function
            aix   #-1         ;otherwise sub size by 1
            sthx  9,sp

            ldhx  7,sp        ;load H:X with address of the current source data
            lda   ,x          ;load A with the source data
            aix   #1          ;update the address of the source data
            sthx  7,sp
            
            ldhx  11,sp       ;load H:X with current address in flash to program
            sta   ,x          ;write source data to the flash location
            aix   #1          ;update the programming address for next program sequence
            sthx  11,sp       
            
            lda   #CMD_BYTE_PROG ;load A with byte program command 
            ldhx  #SGF_FCMD
            sta   ,x          ;store byte program command to FCMD

            ldhx  5,sp        ;load HighVoltage function address
            jsr   ,x          ;call HighVoltage function
            tsta              ;check operation result
            beq   checkSize
            
bytePgmEnd:
            ais   #2          ;SP <- (SP) + 2
            rts   





