;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  FlashInit.asm                                        *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;*************************************************************************
;*   UINT8 FlashInit (UINT8 clockDivider)
;*   
;*   Calling convention:
;*       clockDivider is passed in A
;*   
;*   Return code:
;*       return 8-bit value through A 
;*   
;*   Stack map:
;*         |                | <- sp (after jsr)
;*         | ReturnAddr msb | 
;*         | ReturnAddr lsb | <- sp (after rts)
;*   
;*   Changes: A, H and X
;*************************************************************************

        XDEF FlashInit
        INCLUDE "ssd_sgf.inc"

FlashInit:
            ora   #SGF_FCDIV_DIVLD ;FCDIV[CLKLD] will be set after loading
            psha              ;save clock divider
            lda   #(SGF_ERROR_PVIOL|SGF_ERROR_ACCERR) ;clear FSTAT[PVIOL,ACCERR]
            ldhx  #SGF_FSTAT  ;load address of FSTAT
            sta   ,x          ;double-write FSTAT ensures FSTAT[PVIOL,ACCERR] are cleared
            sta   ,x        

            lda   SGF_FOPT    ;check FOPT[SEC] field for security status
            and   #SGF_FOPT_SEC ;reserve FOPT[SEC] field
            sub   #2
            beq   loadDivider ;if FOPT[SEC] equals %10, flash is unsecured
                              ;otherwise set SGF_ERROR_SECURITY_ENABLED bit in return code
            lda   #SGF_ERROR_SECURITY_ENABLED

loadDivider:
            pulx              ;retrieve clock divider to X
            stx   SGF_FCDIV   ;write clock divider to FCDIV
            cpx   SGF_FCDIV   ;check if the clock divider is loaded correctly
            beq   FIEnd       ;terminate function if clock divider is loaded correctly
                              ;otherwise set SGF_ERROR_CLOCK_SETTING bit in return code
            ora   #SGF_ERROR_CLOCK_SETTING 

FIEnd:
            rts
