;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  FlashErase.asm                                       *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;*************************************************************************
;*   UINT8 FlashErase (UINT8 eraseCmd, 
;*                     UINT16 dest, 
;*                     UINT8 number, 
;*                     UINT8 (*HighVoltage)(void),
;*                     void (*CallBack)(void))
;*   
;*   Calling convention: 
;*        eraseCmd, dest, number and high voltage function address are 
;*        pushed into stack;
;*        CallBack is passed in H:X
;*   
;*   Return code:
;*        return 8-bit value through A
;*   
;*   Stack map:
;*         |                 | <- sp (after local space allocated)
;*         | CALLBACK msb    | 
;*         | CALLBACK lsb    | <- sp (after jsr)
;*         | ReturnAddr msb  | 
;*         | ReturnAddr lsb  | <- sp (after rts)
;*         | HighVoltage msb |  
;*         | HighVoltage lsb |  
;*         | number          |  
;*         | dest msb        | 
;*         | dest lsb        | 
;*         | eraseCmd        | 
;*   
;*   Changes: A, H and X 
;*************************************************************************

        XDEF FlashErase
        INCLUDE "ssd_sgf.inc"

FlashErase:
            pshx              ;SP <- (SP) - 1; push low byte of CallBack into stack 
            pshh              ;SP <- (SP) - 1; push high byte of CallBack into stack
            
            lda   #(SGF_ERROR_PVIOL|SGF_ERROR_ACCERR) ;clear FSTAT[PVIOL,ACCERR]
            ldhx  #SGF_FCNFG  ;load address of FCNFG
            sta   2,x         ;double-write FSTAT ensures FSTAT[PVIOL,ACCERR] are cleared
            sta   2,x          

            clr   ,x          ;write $00 to FCNFG to clear FCNFG[KEYACC]

checkNumber:            
            tsx               ;H:X <- (SP) + 1
            lda   6,x         ;check number if it's zero
            beq   FEEnd       ;if number is 0, terminate function
            dec   6,x         ;otherwise sub number by 1
            
            ldhx  8,sp        ;load H:X with the destination address
            sta   ,x          ;write any value to dest
            
            lda   #2          ;add $200 to dest, i.e add $2 to high byte of dest
            tsx               ;H:X <- (SP) + 1
            add   7,x
            sta   7,x
                        
            lda   9,x         ;load specified erase command
            ldhx  #SGF_FCMD
            sta   ,x          ;write command to FCMD register
            
            ldhx  5,sp        ;load HighVoltage function address
            jsr   ,x          ;call HighVoltage function
            tsta              ;check operation result
            beq   checkNumber

FEEnd:    
            ais   #2          ;SP <- (SP) + 2
            rts   
