;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  DataVerify.asm                                       *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;*************************************************************************
;*   UINT8 DataVerify (BOOL verifyType, 
;*                     UINT16 dest, 
;*                     UINT16 size, 
;*                     UINT16 source, 
;*                     UINT16 *pFailAddress, 
;*                     void (*CallBack)(void))
;*
;*   Calling convention: 
;*       verifyType, dest, size, source and pFailAddress are pushed into 
;*       stack; CallBack is passed in H:X
;*
;*   Return code:
;*       return 8-bit value through A
;*
;*   Stack map:
;*        |                  | <- sp (after local space allocated)
;*        | CALLBACK msb     |
;*        | CALLBACK lsb     | <- sp (after jsr)
;*        | ReturnAddr msb   | 
;*        | ReturnAddr lsb   | <- sp (after rts)
;*        | pFailAddress msb | 
;*        | pFailAddress lsb |
;*        | source msb       |
;*        | source lsb       |
;*        | size msb         |
;*        | size lsb         |
;*        | dest msb         |
;*        | dest lsb         | 
;*        | verifyType       |   
;*
;*   Changes: A, H and X 
;*************************************************************************

        XDEF DataVerify
        INCLUDE "ssd_sgf.inc"
        
        XREF FSL_CallBack       

DataVerify:
            pshx              ;SP <- (SP) - 1; push low byte of CallBack into stack 
            pshh              ;SP <- (SP) - 1; push high byte of CallBack into stack
            
checkCallback:
            
            JSR FSL_CallBack
            
            ldx   #CALLBACK_DV ;reset step counter

checkSize:
            pshx
            clra              ;clear return code
            
            ldhx  10,sp       ;check if size of left bytes to be verified is zero
            beq   verifyEnd   ;if size is zero, terminate function
            aix   #-1         ;sub size by 1
            sthx  10,sp

            lda   #$FF        ;initialize temporary data variable to $FF 
            
            tsx
            tst   13,x        ;check the intended verify type
            bne   byteCompare ;do compare if it's a blank check
            ldhx  8,sp        ;program verify; load H:X with address of current source data
            lda   ,x          ;load A with the current source data
            aix   #1          ;update address of source data for next verify
            sthx  8,sp
        
byteCompare:
            ldhx  12,sp       ;load H:X with address of current flash data
            cmp   ,x          ;compare A with flash memory
            beq   incDest     ;If equals, update destination address for next verify
            
            txa               ;save fail address low byte to A
            pshh              ;save fail address high byte to stack
            ldhx  7,sp        ;load the address of buffer where to save the fail address
            sta   1,x         ;save fail address low byte to buffer
            pula              ;retrieve fail address high byte 
            sta   ,x          ;save fail address high byte to buffer

            lda   #SGF_ERROR_VERIFY ;set return code to $SGF_ERROR_VERIFY
            bra   verifyEnd   ;terminate function   

incDest:    
            aix   #1
            sthx  12,sp
            pulx              ;retrieve step counter
            dbnzx checkSize   ;sub step counter by 1, branch if not zero
            bra   checkCallback ;otherwise call CallBack function

verifyEnd:
            ais   #3          ;SP <- (SP) + 3
            rts
