#ifndef _LCD_H_
#define _LCD_H_

#define LCD_CHAR_SPACE          0       // ' ' (Space)
#define LCD_CHAR_QUOTMARK       1       // '"' (Quotation Mark)
#define LCD_CHAR_APOSTROPHE     2       // ''' (Apostrophe)
#define LCD_CHAR_LPAREN         3       // '(' (Left Parenthesis)
#define LCD_CHAR_RPAREN         4       // ')' (Right Parenthesis)
#define LCD_CHAR_ASTERISK       5       // '*' (Asterisk)
#define LCD_CHAR_PLUS           6       // '+' (Plus Sign)
#define LCD_CHAR_COMMA          7       // ',' (Comma)
#define LCD_CHAR_MINUS          8       // '-' (Minus Sign)
#define LCD_CHAR_PERIOD         9       // '.' (Period)
#define LCD_CHAR_SLASH          10      // '/' (Slash)
#define LCD_CHAR_0              11      // '0'
#define LCD_CHAR_1              12      // '1'
#define LCD_CHAR_2              13      // '2'
#define LCD_CHAR_3              14      // '3'
#define LCD_CHAR_4              15      // '4'
#define LCD_CHAR_5              16      // '5'
#define LCD_CHAR_6              17      // '6'
#define LCD_CHAR_7              18      // '7'
#define LCD_CHAR_8              19      // '8'
#define LCD_CHAR_9              20      // '9'
#define LCD_CHAR_COLON          21      // ':' (colon)
#define LCD_CHAR_EQUAL          22      // '=' (Equal Sign)
#define LCD_CHAR_A              23      // 'A'
#define LCD_CHAR_B              24      // 'B'
#define LCD_CHAR_C              25      // 'C'
#define LCD_CHAR_D              26      // 'D'
#define LCD_CHAR_E              27      // 'E'
#define LCD_CHAR_F              28      // 'F'
#define LCD_CHAR_G              29      // 'G'
#define LCD_CHAR_H              30      // 'H'
#define LCD_CHAR_I              31      // 'I'
#define LCD_CHAR_J              32      // 'J'
#define LCD_CHAR_K              33      // 'K'
#define LCD_CHAR_L              34      // 'L'
#define LCD_CHAR_M              35      // 'M'
#define LCD_CHAR_N              36      // 'N'
#define LCD_CHAR_O              37      // 'O'
#define LCD_CHAR_P              38      // 'P'
#define LCD_CHAR_Q              39      // 'Q'
#define LCD_CHAR_R              40      // 'R'
#define LCD_CHAR_S              41      // 'S'
#define LCD_CHAR_T              42      // 'T'
#define LCD_CHAR_U              43      // 'U'
#define LCD_CHAR_V              44      // 'V'
#define LCD_CHAR_W              45      // 'W'
#define LCD_CHAR_X              46      // 'X'
#define LCD_CHAR_Y              47      // 'Y'
#define LCD_CHAR_Z              48      // 'Z'
#define LCD_CHAR_LBRACKET       49      // '[' (Left Bracket)
#define LCD_CHAR_RBRACKET       50      // ']' (Right Bracket)
#define LCD_CHAR_BACKSLASH      51      // '\' (Backslash)
#define LCD_CHAR_EXPONENT       52
#define LCD_CHAR_UNDERLINE      53      // '_' (Underline)
#define LCD_CHAR_VERTBAR        54      // '|' (Vertical Bar)
#define LCD_CHAR_TEST           55      // All segments on

#define LCD_SEG_NONE            0x00

#define LCD_SEG_A               0x01
#define LCD_SEG_B               0x02
#define LCD_SEG_C               0x04
#define LCD_SEG_D               0x08

#define LCD_SEG_SIGN            0x01
#define LCD_SEG_F               0x02
#define LCD_SEG_G               0x04
#define LCD_SEG_E               0x08

#define LCD_SEG_S1              0x01
#define LCD_SEG_S2              0x02
#define LCD_SEG_S3              0x04
#define LCD_SEG_S4              0x08

#define LCD_SEG_SPEED_D         0x01
#define LCD_SEG_SPEED_E         0x02
#define LCD_SEG_SPEED_F         0x04
#define LCD_SEG_SPEED_A         0x08

#define LCD_SEG_SPEED_C         0x02
#define LCD_SEG_SPEED_G         0x04
#define LCD_SEG_SPEED_B         0x08

#define NUM_DIGITS              6
#define NUM_DIGITS_SPEED        3
#define NUM_CHARS   			      sizeof(lcd_char_table)/sizeof(lcd_char_table[0])

#define MASK_ABCD              (LCD_SEG_A|LCD_SEG_B|LCD_SEG_C|LCD_SEG_D)
#define MASK_FGE               (LCD_SEG_F|LCD_SEG_G|LCD_SEG_E)
#define MASK_SPEED_DEFA        (LCD_SEG_SPEED_D|LCD_SEG_SPEED_E|LCD_SEG_SPEED_F|LCD_SEG_SPEED_A)
#define MASK_SPEED_CGB         (LCD_SEG_SPEED_C|LCD_SEG_SPEED_G|LCD_SEG_SPEED_B)

#define LCDPIN_ABCD             1
#define LCDPIN_FGE              0
#define LCDPIN_SPEED_DEFA       1
#define LCDPIN_SPEED_CGB        0

const struct lcd_char_segs {
  unsigned char FGE;
  unsigned char ABCD;
  unsigned char SPEED_CGB;
  unsigned char SPEED_DEFA;
};

enum symbol { OIL,COLD,HOT,THERMOMETER,BATTERY,SERVICE,FREESCALE,FUELBORDER,
              HVACFAN, HVACAIRFLOW, HVACAIRFLOWSINGLE, HVACAIRFLOWDUAL, HVACAIRFLOWWINDOW, TRIP,
              TRIPA, TRIPB, KMLEFT, MILEAGE, ODO, AM, PM, KMPL, KM_ODO, DEGREE, COL, DP, CLOCK,
              TEMPERATURE, KMPH, FUELLEVEL, BATTLEVEL};
              
//Pin mapping
#define LCDPIN1   LCDWF0
#define LCDPIN2   LCDWF1
#define LCDPIN3   LCDWF2
#define LCDPIN4   LCDWF3
#define LCDPIN5   LCDWF4
#define LCDPIN6   LCDWF5
#define LCDPIN7   LCDWF6
#define LCDPIN8   LCDWF7
#define LCDPIN9   LCDWF8
#define LCDPIN10  LCDWF9
#define LCDPIN11  LCDWF10
#define LCDPIN12  LCDWF11
#define LCDPIN13  LCDWF12
#define LCDPIN14  LCDWF13
#define LCDPIN15  LCDWF14
#define LCDPIN16  LCDWF15
#define LCDPIN17  LCDWF16
#define LCDPIN18  LCDWF17
#define LCDPIN19  LCDWF18
#define LCDPIN20  LCDWF19
#define LCDPIN21  LCDWF44
#define LCDPIN22  LCDWF43
#define LCDPIN23  LCDWF42
#define LCDPIN24  LCDWF41
#define LCDPIN25  LCDWF34
#define LCDPIN26  LCDWF33
#define LCDPIN27  LCDWF32
#define LCDPIN28  LCDWF31
#define LCDPIN29  LCDWF40
#define LCDPIN30  LCDWF39
#define LCDPIN31  LCDWF38
#define LCDPIN32  LCDWF37

#define CONFIG_LCD_28x4_MODE  { \
              LCDPEN0 = 0xFF;   \
              LCDPEN1 = 0xFF;   \
              LCDPEN2 = 0x0F;   \
              LCDPEN3 = 0x80;   \
              LCDPEN4 = 0xE7;   \
              LCDPEN5 = 0x1F;   \
                                \
              LCDBPEN0 = 0x00;  \
              LCDBPEN1 = 0x00;  \
              LCDBPEN2 = 0x00;  \
              LCDBPEN3 = 0x00;  \
              LCDBPEN4 = 0xE0;  \
              LCDBPEN5 = 0x01;  \
                                \
              LCDPIN32 = 0x01;   \
              LCDPIN31 = 0x02;   \
              LCDPIN30 = 0x04;   \
              LCDPIN29 = 0x08;   \
}

#define LCD_ALLFP_OFF_4XMODE   {\
                          LCDPIN1 = 0x0;\
                          LCDPIN2 = 0x0;\
                          LCDPIN3 = 0x0;\
                          LCDPIN4 = 0x0;\
                          LCDPIN5 = 0x0;\
                          LCDPIN6 = 0x0;\
                          LCDPIN7 = 0x0;\
                          LCDPIN8 = 0x0;\
                          LCDPIN9 = 0x0;\
                          LCDPIN10 = 0x0;\
                          LCDPIN11 = 0x0;\
                          LCDPIN12 = 0x0;\
                          LCDPIN13 = 0x0;\
                          LCDPIN14 = 0x0;\
                          LCDPIN15 = 0x0;\
                          LCDPIN16 = 0x0;\
                          LCDPIN17 = 0x0;\
                          LCDPIN18 = 0x0;\
                          LCDPIN19 = 0x0;\
                          LCDPIN20 = 0x0;\
                          LCDPIN21 = 0x0;\
                          LCDPIN22 = 0x0;\
                          LCDPIN23 = 0x0;\
                          LCDPIN24 = 0x0;\
                          LCDPIN25 = 0x0;\
                          LCDPIN26 = 0x0;\
                          LCDPIN27 = 0x0;\
                          LCDPIN28 = 0x0;\
                        }

                        
#define LCD_ALLFP_ON_4XMODE   {\
                          LCDPIN1 = 0xFF;\
                          LCDPIN2 = 0xFF;\
                          LCDPIN3 = 0xFF;\
                          LCDPIN4 = 0xFF;\
                          LCDPIN5 = 0xFF;\
                          LCDPIN6 = 0xFF;\
                          LCDPIN7 = 0xFF;\
                          LCDPIN8 = 0xFF;\
                          LCDPIN9 = 0xFF;\
                          LCDPIN10 = 0xFF;\
                          LCDPIN11 = 0xFF;\
                          LCDPIN12 = 0xFF;\
                          LCDPIN13 = 0xFF;\
                          LCDPIN14 = 0xFF;\
                          LCDPIN15 = 0xFF;\
                          LCDPIN16 = 0xFF;\
                          LCDPIN17 = 0xFF;\
                          LCDPIN18 = 0xFF;\
                          LCDPIN19 = 0xFF;\
                          LCDPIN20 = 0xFF;\
                          LCDPIN21 = 0xFF;\
                          LCDPIN22 = 0xFF;\
                          LCDPIN23 = 0xFF;\
                          LCDPIN24 = 0xFF;\
                          LCDPIN25 = 0xFF;\
                          LCDPIN26 = 0xFF;\
                          LCDPIN27 = 0xFF;\
                          LCDPIN28 = 0xFF;\
                        }

extern unsigned int milliseconds;

void Delay(unsigned int num_milliseconds);
void LCDClearAllSegments(void);
unsigned char LCDFindChar(unsigned char character);
void LCDGetLCDPin(unsigned char digit);
void LCDPutChar(unsigned char character, unsigned char digit);
void LCDGlowSegment(enum symbol symb, unsigned char level);
void LCDClearSegment(enum symbol symb);
void LCDClearDigit(unsigned char digit);

#endif /* #ifndef _LCD_H_ */