/**
  \mainpage 
  
  \n Copyright (c) 2006 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief 
  
  \author   	Freescale Semiconductor
  \author     R01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version    0.1
  \date       7/2/2008 10:52:40 AM
  
  Put here all the information needed of the Project. Basic configuration as well as information on
  the project definition will be very useful 
  
  DISCLAIMER: 
  
  *** Services performed by FREESCALE in this matter are performed AS IS and without any warranty. 
  CUSTOMER retains the final decision relative to the total design and functionality of the end product. 
  FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project. 
  FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, implied 
  warranty of merchantability or fitness for a particular purpose on any hardware, software ore advise 
  supplied to the project by FREESCALE, and or any product resulting from FREESCALE services . 
  In no event shall FREESCALE be liable for incidental or consequential damages arising out of this agreement. 
  CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone on account 
  of any damage, or injury, whether commercial, contractual, or tortuous, rising directly or indirectly as a 
  result of the advice or assistance supplied CUSTOMER in connection with product, services or goods supplied
  under this Agreement. ***
*/
#include "Adc.h"
#include "Mcu.h"
#include "Pit.h"
#include "Adc_Filter.h"
#include "Emios.h"
#include "AdcFltr_Test_Case.h"



extern IVOR4Handler();
extern uint32_t EXCEPTION_HANDLERS; /* Interrupt Vector Prefix value from link file*/

uint16_t u16Read_Result = 0;


asm void initIrqVectors(void) 
{
  lis	   r3, EXCEPTION_HANDLERS@h   /* IVPR value is passed from link file */
  ori      r3, r3, EXCEPTION_HANDLERS@l 
  mtivpr   r3									 
}

void initINTC(void) 
{	
                              /* Use the first 3 or next 3 lines: */
  INTC.MCR.B.HVEN_PRC0 = 0;   /* MPC551x Proc'r 0: initialize for SW vector mode */
  INTC.MCR.B.VTES_PRC0 = 0;   /* MPC551x Proc'r 0: default vector table 4B offsets */
}

void enableIrq(void) 
{
                               /* Use one of the following two lines: */
  INTC.CPR_PRC0.B.PRI = 0;     /* MPC551x Proc'r 0: Lower INTC's current priority */
  asm(" wrteei 1");	    	   /* Enable external interrupts */
}

void vfnAdc_Init_Port_Pins(void)
{
   uint8_t u8PortNo = 0;
   	
  	for(u8PortNo = MAX_ADC_CHANNELS ; u8PortNo > 0 ; u8PortNo-- )
  	{
  	    SIU.PCR[au8Adc_Port_Pins[u8PortNo - 1]].R = (uint16_t)0x0500;
  	}
}


void main (void)
{  
   
   AdcFltrCntl_t = &sATD0;
   
   vfnInit_PLL();        /* Initialize system bus at 64MHz                  */
   initINTC();           /* Configure Interrupts                            */
   
   
   #if (ADCFLTR_TC001 == ON)
     vfnAdcFltr_Init(NULL_PTR);   
   #endif
   
   #if ((ADCFLTR_TC002 == ON) || (ADCFLTR_TC003 == ON))
     vfnAdcFltr_Init((tAdcFltr_FilterStruct*) AdcFltrCntl_t);
   #endif
   
   #if (ADCFLTR_TC004 == ON)
     vfnAdc_Init_Port_Pins();   /* Initialize ADC pins                        */
   #endif
   
   #if((ADCFLTR_TC005 == ON) || (ADCFLTR_TC006 == ON) || (ADCFLTR_TC007 == ON) || (ADCFLTR_TC008 == ON) || (ADCFLTR_TC009 == ON))
    vfnAdc_Init_Port_Pins();   /* Initialize ADC pins                        */
    vfnAdc_Init();        /* Initialize ADC0 module with predefined parameters from Adc_Cfg.h file */
    vfnAdcFltr_Init((tAdcFltr_FilterStruct*) AdcFltrCntl_t);
    vfnedma_init();       /* Initialize DMA engine to handle ADC conversions */
    vfndma_config_fcn();  /* Configures TCD channels 0 & 1                   */ 
   #endif
   
   vfnInitAdc_Calibration(ADC_FIFO_BUFFER); /* Start ADC0 Calibration       */
   enableIrq();          /* Enable global interrupts                        */
   
    for(;;)
    {
      vfnAdc_Sample_Acquire(); /* Start sampling without timming */
    }
    
} 

