/******************************************************************************
Copyright (c) Freescale Semiconductor 2006
File Name		 :	$RCSfile: main.c,v $
Location		 :	EKB
Date Created	 :	27/02/2006
Current Revision :	$Revision: 1.0 $
Notes            :  
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#pragma LINK_INFO DERIVATIVE "mc9s12xdp512"
#include "per_XDx512_L15Y.h"
#include "xgate.h"

/* ********************************** */
/* XGATE ATD Filter driver includes */
#include "xl_atd_average.h"
#include "xl_atd_averagecpu.h"
/* ********************************* */

/* Interrupt module routing macro */
#define ROUTE_INTERRUPT(vec_adr, cfdata)                \
  Interrupt.int_cfaddr = (vec_adr) & 0xF0;                         \
  Interrupt.int_cfdata[((vec_adr) & 0x0F) >> 1].byte = (cfdata)

static void SetupXGATE(void) {
  /* initialize the XGATE vector block and
     set the XGVBR register to its start address */
  XGATE.xgvbr = (unsigned int)(void*__far)(XGATE_VectorTable - XGATE_VECTOR_OFFSET);

  /* enable XGATE mode and interrupts */
  XGATE.xgmctl = 0xFBC1; /* XGE | XGFRZ | XGIE */
}

/******************************************************************************
Function Name	:	PLLStartup
Engineer		:	r27624
Date			:	26/9/2001
Arguments		:	freq: 
Return			:	
Notes			:	Ref Clock is assumed to be 1MHz
******************************************************************************/
//#define REFDV 15					/* 16 MHz crystal */
#define REFDV 3					/* 4 MHz crystal */
void PLLStartup(tU08 freq) {
									/* switch to OSCCLK */
	CRG.clksel.byte = 0;
 	CRG.pllctl.byte = CME   |		/* clock monitor enabled */
  				  		    PLLON |		/* PLL on */
	  			     			AUTO	|		/* automatic bandwidth control enabled */
		  		      		SCME;			/* self clock mode enabled */
	if(freq != 0) {
	  								/* configure PLL */
										/* fref = fosc / (REFDV+1) */
	  CRG.refdv.byte = REFDV;
									/* fvco = 2*fref*(SYNR+1) */
	  CRG.synr.byte = freq - 1;
									/* wait for lock FOR EVER! */
	  while(CRG.crgflg.bit.lock != SET);
		if(CRG.crgflg.bit.lock == SET) {
									/* switch to PLLCLK */
			CRG.clksel.byte |= PLLSEL;
  	}
	}
}

/* ******************************** */
/* ATD interface structure def      */
extern txl_atd_FilterStruct sATD0, sATD1;
extern unsigned int xl_atd0_FilterResults[];
extern unsigned int xl_atd1_FilterResults[];

/* ******************************** */

/* ******************************** */
/* This main() function provides a  */
/* simple example of the atd driver */
/* in use. It triggers the ATD from */
/* PIT channel 0 every 1ms and      */
/* reads back the filter output on  */
/* an interrupt from the XGATE      */
/* Example assumes a 4MHz XTAL and  */
/* 40MHz bus speed - configure as   */
/* required if a different clock    */
/* speed is used                    */
/* ******************************** */

void main(void)
{
  volatile unsigned int resultATD0, resultATD1;

  PLLStartup(40);
  SetupXGATE();

  /* Route ADC interrupts to XGATE */
  ROUTE_INTERRUPT(0xD0,0x81);               //ATD1 to XGATE
  ROUTE_INTERRUPT(0xD2,0x81);               //ATD0 to XGATE

  ROUTE_INTERRUPT(0x72,0x81);								//XGATE SWI0 to XGATE

    /* Call XGATE software interrupt 0 to initialise XGATE driver */
  XGATE.xgswt.word = XGSWT0M | XGSWT0;

  /* Initialise the ATD to application requirements */
  ATD0.atdctl0.byte = 0x03;                 // 4 lowest channels
  ATD0.atdctl1.byte = 0x82;                 // ATD triggered from PIT0
  ATD0.atdctl2.byte = ADPU|AFFC|ETRIGE|ASCIE;      // Turn on ATD & use external trigger
  ATD0.atdctl3.byte = 0x20;                 // 4 conversions - no FIFO
  ATD0.atdctl4.byte = 0x09;                 // For 40MHz bus, conversion rate = 2MHz, 2cycle sample, 10bit accuracy
  ATD0.atdctl5.byte = 0x90;                 // Left justified, unsigned, scan multiple channels starting with 0
  
  ATD1.atdctl0.byte = 0x07;                 // 8 lowest channels
  ATD1.atdctl1.byte = 0x82;                 // ATD triggered from PIT0
  ATD1.atdctl2.byte = ADPU|AFFC|ETRIGE|ASCIE;      // Turn on ATD & use external trigger
  ATD1.atdctl3.byte = 0x38;                 // 8 conversions - no FIFO
  ATD1.atdctl4.byte = 0x00;                 // For 2MHz bus, conversion rate = 1MHz, 2cycle sample, 10bit accuracy
  ATD1.atdctl5.byte = 0x90;                 // Left justified, unsigned, scan multiple channels starting with 0
  
  /* Enable PIT 0 to provide 100us trigger to ATDs */
  PIT.pitcflmt.byte = 0x80;                 // Enable PIT
  PIT.pitce.byte = 0x01;                    // Enable channel 0
  PIT.pitmux.byte = 0x00;                   // Use microtimer 0 for all channels
  PIT.pitinte.byte = 0x00;                  // Disable interrupts
  PIT.pitmtld0.byte = 20;                   // Microtimer count of 20
  PIT.pitld0.word = 200;                    // Channel 0 counter of 200
  
  EnableInterrupts;
  
  for(;;)
  {
    resultATD0= xl_atd0_FilterResults[0];
    resultATD1= xl_atd1_FilterResults[0];
  } /* wait forever */
  /* please make sure that you never leave this function */
}
