/*****************************************************************************/
/*                                             COPYRIGHT (c) FREESCALE 2005  */
/*                                                                           */
/* File Name          :    $RCSfile: S12XSRAM20KV1.h,v $                     */
/*                                                                           */
/* Current Revision :      $Revision: 1.0 $                                  */
/*                                                                           */
/* PURPOSE: header file for S12X XSRAM register block                        */
/*                                                                           */
/*  ***********************************************************************  */
/*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  */
/*  *  METROWERKS COMPILER AND THE S12X EVB AND HAS ONLY BEEN GIVEN A     *  */
/*  *  MIMIMUM LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES *  */
/*  *  AND NO PROMISE OF SUPPORT.                                         *  */
/*  ***********************************************************************  */
/*                                                                           */
/* DESCRIPTION:  Defines the XSRAM register block as a datastructure of      */
/*               type tXSRAM.                                                */
/*               This module is specific to the prototype HCS912XDP512       */
/*               0L40V silicon. Registers moved to the MMC module on         */
/*               later devices.                                              */
/*                                                                           */
/* UPDATE HISTORY                                                            */
/* REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          */
/* ---  ------    --------    ---------------------                          */
/* 1.0  r27624    25/11/03    - Initial coding                               */
/*                                                                           */
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XSRAM20KV1_H       /*prevent duplicated includes */
#define S12XSRAM20KV1_H


#ifndef S12_COMMON_H          /*prevent duplicated includes */
#include "S12_COMMON.h"
#endif

typedef union uXSCTRL
{
  tU08   byte;
  struct
  {
    tU08 xscavif :1;  /* XSRAM CPU Access Violation Flag */
    tU08 xsxavif :1;  /* XSRAM XGATE Access Violation Flag */
    tU08 xsavie  :1;  /* XSRAM Access Violation Interrupt Enable */
    tU08         :4;  /* not used */
    tU08 xsre    :1;  /* XSRAM Region Check Enable Bit */
  }bit;
}tXSCTRL;

#define XSCAVIF   0x01  /*bit masks */
#define XSXAVIF   0x02
#define XSAVIE 0x04
#define XSRE    0x80

typedef struct          /*XSRAM datastructure   */
{
  volatile tXSCTRL  xsctrl;  /*XSRAM control register */
  volatile tU08     xscub;   /*XSRAM code upper boundary */
  volatile tU08     xssrlb;  /*XSRAM shared lower boundary */
  volatile tU08     xssrub;  /*XSRAM shared upper boundary */
}tXSRAM;

#endif /*S12XSRAM20KV1_H */