/******************************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file		Scheduler.c
\brief		Multi-Thread Scheduler to manage Emsci sample application
\author  	Freescale Semiconductor
\author  	Guadalajara Applications Laboratory RTAC Americas
\author  	R01160
\version	1.0
\date		9/26/2008 
*/
/******************************************************************************************************************/
/*																									*/
/* All software, source code, included documentation, and any implied know-how are property of		*/
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.						*/
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.						*/
/*																									*/
/* All Confidential Information remains the property of Freescale Semiconductor and will not be  	*/
/* copied or reproduced without the express written permission of the Discloser, except for copies	*/
/* that are absolutely necessary in order to fulfill the Purpose.									*/
/*																									*/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.  																						*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*																									*/
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,  		*/
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from		*/
/* FREESCALE services.																				*/
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of  	*/
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or		*/
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/
/* in connectionwith product, services or goods supplied under this Agreement.						*/
/*																									*/
/******************************************************************************************************************/

#include	 "Scheduler.h"

/* -- Global Variables --------------------------------------------------------*/
uint8_t gu8Scheduler_Ctrl;
uint8_t gu8Scheduler_Flag;
/* Global Sleep Mode enable flag */
uint8_t gu8SleepModeEnabled;

/******************************************************************************************************************/
/**
* \brief	Initialise Scheduler Timebase using eMios Channel x as a tick reference. 
* \author	R01160
* \param	void
* \return	void
* \warning	User needs to be aware of which Emios channel will be completely assigned \n
*			to handle scheduler time base.*  	  *  	  *  	  *  	  *  	  *  	  *  	  *  	  *  	  * 
*/
void vfnScheduler_Init( void  )
{
	
	/* Local Prescaler Enabled									   */
	eMIOS_ENABLE_LOCAL_PRESCALER( SCHEDULER_EMIOS_CHANNEL );
	/* Local Divide Ratio = 1. Total Target freq = 16MHz		   */
	eMIOS_SET_PRESCALER( ( uint32_t )SCHEDULER_EMIOS_CHANNEL,( uint32_t )eMIOS_TM_LOCAL_PRESCALER - ( uint32_t )1U );
	/*Allows unified channel FLAG bit to generate an interrupt signal */
	eMIOS_ENABLE_CHANNEL_INTERRUPT( SCHEDULER_EMIOS_CHANNEL );
	/* Use the internal time base for channel					   */
	eMIOS_SET_INTERNAL_TIME_BASE( SCHEDULER_EMIOS_CHANNEL );
	/* Stop (freeze) channel registers when in debug mode		   */
	eMIOS_FREEZE_IN_DEBUG( SCHEDULER_EMIOS_CHANNEL );
	/* Raise priority of interrupt to Level 1: Interrupt handled by Main Core */
	INT_PSR( INTERRUPT_EMIOS_9, 0x01U );
	/* Set function pointer to jump when emios interrupt occurs    */
	vfnEmios_Set_Callback_Fnc( &Scheduler_Fnc_Handler, EMIOS_CH8 );
}

/******************************************************************************************************************/
/**
* \brief	Start Scheduler tasks to be executed.
* \author	Oscar Luna
* \param	void
* \return	void
*/
void vfnStart_Scheduler( void  )
{
	/*Load Timer constant to primary compare register */
	eMIOS_SET_COUNT_A( SCHEDULER_EMIOS_CHANNEL, LOOP_TIME_50ms );
	/* Select Modulus Counter, up counter, internal clock source, by selecting a valid MODE, timer starts counting */
	eMIOS_SET_MODULUS_UP_COUNTER( SCHEDULER_EMIOS_CHANNEL );
}


/*------ INTERRUPTS ------------------------------------------------------------------------------------ ------ --*/
void Scheduler_Fnc_Handler( void  )
{
	/*-- Update scheduler control variables --*/
	gu8Scheduler_Ctrl++;

	if( ( gu8Scheduler_Ctrl & ( uint8_t )0x01U ) == ( uint8_t )0x01U )
	{
		/*-- Allow 100 ms periodic tasks to be executed --*/
		gu8Scheduler_Flag = ( uint8_t )0x01U;
	}
	else
	{
		if( ( gu8Scheduler_Ctrl & ( uint8_t )0x02U ) == ( uint8_t )0x02U )
		{
			/*-- Allow 200 ms periodic tasks to be executed --*/
			gu8Scheduler_Flag = ( uint8_t )0x02U;
		}
		else
		{
			if( ( gu8Scheduler_Ctrl & ( uint8_t )0x04U ) == ( uint8_t )0x04U )
			{
				/*-- Allow 400 ms periodic tasks to be executed --*/
				gu8Scheduler_Flag = ( uint8_t )0x04U;
			}
			else
			{
				if( ( gu8Scheduler_Ctrl & ( uint8_t )0x08U ) == ( uint8_t )0x08U )
				{
																/*-- Allow 800 ms group A periodic tasks to be	  */
																/*executed --									  */
					gu8Scheduler_Flag = ( uint8_t )0x08U;
				}
				else
				{
					if( ( gu8Scheduler_Ctrl & ( uint8_t )0x0FU ) == ( uint8_t )0x00U )
					{
																/*-- Allow 800 ms group B periodic tasks to be	  */
																/*executed --									  */
						gu8Scheduler_Flag = ( uint8_t )0x10U;
					}
				}
			}
		}
	}
}
