/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Emsci_ReportError.c
  \brief      Catch any inconsistencies with Emsci Function Parameters
  \author     Freescale Semiconductor
  \author     R01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    1.0
  \date       9/24/2008 2:56:14 PM
  \warning    Do not modify Error type definitions in Emsci_ReportError.h file

  * History:
  
*/
/****************************************************************************************/

/** Pwm Error definitions */
#include "Emsci_ReportError.h"
/** Report Error Type Variables. Store last Error type Event */
uint8_t Emsci_ApiId      = 0;
uint8_t Emsci_ErrorId    = 0;


/**
 * \brief     Serve to catch and save any data inconsistency passed across       \n
 *            every Emsci function. Each type of error is saved in RAM variables \n
 *            user is able to use them as convenience.
 * \author    R01160
 * \param     Emsic Instance Id, Api Error type, Error definition type
 * \return    none
 * \warning
 */  
 void vfnEmsci_Report_Error(uint8_t ApiId, uint8_t ErrorId)
 {
   
   Emsci_ApiId      = ApiId;       /* Store last Api Id where Error Comes */
   Emsci_ErrorId    = ErrorId;     /* Store last type of Error Reported   */

 } 