/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Emios.h
\brief      This file contains all timebase definitions for Multi-Thread Scheduler
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __EMIOS_H__
 #define __EMIOS_H__

 /*--------------------------Includes -------------------------------------------------------------*/
  #include "Derivative.h"
  #include "Mcu.h"
  #include "emsci.h"
  #include "typedefs.h"
  
 #if (EMSCI_ERROR_DETECT == ON)   /* If Pwm Error Layer Enabled, validate errors */ 
   #include "Emsci_ReportError.h"
 #endif  
    
    
	/** Emios channels definitions     */
	#define EMIOS_CH0          (uint8_t)0U
	#define EMIOS_CH1          (uint8_t)1U
	#define EMIOS_CH2          (uint8_t)2U
	#define EMIOS_CH3          (uint8_t)3U
	#define EMIOS_CH4          (uint8_t)4U
	#define EMIOS_CH5          (uint8_t)5U
	#define EMIOS_CH6          (uint8_t)6U
	#define EMIOS_CH7          (uint8_t)7U
	#define EMIOS_CH8          (uint8_t)8U
	#define EMIOS_CH9          (uint8_t)9U
	
	#define START_BIT_SENT     (uint8_t) 0x01 
	#define START_BIT_NOT_SENT (uint8_t) 0x00 

    /*------------------------- Type definitions --------------------------------------------------------------*/    
    /** Function pointer callback definition */
    typedef void(*Emios_CallbackType)(void);
        
    /** Timing constants                           */
    #define   LOOP_TIME_100ms    (((uint32_t)SYS_FREQ *  (uint32_t)0.100) / ((uint32_t)eMIOS_GLOBAL_PRESCALER * (uint32_t)eMIOS_TM_LOCAL_PRESCALER))
    #define   LOOP_TIME_50ms     (((uint32_t)SYS_FREQ *  (uint32_t)0.05)  / ((uint32_t)eMIOS_GLOBAL_PRESCALER * (uint32_t)eMIOS_TM_LOCAL_PRESCALER))
	
    /*------------------------- Defines --------------------------------------------------------------*/  
	/* This file violates MISRA 2004 rule 11.3 because addressing memory mapped registers */
	/** emios Operation Mode */
	#define EMIOS_GPIO_MODE                         ((uint8_t)0x00)
	#define EMIOS_MCB_MODE                          ((uint8_t)0x50)
	#define EMIOS_SAIC_MODE                         ((uint8_t)0x02)
	#define EMIOS_SAOC_MODE                         ((uint8_t)0x03)
	
	/** Modes used to select either one of the counter buses or the internal counter */
	#define CNTR_BUS_A                              ((uint8_t)0)
	#define CNTR_BUS_BCD                            ((uint8_t)1)
	#define CNTR_BUS_INTERNAL                       ((uint8_t)3)
	
	/*---- MISRA violation to rule 10.1: The value of an expresion of integer type shall not be implicitly */
	/* converted to a different underlying type. Macros that violates this rule are:                       */
	/* 1) eMIOS_SET_MODE                                                                                   */
	/* 2) eMIOS_TIMER_COUNT                                                                                */
	/* 3) eMIOS_SET_EDGE_POLARITY                                                                          */
	/* 4) eMIOS_CLEAR_OVERFLOW_FLAG                                                                        */
	
	/*------ Emios Macros Violates Advisory MISRA Rule 19.7 (Function-Like Macro)-------------------*/
    /*------ Emios Macros Violates MISRA Rule 11.2 because of Pointer structures of Header file ----*/
    
	/** Global eMIOS prescaler: SysClk -> Global Pres -> Local Prescaler */
	#define eMIOS_GLOBAL_PRESCALER                  ((uint32_t)128)
	/** Global Timebase enabled */
	#define eMIOS_ENABLE_GLOBAL_TIMEBASE           (EMIOS.MCR.B.GTBE  = (uint32_t)(1))
	/** Global prescaler enabled */
	#define eMIOS_ENABLE_GLOBAL_PRESCALER           (EMIOS.MCR.B.GPREN = (uint32_t)(1))
	/** Set global prescaler value accordingly */
	#define eMIOS_SET_GLOBAL_PRESCALER_VALUE(value) (EMIOS.MCR.B.GPRE  = (uint32_t)(value))
	/** Globally enable freeze mode */
	#define eMIOS_ENABLE_GLOBAL_FREEZE_IN_DEBUG    (EMIOS.MCR.B.FRZ   = (uint32_t)1)
	/** Load eMIOS counter register A with a 24-bit value */
	#define eMIOS_SET_COUNT_A(channel,count)        (EMIOS.CH[(uint8_t)channel].CADR.R = (uint16_t)(count)) 
	/** Load eMIOS counter register B with a 24-bit value */
	#define eMIOS_SET_COUNT_B(channel,count)        (EMIOS.CH[channel].CBDR.R = (uint16_t)(count))
	/** Definition of eMIOS status flag */
	#define eMIOS_STATUS_FLAG(channel)              EMIOS.CH[channel].CSR.B.FLAG 
	/** Define timer count register */
	#define eMIOS_TIMER_COUNT(channel)              EMIOS.CH[channel].CCNTR.R
	/** Local Prescaler enabled */
	#define eMIOS_ENABLE_LOCAL_PRESCALER(channel)   (EMIOS.CH[channel].CCR.B.UCPEN = (uint32_t)(1))
	/** Local Prescaler disabled */
	#define eMIOS_DISABLE_LOCAL_PRESCALER(channel)  (EMIOS.CH[channel].CCR.B.UCPEN = (uint32_t)(0))
	/** Set local prescaler value */
	#define eMIOS_SET_PRESCALER(channel,value)      (EMIOS.CH[channel].CCR.B.UCPRE = (uint32_t)(value))
	/** Allow unified channel to set interrupt */
	#define eMIOS_ENABLE_CHANNEL_INTERRUPT(channel) (EMIOS.CH[channel].CCR.B.FEN   = (uint32_t)(1))           
	/** Allow unified channel to disable interrupt */
	#define eMIOS_DISABLE_CHANNEL_INTERRUPT(channel) (EMIOS.CH[channel].CCR.B.FEN   = (uint32_t)(0))           
	/** Clear counter of specified channel */
	#define eMIOS_CLEAR_COUNTER(channel)            (eMIOS_TIMER_COUNT(channel)    = (uint16_t)(0))
	/** Clear counter flag */
	#define eMIOS_CLEAR_STATUS_FLAG(channel)        (eMIOS_STATUS_FLAG(channel)    = (uint32_t)(1)) 
	/** Stop (freeze) channel registers when in debug mode */
	#define eMIOS_FREEZE_IN_DEBUG(channel)          (EMIOS.CH[channel].CCR.B.FREN  = (uint32_t)(1))
	/** Choose internal time base for channel */
	#define eMIOS_SET_INTERNAL_TIME_BASE(channel)   (EMIOS.CH[channel].CCR.B.BSL    = (uint32_t)(3))  
	/** Set edge mode accordingly */
	#define eMIOS_SET_EDGE_SELECT(channel,Mode)     (EMIOS.CH[channel].CCR.B.EDSEL = (uint32_t)(Mode))
		/** Set edge polarity accordingly */
	#define eMIOS_SET_EDGE_POLARITY(channel,pol)    (EMIOS.CH[channel].CCR.B.EDPOL = (uint32_t)(pol))
	/** Indicator of input capture or a match event in the comparators occurred */
	#define eMIOS_MATCH_EVENT_FLAG(channel)         EMIOS.CH[channel].CSR.B.FLAG
	/** Clears Overflow flag              */
    #define eMIOS_CLEAR_OVERFLOW_FLAG(channel)      EMIOS.CH[channel].CSR.B.OVFL = (uint32_t)1
	/* Select Modulus Counter, up counter, internal clock source */
    #define eMIOS_SET_MODE(channel,Mode)            EMIOS.CH[(uint32_t)channel].CCR.B.MODE = (uint32_t)Mode
	/* Select Modulus Counter, up counter, internal clock source */
    #define eMIOS_SET_MODULUS_UP_COUNTER(channel)   EMIOS.CH[channel].CCR.B.MODE = EMIOS_MCB_MODE
	/** emios channel assigned to generate Scheduler Timebase */
	#define EMIOS_CHANNEL_0                         ((uint32_t)0)
	/** Define interrupt assigned to Timer channel            */
    #define INTERRUPT_EMIOS_0                       ((uint8_t)58)
    /** Define interrupt assigned to Timer channel            */
    #define INTERRUPT_EMIOS_1                       ((uint8_t)59)
    /** Define interrupt assigned to Timer channel            */
    #define INTERRUPT_EMIOS_9                       ((uint8_t)67)
  
    /** Task Manager channel eMIOS prescaler                  */
    #define eMIOS_TM_LOCAL_PRESCALER                ((uint8_t)4)
    
/*------------------------- Function prototypes --------------------------------------------------------------*/  
  /** Set a function pointer to call after emios interrupt occurs */
  extern void vfnEmios_Set_Callback_Fnc(Emios_CallbackType Callback_Fnc, uint8_t u8FncCallback);
  extern void vfnEmios_Init_Channels(const Emsci_ConfigType *pEmsci_ChannelConfig);
  extern void vfnEmiosConfig_General_Clocks(void);
  extern void vfnEmios_Isr_0(void);
  extern void vfnEmios_Isr_1(void);  
  extern void Emios_Channel_9_Isr(void);
 
 #endif 