/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Derivative.h
  \brief    	MPC551x register addresses.
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/15/2008 3:07:45 PM
  \warning      This file shall be adapted with the specific MCU derivative registers.
  
  * History:
  
*/
#ifndef _DERIVATIVE_H_
 #define _DERIVATIVE_H_
/** MPC551x Header file      */ 
#include "551x.h"

 #define NULL_PTR ((void *)0)
/*------------------------------- MPC551x Registers ---------------------------*/

/*----------------------- PORT REGISTERS -------------------*/
/* All MCU mapped registers available within this file violates MISRA 2004 rule 11.3 because addressing memory mapped registers */
#define SIU_PCR(PCR_OFFSET)    SIU.PCR[PCR_OFFSET].R
#define SIU_GPDO(GPDO_OFFSET)  SIU.GPDO[GPDO_OFFSET].R
/*----------------------- PIT REGISTERS  -------------------*/
#define PIT_TLVAL0             PIT.TLVAL0.R  
#define PIT_TLVAL1             PIT.TLVAL1.R  
#define PIT_TLVAL2 		       PIT.TLVAL2.R  
#define PIT_TLVAL3 			   PIT.TLVAL3.R  
#define PIT_TLVAL4 			   PIT.TLVAL4.R  
#define PIT_TLVAL5 			   PIT.TLVAL5.R
#define PIT_TLVAL6 		       PIT.TLVAL6.R
#define PIT_TLVAL7 			   PIT.TLVAL7.R
#define PIT_EN                 PIT.EN.R
#define PIT_CTRL               PIT.CTRL.R
#define PIT_FLG                PIT.FLG.R
#define PIT_INTEN              PIT.INTEN.R 
#define PIT_INTSEL             PIT.INTSEL.R
#define PIT_FLG_TIF1           PIT.FLG.B.TIF1

/*----------------------- INTC REGISTERS  -------------------*/
/** INTC Priority register access */
#define INT_PSR(u32InterruptNum, u32Priority)   (INTC.PSR[(uint32_t)u32InterruptNum].R = (uint32_t)u32Priority)
#define INTC_HVEN_PRC0        INTC.MCR.B.HVEN_PRC0
#define INTC_HVEN_PRC1        INTC.MCR.B.HVEN_PRC1
#define INTC_CPR_PRC0_PRI     INTC.CPR_PRC0.B.PRI
#define INTC_CPR_PRC1_PRI     INTC.CPR_PRC1.B.PRI

/*---------------------- SIU REGISTERS ----------------------*/
#define SIU_ECCR_EBDF        SIU.ECCR.B.EBDF
#define SIU_SYSCLK_SYSCLKSEL SIU.SYSCLK.B.SYSCLKSEL    

/*---------------------- CRP REGISTERS ----------------------*/
#define CRP_CLKSRC_XOSCEN    CRP.CLKSRC.B.XOSCEN

/*---------------------- FLL REGISTERS ----------------------*/
#define FMPLL_ESYNCR1        FMPLL.ESYNCR1.R  
#define FMPLL_ESYNCR2        FMPLL.ESYNCR2.R  
#define FMPLL_SYNSR_LOCK     FMPLL.SYNSR.B.LOCK    
 
 
#endif