;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;           This file is Freescale Confidential Proprietary
;           (C) Copyright Freescale 2006 ALL RIGHTS RESERVED
;
;   Initialize the System L2RAM for Copperhead
;
;   J. West
;   04/01/03
;   Notes:
;       Register r11 and r12 are corrupted, other
;       registers are not changed.  This routine can
;       be called from anywhere. r11,r12 are volatile
;       registers and maybe modified without saving.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.extern long L2SRAM_LOCATION
.global init_L2RAM

.section .text  

init_L2RAM:

    lis r11,L2SRAM_LOCATION@h /* Base address of the L2SRAM, 64-bit word aligned */
    ori r11,r11,L2SRAM_LOCATION@l

    li r12,512     ;Loop counter to get all of SRAM; 64k on Rev0 devices 

    ;li r12,640    Loop to cover all of SRAM; 80k/4 bytes/32 GPRs = 640 
    mtctr r12

    init_l2sram_loop:
        stmw r0,0(r11)        /* Write all 32 GPRs to L2SRAM */
        addi r11,r11,128      /* Inc the ram ptr; 32 GPRs * 4 bytes = 128 */
        bdnz init_l2sram_loop /* Loop for 64k of L2SRAM */

    blr
