;****************************************************************
;            This file is Freescale Confidential Proprietary
;            (C) Copyright Freescale 2006 ALL RIGHTS RESERVED
;****************************************************************/
; FUNCTION      : cfg_FMPLL                                     */
; PURPOSE       : This function configures the FMPLL. The PLL	*/
;		  is first set for 32MHz and then after locking	*/
;		  is set to 128MHz.				*/
;****************************************************************/

.equ FMPLL_SYNCR, 		0xC3F80000
.equ FMPLL_SYNSR,		0xC3F80004
.equ FMPLL_SYNCR_SET_32, 	0x06100000
.equ FMPLL_SYNCR_SET_120,	0x05800000
.equ FMPLL_SYNCR_SET_128,	0x06000000
.equ FMPLL_LOCK_BIT,		0x00000008

.global cfg_FMPLL

.section .text  

cfg_FMPLL:

;*******************************************
;
; Fsys = Fxtal * (MFD + 4)/((PREDIV + 1)* 2^RFD)
;
; Set the internal clock to 32 MHz with MFD=12, and RFD=2. 
; Load address of FMPLL_SYNCR register into r5
    lis   r5, FMPLL_SYNCR@ha
    addi  r5, r5, FMPLL_SYNCR@l    		

; Load value upper FMPLL_SYNCR_SET_32 into R6
    lis   r6, FMPLL_SYNCR_SET_32@h      	
    ori   r6, r6, FMPLL_SYNCR_SET_32@l  	
    stw   r6, 0(r5)                   		; Place value of R6 into FMPLL_SYNCR (address R5)

; Check for PLL lock, first load the bit mask in r6
    lis r6, FMPLL_LOCK_BIT@h
    ori r6, r6, FMPLL_LOCK_BIT@l
   
check_LOCK:
    lis r8, FMPLL_SYNSR@h               	; Load address off FMPLL_SYNSR in r5.
    ori r8, r8, FMPLL_SYNSR@l
    lwz  r7, 0(r8)				; load contents of FMPLL_SYNSR in r7
    and. r7, r7, r6
    beq  check_LOCK                 		; Branch if zero. LOCK is not 1.

;***************************************
; Set the internal clock to 128 MHz with MFD=12, and RFD=0.
;  R5 holds the FMPLL_SYNCR  for this sequence.
    lis   r6, FMPLL_SYNCR_SET_128@h      	; Load RFD value upper FMPLL_SYNCR into R6
    ori   r6, r6, FMPLL_SYNCR_SET_128@l  	; Load value lower FMPLL_SYNCR into R6
    stw   r6, 0(r5)                   		; Place value of R6 into FMPLL_SYNCR (address R5)

; return
    blr      
