;*************************************************************************/
;                        MMU Functions                                   */
;*************************************************************************/

;*****************************************************************************/
; FUNCTION     : cfg_MMU                                                     */
; PURPOSE      : This function modifies the MMU TLB (translation lookaside   */
;                 buffer) table by writing to the appropriate MAS registers. */
; INPUT NOTES  : Requires SPRs defined and a data table for the TLB entries  */
;                mmu_tlb0 through mmu_tlb11, mmu_tlb15 from                  */
;                mpc5500_usrdefs.inc.                                        */
; RETURN NOTES : None                                                        */
; WARNING      : Registers used: R3,R5. Commands "msync" and "isync" are not */
;                required around the tlbwe since we are at configuration and */
;                 other background operations cannot be active.              */
;*****************************************************************************/
.global cfg_MMU

.section .text  


cfg_MMU:

  ; Write MMU Assist Register 0 (MAS0); SPR 624 
    mtspr   624, r3
  
  ; Write MMU Assist Register 1 (MAS1); SPR 625 
    mtspr   625, r4
    
  ; Write MMU Assist Register 2 (MAS2); SPR 626 
    mtspr   626, r5
    
  ; Write MMU Assist Register 3 (MAS3); SPR 627 
    mtspr   627, r6
    
  ; Write the table entry 
    tlbwe

    blr
; End of cfg_MMU 

;*************************************************************************
