/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/
//#define MC9RS08LE4
//#define MC9RS08LA8
//#define MC9S08LL16
#define MC9S08LG32

#define _LCDBACKPLANES			(4)				// # of backplanes  
#define _LCDCLKSOURCE			(1)					// 0 -- External clock       1 --  Alternate clock  (Internal)


#define _LCDCLKPSL					(3)				//  Clock divider to generate the LCD Waveforms


#define _LCDCPSEL						(1)					//0 -- Resistor network   1 -- Charge pump  
#define _LCDVSUPPLY					(1)					//0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external 
#define _LCDLOADADJUST			(0)				//Charge pump 		0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
                                                               //Resistor Network	0 -- 2000 pf 1 -- 2000 pf  2 -- 8000 pf   3 -- 8000 pf 

#define _LCDFRAMEINTERRUPT	(0)              //0 Disabel  Interrupt 1 Enable aLCD interrupt that coincides with the LCD frame frequency

#define _LCDBLINKRATE 			(0)				//Blink frequecy preescaler  any number between 0-7

#define _CHARNUM					(9)				// Number of characters on the display

#define _LCDTYPE						(4)				//Number of LCDWF  nedded  to drive one character 

/*^^^^^^^^^^^^^^^^      LCD Hardware Connection 			 ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define EnableLCDpins(RegNum,Mask)			LCDPEN##RegNum = Mask
#define  EnableBackplanes(RegNum, Mask)	LCDBPEN##RegNum = Mask   
#define  SetBackplane(ComNum, LCDn)		LCDWF##LCDn  = (1 <<  (##ComNum##))
#define CharacterPlace(LCDn)        				LCDWF##LCDn
#define AllSegmentsON(LCDn,ComMask)		LCDWF##LCDn = ComMask
#define SymbolON(LCDn, BitNumber)			LCDWF##LCDn = (RamBuffer[LCDn] |= (1<< BitNumber))
#define SymbolOFF(LCDn, BitNumber)			LCDWF##LCDn = (RamBuffer[LCDn] &= ~(1<< BitNumber))
#define MapSegment(BitNumber)  				(1<<(##BitNumber##)) 
#define LCDWFRef          							LCDWF0
#define LCD_AlphanumericPlace(Place)			bLCD_CharPosition=_LCDTYPE*##(Place-1)
/*
EnableLCDpins
Habilitate the mcu pin with the characteristics of a LCD pin 
param: RegNum -- Number of register to write     Mask --- Mask that habilitate the LCDx pins
*/
	#define PEN0       EnableLCDpins (0,255)
	#define PEN1       EnableLCDpins (1,255)
	#define PEN2       EnableLCDpins (2,255)
	#define PEN3       EnableLCDpins (3,255)
	#define PEN4       EnableLCDpins (4,255)
	#define PEN5       EnableLCDpins (5,15)

/* 
EnableBackplanes
Enable the LCD pin like a Backplane functionality  
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number that the Backplane it's connected 
*/
	#define   BPEN0        EnableBackplanes (0, 15)
	#define   BPEN1        EnableBackplanes (1, 0)
	#define   BPEN2        EnableBackplanes (2, 0)
	#define   BPEN3        EnableBackplanes (3, 0)
	#define   BPEN4        EnableBackplanes (4, 0)
	#define   BPEN5        EnableBackplanes (5, 0)

/*
SetBackplane
 Give the COM number  to the previous enable Backplane     
param: ComNum -- COM number     LCDpin --- LCDn number of pin that its connected  
*/
	#define   SetCom1        SetBackplane (0, 0)
	#define   SetCom2        SetBackplane (1, 1)
	#define   SetCom3        SetBackplane (2, 2)
	#define   SetCom4        SetBackplane (3, 3)

/*
Character place
This macro defines the LDCWavefroms directions needed for write the alphanumerics        
param:  LCDpin --- LCDn number of pin that its connected */

	#define   Char1a           (4)
	#define   Char1b           (5)
	#define   Char1c           (6)
	#define   Char1d           (7)
	#define   Char2a           (8)
	#define   Char2b           (9)
	#define   Char2c           (10)
	#define   Char2d           (11)
	#define   Char3a           (29)
	#define   Char3b           (30)
	#define   Char3c           (37)
	#define   Char3d           (38)
	#define   Char4a           (39)
	#define   Char4b           (40)
	#define   Char4c           (31)
	#define   Char4d           (32)
	#define   Char5a           (17)
	#define   Char5b           (18)
	#define   Char5c           (19)
	#define   Char5d           (20)
	#define   Char6a           (21)
	#define   Char6b           (35)
	#define   Char6c           (36)
	#define   Char6d           (22)
	#define   Char7a           (12)
	#define   Char7b           (13)
	#define   Char7c           (33)
	#define   Char7d           (34)
	#define   Char8a           (41)
	#define   Char8b           (42)
	#define   Char8c           (43)
	#define   Char8d           (14)
	#define   Char9a           (15)
	#define   Char9b           (16)
	#define   Char9c           (28)
	#define   Char9d           (27)


/* 
AllSegmentsON
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3
*/
	#define Segment1_ON               AllSegmentsON ( 4,15 )
	#define Segment2_ON               AllSegmentsON ( 5,15 )
	#define Segment3_ON               AllSegmentsON ( 6,15 )
	#define Segment4_ON               AllSegmentsON ( 7,15 )
	#define Segment5_ON               AllSegmentsON ( 8,15 )
	#define Segment6_ON               AllSegmentsON ( 9,15 )
	#define Segment7_ON               AllSegmentsON ( 10,15 )
	#define Segment8_ON               AllSegmentsON ( 11,15 )
	#define Segment9_ON               AllSegmentsON ( 12,15 )
	#define Segment10_ON               AllSegmentsON ( 13,15 )
	#define Segment11_ON               AllSegmentsON ( 33,15 )
	#define Segment12_ON               AllSegmentsON ( 34,15 )
	#define Segment13_ON               AllSegmentsON ( 41,15 )
	#define Segment14_ON               AllSegmentsON ( 42,15 )
	#define Segment15_ON               AllSegmentsON ( 43,15 )
	#define Segment16_ON               AllSegmentsON ( 14,15 )
	#define Segment17_ON               AllSegmentsON ( 15,15 )
	#define Segment18_ON               AllSegmentsON ( 16,15 )
	#define Segment19_ON               AllSegmentsON ( 28,15 )
	#define Segment20_ON               AllSegmentsON ( 27,15 )
	#define Segment21_ON               AllSegmentsON ( 26,15 )
	#define Segment22_ON               AllSegmentsON ( 25,15 )
	#define Segment23_ON               AllSegmentsON ( 24,15 )
	#define Segment24_ON               AllSegmentsON ( 23,15 )
	#define Segment25_ON               AllSegmentsON ( 22,15 )
	#define Segment26_ON               AllSegmentsON ( 36,15 )
	#define Segment27_ON               AllSegmentsON ( 35,15 )
	#define Segment28_ON               AllSegmentsON ( 21,15 )
	#define Segment29_ON               AllSegmentsON ( 20,15 )
	#define Segment30_ON               AllSegmentsON ( 19,15 )
	#define Segment31_ON               AllSegmentsON ( 18,15 )
	#define Segment32_ON               AllSegmentsON ( 17,15 )
	#define Segment33_ON               AllSegmentsON ( 32,15 )
	#define Segment34_ON               AllSegmentsON ( 31,15 )
	#define Segment35_ON               AllSegmentsON ( 40,15 )
	#define Segment36_ON               AllSegmentsON ( 39,15 )
	#define Segment37_ON               AllSegmentsON ( 38,15 )
	#define Segment38_ON               AllSegmentsON ( 37,15 )
	#define Segment39_ON               AllSegmentsON ( 30,15 )
	#define Segment40_ON               AllSegmentsON ( 29,15 )

/* 
AllSegmentsOFF
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3*/
	#define Segment1_OFF                AllSegmentsON ( 4, 0 )
	#define Segment2_OFF                AllSegmentsON ( 5, 0 )
	#define Segment3_OFF                AllSegmentsON ( 6, 0 )
	#define Segment4_OFF                AllSegmentsON ( 7, 0 )
	#define Segment5_OFF                AllSegmentsON ( 8, 0 )
	#define Segment6_OFF                AllSegmentsON ( 9, 0 )
	#define Segment7_OFF                AllSegmentsON ( 10, 0 )
	#define Segment8_OFF                AllSegmentsON ( 11, 0 )
	#define Segment9_OFF                AllSegmentsON ( 12, 0 )
	#define Segment10_OFF                AllSegmentsON ( 13, 0 )
	#define Segment11_OFF                AllSegmentsON ( 33, 0 )
	#define Segment12_OFF                AllSegmentsON ( 34, 0 )
	#define Segment13_OFF                AllSegmentsON ( 41, 0 )
	#define Segment14_OFF                AllSegmentsON ( 42, 0 )
	#define Segment15_OFF                AllSegmentsON ( 43, 0 )
	#define Segment16_OFF                AllSegmentsON ( 14, 0 )
	#define Segment17_OFF                AllSegmentsON ( 15, 0 )
	#define Segment18_OFF                AllSegmentsON ( 16, 0 )
	#define Segment19_OFF                AllSegmentsON ( 28, 0 )
	#define Segment20_OFF                AllSegmentsON ( 27, 0 )
	#define Segment21_OFF                AllSegmentsON ( 26, 0 )
	#define Segment22_OFF                AllSegmentsON ( 25, 0 )
	#define Segment23_OFF                AllSegmentsON ( 24, 0 )
	#define Segment24_OFF                AllSegmentsON ( 23, 0 )
	#define Segment25_OFF                AllSegmentsON ( 22, 0 )
	#define Segment26_OFF                AllSegmentsON ( 36, 0 )
	#define Segment27_OFF                AllSegmentsON ( 35, 0 )
	#define Segment28_OFF                AllSegmentsON ( 21, 0 )
	#define Segment29_OFF                AllSegmentsON ( 20, 0 )
	#define Segment30_OFF                AllSegmentsON ( 19, 0 )
	#define Segment31_OFF                AllSegmentsON ( 18, 0 )
	#define Segment32_OFF                AllSegmentsON ( 17, 0 )
	#define Segment33_OFF                AllSegmentsON ( 32, 0 )
	#define Segment34_OFF                AllSegmentsON ( 31, 0 )
	#define Segment35_OFF                AllSegmentsON ( 40, 0 )
	#define Segment36_OFF                AllSegmentsON ( 39, 0 )
	#define Segment37_OFF                AllSegmentsON ( 38, 0 )
	#define Segment38_OFF                AllSegmentsON ( 37, 0 )
	#define Segment39_OFF                AllSegmentsON ( 30, 0 )
	#define Segment40_OFF                AllSegmentsON ( 29, 0 )


/* 
SymbolON
Turns on the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol 
*/
#define _LCD_TIME_ON		SymbolON(6,3)
#define _LCD_DOT1_ON            SymbolON(7,2)
#define _LCD_MINUS_ON         SymbolON(7,3)
#define _LCD_DATE_ON         SymbolON(10,3)
#define _LCD_COL1_ON         SymbolON(11,2)
#define _LCD_DOT2_ON         SymbolON(11,3)
#define _LCD_POWER_ON         SymbolON(33,3)
#define _LCD_COL3_ON         SymbolON(34,2)
#define _LCD_DOT7_ON         SymbolON(34,3)
#define _LCD_COL4_ON         SymbolON(28,3)
#define _LCD_DOT9_ON         SymbolON(27,2)
#define _LCD_VOL1_ON         SymbolON(27,3)
#define _LCD_VOL2_ON         SymbolON(26,0)
#define _LCD_AM_ON         SymbolON(26,1)
#define _LCD_PM_ON         SymbolON(26,2)
#define _LCD_OHM_ON         SymbolON(26,3)
#define _LCD_KWh_ON         SymbolON(25,0)
#define _LCD_AMPS_ON         SymbolON(25,1)
#define _LCD_VOLTS_ON         SymbolON(25,2)
#define _LCD_PROGRAM_ON         SymbolON(25,3)
#define _LCD_VOL_ON         SymbolON(24,0)
#define _LCD_VOL3_ON         SymbolON(24,1)
#define _LCD_VOL4_ON         SymbolON(24,2)
#define _LCD_VOL5_ON         SymbolON(24,3)
#define _LCD_BAT4_ON         SymbolON(23,0)
#define _LCD_BAT3_ON         SymbolON(23,1)
#define _LCD_BAT2_ON         SymbolON(23,2)
#define _LCD_BAT1_ON         SymbolON(23,3)
#define _LCD_BATTERY_ON         SymbolON(22,3)
#define _LCD_CLOCK_ON         SymbolON(36,3)
#define _LCD_COL2_ON         SymbolON(20,2)
#define _LCD_DOT5_ON         SymbolON(20,3)
#define _LCD_VOLUME_ON         SymbolON(19,3)
#define _LCD_COOL_ON         SymbolON(32,3)
#define _LCD_TEMP_ON         SymbolON(31,3)
#define _LCD_HEAT_ON         SymbolON(38,3)
#define _LCD_FREESCALE_ON         SymbolON(37,3)
#define _LCD_MODE_ON         SymbolON(14,3)
#define _LCD_CONTRAST_ON         SymbolON(43,3)

/*
SymbolOFF
 Turns off the  segment   that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns off that Symbol 
*/
	#define   _LCD_TIME_OFF            SymbolOFF(6,3)
	#define   _LCD_DOT1_OFF            SymbolOFF(7,2)
	#define   _LCD_MINUS_OFF           SymbolOFF(7,3)
	#define   _LCD_DATE_OFF           SymbolOFF(10,3)
	#define   _LCD_COL1_OFF           SymbolOFF(11,2)
	#define   _LCD_DOT2_OFF           SymbolOFF(11,3)
	#define   _LCD_POWER_OFF           SymbolOFF(33,3)
	#define   _LCD_COL3_OFF           SymbolOFF(34,2)
	#define   _LCD_DOT7_OFF           SymbolOFF(34,3)
	#define   _LCD_COL4_OFF           SymbolOFF(28,3)
	#define   _LCD_DOT9_OFF           SymbolOFF(27,2)
	#define   _LCD_VOL1_OFF           SymbolOFF(27,3)
	#define   _LCD_VOL2_OFF           SymbolOFF(26,0)
	#define   _LCD_AM_OFF           SymbolOFF(26,1)
	#define   _LCD_PM_OFF           SymbolOFF(26,2)
	#define   _LCD_OHM_OFF           SymbolOFF(26,3)
	#define   _LCD_KWh_OFF           SymbolOFF(25,0)
	#define   _LCD_AMPS_OFF           SymbolOFF(25,1)
	#define   _LCD_VOLTS_OFF           SymbolOFF(25,2)
	#define   _LCD_PROGRAM_OFF           SymbolOFF(25,3)
	#define   _LCD_VOL_OFF           SymbolOFF(24,0)
	#define   _LCD_VOL3_OFF           SymbolOFF(24,1)
	#define   _LCD_VOL4_OFF           SymbolOFF(24,2)
	#define   _LCD_VOL5_OFF           SymbolOFF(24,3)
	#define   _LCD_BAT4_OFF           SymbolOFF(23,0)
	#define   _LCD_BAT3_OFF           SymbolOFF(23,1)
	#define   _LCD_BAT2_OFF           SymbolOFF(23,2)
	#define   _LCD_BAT1_OFF           SymbolOFF(23,3)
	#define   _LCD_BATTERY_OFF           SymbolOFF(22,3)
	#define   _LCD_CLOCK_OFF           SymbolOFF(36,3)
	#define   _LCD_COL2_OFF           SymbolOFF(20,2)
	#define   _LCD_DOT5_OFF           SymbolOFF(20,3)
	#define   _LCD_VOLUME_OFF           SymbolOFF(19,3)
	#define   _LCD_COOL_OFF           SymbolOFF(32,3)
	#define   _LCD_TEMP_OFF           SymbolOFF(31,3)
	#define   _LCD_HEAT_OFF           SymbolOFF(38,3)
	#define   _LCD_FREESCALE_OFF           SymbolOFF(37,3)
	#define   _LCD_MODE_OFF           SymbolOFF(14,3)
	#define   _LCD_CONTRAST_OFF           SymbolOFF(43,3)

/*
MapSegments
Give the apropiate mask to set one segment of the display
param: BitNumber  -- Number of bit that needs to be turn on
*/ 
#define  SEG1         MapSegment (0)
#define  SEG2         MapSegment (1)
#define  SEG3         MapSegment (2)
#define  SEG4         MapSegment (3)
#define  SEG5         MapSegment (4)
#define  SEG6         MapSegment (5)
#define  SEG7         MapSegment (6)
#define  SEG8         MapSegment (7)

/*
Name Segments 
Create a mask to turn on alphanumeric segments
*/ 
#define SEGH	SEG1
#define SEGF	SEG2
#define SEGE	SEG3
#define SEGN	SEG4

#define SEGA	SEG1   
#define SEGJ		SEG2    
#define SEGG	SEG3   
#define SEGM	SEG4   

#define SEGK	SEG1   
#define SEGL	SEG2    
#define SEGD	SEG3   

#define SEGB	SEG1   
#define SEGC	SEG2    

#define _Backupa	SEGH+ SEGF + SEGE + SEGN
#define _Backupb	SEGA + SEGJ + SEGG + SEGM 
#define _Backupc	SEGK + SEGL + SEGD
#define _Backupd SEGB + SEGC

//Ascii table DEMO9S08LG32
#define  _0             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 0 ,   offset =0
#define  _1              (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 1 ,   offset =2
#define  _2             (!SEGH + !SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB + !SEGC)  ,  //Char = 2 ,   offset =4
#define  _3             (!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 3 ,   offset =6
#define  _4             (!SEGH +  SEGF + !SEGE + !SEGN)  ,     (!SEGA +  SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 4 ,   offset =8
#define  _5             (!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA +  SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB +  SEGC)  ,  //Char = 5 ,   offset =10
#define  _6             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB +  SEGC)  ,  //Char = 6 ,   offset =12
#define  _7             (!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 7 ,   offset =14
#define  _8             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 8 ,   offset =16
#define  _9             (!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA +  SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = 9 ,   offset =18
#define  _AllOff       (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = : ,   offset =20
#define  _SemiColon  (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK +  SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = ; ,   offset =22
#define  _MinusThan (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     ( SEGK +  SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = < ,   offset =24
#define  _Equal        (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = = ,   offset =26
#define  _GreaterThan ( SEGH + !SEGF + !SEGE +  SEGN)  ,     (!SEGA + !SEGF + !SEGE +  SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = > ,   offset =28
#define  _Question   (SEGH + !SEGF + !SEGE +  SEGN)  ,     ( SEGA + !SEGF + !SEGE +  SEGN)  ,     ( SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = ? ,   offset =30
#define  _AllOn         ( SEGH +  SEGF +  SEGE +  SEGN)  ,     ( SEGA +  SEGF +  SEGE +  SEGN)  ,     ( SEGK +  SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = @ ,   offset =32
#define  _A             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = A ,   offset =34
#define  _B             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB +  SEGC)  ,  //Char = B ,   offset =36
#define  _C             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = C ,   offset =38
#define  _D             (!SEGH + !SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = D ,   offset =40
#define  _E             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = E ,   offset =42
#define  _F             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = F ,   offset =44
#define  _G            (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB +  SEGC)  ,  //Char = G ,   offset =46
#define  _H            (!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = H ,   offset =48
#define  _I              (!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = I ,   offset =50
#define  _J             (!SEGH + !SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = J ,   offset =52
#define  _K             (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     ( SEGK +  SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = K ,   offset =54
#define  _L             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = L ,   offset =56
#define  _M            ( SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     ( SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = M ,   offset =58
#define  _N            ( SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK +  SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = N ,   offset =60
#define  _O            (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = O ,   offset =62
#define  _P             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB + !SEGC)  ,  //Char = P ,   offset =64
#define  _Q             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK +  SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = Q ,   offset =66
#define  _R             (!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK +  SEGL +  SEGE)  ,     ( SEGB + !SEGC)  ,  //Char = R ,   offset =68
#define  _S              (!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA +  SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB +  SEGC)  ,  //Char = S ,   offset =70
#define  _T              (!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGF + !SEGE + !SEGN)  ,     (!SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = T ,   offset =72
#define  _U              (!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA +  SEGF +  SEGE + !SEGN)  ,     (!SEGK + !SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = U ,   offset =74
#define  _V              (!SEGH +  SEGF + !SEGE +  SEGN)  ,     (!SEGA +  SEGF + !SEGE +  SEGN)  ,     (!SEGK +  SEGL + !SEGE)  ,     ( SEGB + !SEGC)  ,  //Char = V ,   offset =76
#define  _W             (!SEGH +  SEGF +  SEGE +  SEGN)  ,     (!SEGA +  SEGF +  SEGE +  SEGN)  ,     (!SEGK +  SEGL +  SEGE)  ,     ( SEGB +  SEGC)  ,  //Char = W ,   offset =78
#define  _X              ( SEGH + !SEGF + !SEGE +  SEGN)  ,     (!SEGA + !SEGF + !SEGE +  SEGN)  ,     ( SEGK +  SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = X ,   offset =80
#define  _Y              ( SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGF + !SEGE + !SEGN)  ,     ( SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = Y ,   offset =82
#define  _Z              (!SEGH + !SEGF + !SEGE +  SEGN)  ,     ( SEGA + !SEGF + !SEGE +  SEGN)  ,     ( SEGK + !SEGL + !SEGE)  ,     (!SEGB + !SEGC)  ,  //Char = Z ,   offset =84



