/****************************************************************************************************/
/*
\file       LCD_HAL.h
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.		*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.                                                                                     	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __LCD_HAL_H
#define __LCD_HAL_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "FslTypes.h"

//#define MC9RS08LE4
//#define MC9RS08LA8
//#define MC9S08LL16
#define MC9S08LG32
//#define MCF51EM256
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/

/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define _LCDBACKPLANES			(4)				// # of backplanes  
#define _LCDCLKSOURCE			(1)				// 0 -- External clock       1 --  Alternate clock  (Internal)

#define _LCDCLKPSL				(3)				//  Clock divider to generate the LCD Waveforms

#define _LCDCPSEL				(1)				//0 -- Resistor network   1 -- Charge pump  
#define _LCDVSUPPLY				(1)				//0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external 
#define _LCDLOADADJUST			(0)				//Charge pump 		0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
                                                //Resistor Network	0 -- 2000 pf 1 -- 2000 pf  2 -- 8000 pf   3 -- 8000 pf 

#define _LCDFRAMEINTERRUPT		(0)             //0 Disabel  Interrupt 1 Enable aLCD interrupt that coincides with the LCD frame frequency

#define _LCDBLINKRATE 			(0)				//Blink frequecy preescaler  any number between 0-7

#define _CHARNUM				(9)				// Number of characters on the display

#define _LCDTYPE				(4)				//Number of LCDWF  nedded  to drive one character 

/*^^^^^^^^^^^^^^^^      LCD Hardware Connection 			 ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define EnableLCDpins(RegNum,Mask)		LCDPEN##RegNum = Mask
#define EnableBackplanes(RegNum, Mask)	LCDBPEN##RegNum = Mask   
#define SetBackplane(ComNum, LCDn)		LCDWF##LCDn  = (1 <<  (##ComNum##))
#define CharacterPlace(LCDn)        	LCDWF##LCDn
#define AllSegmentsON(LCDn,ComMask)		LCDWF##LCDn = ComMask
#define SymbolON(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] |= (1<< BitNumber))
#define SymbolOFF(LCDn, BitNumber)		LCDWF##LCDn = (gu8RamBuffer[LCDn] &= ~(1<< BitNumber))
#define MapSegment(BitNumber)  			(1<<(##BitNumber##)) 
#define LCDWFRef          				LCDWF0
#define LCD_AlphanumericPlace(Place)	bLCD_CharPosition=_LCDTYPE*##(Place-1)
/*
EnableLCDpins
Habilitate the mcu pin with the characteristics of a LCD pin 
param: RegNum -- Number of register to write     Mask --- Mask that habilitate the LCDx pins
*/
	#define _PEN0()       EnableLCDpins (0,255)
	#define _PEN1()       EnableLCDpins (1,255)
	#define _PEN2()       EnableLCDpins (2,255)
	#define _PEN3()       EnableLCDpins (3,255)
	#define _PEN4()       EnableLCDpins (4,255)
	#define _PEN5()       EnableLCDpins (5,15)

/* 
EnableBackplanes
Enable the LCD pin like a Backplane functionality  
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number that the Backplane it's connected 
*/
	#define   _BPEN0()        EnableBackplanes (0, 15)
	#define   _BPEN1()        EnableBackplanes (1, 0)
	#define   _BPEN2()        EnableBackplanes (2, 0)
	#define   _BPEN3()        EnableBackplanes (3, 0)
	#define   _BPEN4()        EnableBackplanes (4, 0)
	#define   _BPEN5()        EnableBackplanes (5, 0)

/*
SetBackplane
 Give the COM number  to the previous enable Backplane     
param: ComNum -- COM number     LCDpin --- LCDn number of pin that its connected  
*/
	#define   _SETCOM1()        SetBackplane (0, 0)
	#define   _SETCOM2()        SetBackplane (1, 1)
	#define   _SETCOM3()        SetBackplane (2, 2)
	#define   _SETCOM4()        SetBackplane (3, 3)

/*
Character place
This macro defines the LDCWavefroms directions needed for write the alphanumerics        
param:  LCDpin --- LCDn number of pin that its connected */

	#define   CHAR1A           (4)
	#define   CHAR1B           (5)
	#define   CHAR1C           (6)
	#define   CHAR1D           (7)
	#define   CHAR2A           (8)
	#define   CHAR2B           (9)
	#define   CHAR2C           (10)
	#define   CHAR2D           (11)
	#define   CHAR3A           (29)
	#define   CHAR3B           (30)
	#define   CHAR3C           (37)
	#define   CHAR3D           (38)
	#define   CHAR4A           (39)
	#define   CHAR4B           (40)
	#define   CHAR4C           (31)
	#define   CHAR4D           (32)
	#define   CHAR5A           (17)
	#define   CHAR5B           (18)
	#define   CHAR5C           (19)
	#define   CHAR5D           (20)
	#define   CHAR6A           (21)
	#define   CHAR6B           (35)
	#define   CHAR6C           (36)
	#define   CHAR6D           (22)
	#define   CHAR7A           (12)
	#define   CHAR7B           (13)
	#define   CHAR7C           (33)
	#define   CHAR7D           (34)
	#define   CHAR8A           (41)
	#define   CHAR8B           (42)
	#define   CHAR8C           (43)
	#define   CHAR8D           (14)
	#define   CHAR9A           (15)
	#define   CHAR9B           (16)
	#define   CHAR9C           (28)
	#define   CHAR9D           (27)


/* 
AllSegmentsON
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3
*/
	#define SEGMENT1_ON               AllSegmentsON ( 4,15 )
	#define SEGMENT2_ON               AllSegmentsON ( 5,15 )
	#define SEGMENT3_ON               AllSegmentsON ( 6,15 )
	#define SEGMENT4_ON               AllSegmentsON ( 7,15 )
	#define SEGMENT5_ON               AllSegmentsON ( 8,15 )
	#define SEGMENT6_ON               AllSegmentsON ( 9,15 )
	#define SEGMENT7_ON               AllSegmentsON ( 10,15 )
	#define SEGMENT8_ON               AllSegmentsON ( 11,15 )
	#define SEGMENT9_ON               AllSegmentsON ( 12,15 )
	#define SEGMENT10_ON              AllSegmentsON ( 13,15 )
	#define SEGMENT11_ON              AllSegmentsON ( 33,15 )
	#define SEGMENT12_ON              AllSegmentsON ( 34,15 )
	#define SEGMENT13_ON              AllSegmentsON ( 41,15 )
	#define SEGMENT14_ON              AllSegmentsON ( 42,15 )
	#define SEGMENT15_ON              AllSegmentsON ( 43,15 )
	#define SEGMENT16_ON              AllSegmentsON ( 14,15 )
	#define SEGMENT17_ON              AllSegmentsON ( 15,15 )
	#define SEGMENT18_ON              AllSegmentsON ( 16,15 )
	#define SEGMENT19_ON              AllSegmentsON ( 28,15 )
	#define SEGMENT20_ON              AllSegmentsON ( 27,15 )
	#define SEGMENT21_ON              AllSegmentsON ( 26,15 )
	#define SEGMENT22_ON              AllSegmentsON ( 25,15 )
	#define SEGMENT23_ON              AllSegmentsON ( 24,15 )
	#define SEGMENT24_ON              AllSegmentsON ( 23,15 )
	#define SEGMENT25_ON              AllSegmentsON ( 22,15 )
	#define SEGMENT26_ON              AllSegmentsON ( 36,15 )
	#define SEGMENT27_ON              AllSegmentsON ( 35,15 )
	#define SEGMENT28_ON              AllSegmentsON ( 21,15 )
	#define SEGMENT29_ON              AllSegmentsON ( 20,15 )
	#define SEGMENT30_ON              AllSegmentsON ( 19,15 )
	#define SEGMENT31_ON              AllSegmentsON ( 18,15 )
	#define SEGMENT32_ON              AllSegmentsON ( 17,15 )
	#define SEGMENT33_ON              AllSegmentsON ( 32,15 )
	#define SEGMENT34_ON              AllSegmentsON ( 31,15 )
	#define SEGMENT35_ON              AllSegmentsON ( 40,15 )
	#define SEGMENT36_ON              AllSegmentsON ( 39,15 )
	#define SEGMENT37_ON              AllSegmentsON ( 38,15 )
	#define SEGMENT38_ON              AllSegmentsON ( 37,15 )
	#define SEGMENT39_ON              AllSegmentsON ( 30,15 )
	#define SEGMENT40_ON              AllSegmentsON ( 29,15 )
/* 
AllSegmentsOFF
Turns on all the segments of the custom glass   
param: LCDn -- LCDWF that needs to be turn on	ComMask -- Bits that are turn on example: 8 COM = 255   2 COM = 3*/
	#define SEGMENT1_OFF                AllSegmentsON ( 4, 0 )
	#define SEGMENT2_OFF                AllSegmentsON ( 5, 0 )
	#define SEGMENT3_OFF                AllSegmentsON ( 6, 0 )
	#define SEGMENT4_OFF                AllSegmentsON ( 7, 0 )
	#define SEGMENT5_OFF                AllSegmentsON ( 8, 0 )
	#define SEGMENT6_OFF                AllSegmentsON ( 9, 0 )
	#define SEGMENT7_OFF                AllSegmentsON ( 10, 0 )
	#define SEGMENT8_OFF                AllSegmentsON ( 11, 0 )
	#define SEGMENT9_OFF                AllSegmentsON ( 12, 0 )
	#define SEGMENT10_OFF               AllSegmentsON ( 13, 0 )
	#define SEGMENT11_OFF       	    AllSegmentsON ( 33, 0 )
	#define SEGMENT12_OFF               AllSegmentsON ( 34, 0 )
	#define SEGMENT13_OFF               AllSegmentsON ( 41, 0 )
	#define SEGMENT14_OFF               AllSegmentsON ( 42, 0 )
	#define SEGMENT15_OFF               AllSegmentsON ( 43, 0 )
	#define SEGMENT16_OFF               AllSegmentsON ( 14, 0 )
	#define SEGMENT17_OFF               AllSegmentsON ( 15, 0 )
	#define SEGMENT18_OFF               AllSegmentsON ( 16, 0 )
	#define SEGMENT19_OFF               AllSegmentsON ( 28, 0 )
	#define SEGMENT20_OFF               AllSegmentsON ( 27, 0 )
	#define SEGMENT21_OFF               AllSegmentsON ( 26, 0 )
	#define SEGMENT22_OFF               AllSegmentsON ( 25, 0 )
	#define SEGMENT23_OFF               AllSegmentsON ( 24, 0 )
	#define SEGMENT24_OFF               AllSegmentsON ( 23, 0 )
	#define SEGMENT25_OFF               AllSegmentsON ( 22, 0 )
	#define SEGMENT26_OFF               AllSegmentsON ( 36, 0 )
	#define SEGMENT27_OFF               AllSegmentsON ( 35, 0 )
	#define SEGMENT28_OFF               AllSegmentsON ( 21, 0 )
	#define SEGMENT29_OFF               AllSegmentsON ( 20, 0 )
	#define SEGMENT30_OFF               AllSegmentsON ( 19, 0 )
	#define SEGMENT31_OFF               AllSegmentsON ( 18, 0 )
	#define SEGMENT32_OFF               AllSegmentsON ( 17, 0 )
	#define SEGMENT33_OFF               AllSegmentsON ( 32, 0 )
	#define SEGMENT34_OFF               AllSegmentsON ( 31, 0 )
	#define SEGMENT35_OFF               AllSegmentsON ( 40, 0 )
	#define SEGMENT36_OFF               AllSegmentsON ( 39, 0 )
	#define SEGMENT37_OFF               AllSegmentsON ( 38, 0 )
	#define SEGMENT38_OFF               AllSegmentsON ( 37, 0 )
	#define SEGMENT39_OFF               AllSegmentsON ( 30, 0 )
	#define SEGMENT40_OFF               AllSegmentsON ( 29, 0 )


/* 
SymbolON
Turns on the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol 
*/
	#define _LCD_TIME_ON		SymbolON(6,3)
	#define _LCD_DOT1_ON        SymbolON(7,2)
	#define _LCD_MINUS_ON       SymbolON(7,3)
	#define _LCD_DATE_ON        SymbolON(10,3)
	#define _LCD_COL1_ON        SymbolON(11,2)
	#define _LCD_DOT2_ON        SymbolON(11,3)
	#define _LCD_POWER_ON       SymbolON(33,3)
	#define _LCD_COL3_ON        SymbolON(34,2)
	#define _LCD_DOT7_ON        SymbolON(34,3)
	#define _LCD_COL4_ON        SymbolON(28,3)
	#define _LCD_DOT9_ON        SymbolON(27,2)
	#define _LCD_VOL1_ON        SymbolON(27,3)
	#define _LCD_VOL2_ON        SymbolON(26,0)
	#define _LCD_AM_ON          SymbolON(26,1)
	#define _LCD_PM_ON          SymbolON(26,2)
	#define _LCD_OHM_ON         SymbolON(26,3)
	#define _LCD_KWh_ON         SymbolON(25,0)
	#define _LCD_AMPS_ON        SymbolON(25,1)
	#define _LCD_VOLTS_ON       SymbolON(25,2)
	#define _LCD_PROGRAM_ON     SymbolON(25,3)
	#define _LCD_VOL_ON         SymbolON(24,0)
	#define _LCD_VOL3_ON        SymbolON(24,1)
	#define _LCD_VOL4_ON        SymbolON(24,2)
	#define _LCD_VOL5_ON        SymbolON(24,3)
	#define _LCD_BAT4_ON        SymbolON(23,0)
	#define _LCD_BAT3_ON        SymbolON(23,1)
	#define _LCD_BAT2_ON        SymbolON(23,2)
	#define _LCD_BAT1_ON        SymbolON(23,3)
	#define _LCD_BATTERY_ON     SymbolON(22,3)
	#define _LCD_CLOCK_ON       SymbolON(36,3)
	#define _LCD_COL2_ON        SymbolON(20,2)
	#define _LCD_DOT5_ON        SymbolON(20,3)
	#define _LCD_VOLUME_ON      SymbolON(19,3)
	#define _LCD_COOL_ON        SymbolON(32,3)
	#define _LCD_TEMP_ON        SymbolON(31,3)
	#define _LCD_HEAT_ON        SymbolON(38,3)
	#define _LCD_FREESCALE_ON   SymbolON(37,3)
	#define _LCD_MODE_ON        SymbolON(14,3)
	#define _LCD_CONTRAST_ON    SymbolON(43,3)
						
/*
SymbolOFF
Turns off the  segment   that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns off that Symbol 
*/
	#define   _LCD_TIME_OFF           SymbolOFF(6,3)
	#define   _LCD_DOT1_OFF           SymbolOFF(7,2)
	#define   _LCD_MINUS_OF           SymbolOFF(7,3)
	#define   _LCD_DATE_OFF           SymbolOFF(10,3)
	#define   _LCD_COL1_OFF           SymbolOFF(11,2)
	#define   _LCD_DOT2_OFF           SymbolOFF(11,3)
	#define   _LCD_POWER_OFF          SymbolOFF(33,3)
	#define   _LCD_COL3_OFF           SymbolOFF(34,2)
	#define   _LCD_DOT7_OFF           SymbolOFF(34,3)
	#define   _LCD_COL4_OFF           SymbolOFF(28,3)
	#define   _LCD_DOT9_OFF           SymbolOFF(27,2)
	#define   _LCD_VOL1_OFF           SymbolOFF(27,3)
	#define   _LCD_VOL2_OFF           SymbolOFF(26,0)
	#define   _LCD_AM_OFF             SymbolOFF(26,1)
	#define   _LCD_PM_OFF             SymbolOFF(26,2)
	#define   _LCD_OHM_OFF            SymbolOFF(26,3)
	#define   _LCD_KWh_OFF            SymbolOFF(25,0)
	#define   _LCD_AMPS_OFF           SymbolOFF(25,1)
	#define   _LCD_VOLTS_OFF          SymbolOFF(25,2)
	#define   _LCD_PROGRAM_OFF        SymbolOFF(25,3)
	#define   _LCD_VOL_OFF            SymbolOFF(24,0)
	#define   _LCD_VOL3_OFF           SymbolOFF(24,1)
	#define   _LCD_VOL4_OFF           SymbolOFF(24,2)
	#define   _LCD_VOL5_OFF           SymbolOFF(24,3)
	#define   _LCD_BAT4_OFF           SymbolOFF(23,0)
	#define   _LCD_BAT3_OFF           SymbolOFF(23,1)
	#define   _LCD_BAT2_OFF           SymbolOFF(23,2)
	#define   _LCD_BAT1_OFF           SymbolOFF(23,3)
	#define   _LCD_BATTERY_OFF        SymbolOFF(22,3)
	#define   _LCD_CLOCK_OFF          SymbolOFF(36,3)
	#define   _LCD_COL2_OFF           SymbolOFF(20,2)
	#define   _LCD_DOT5_OFF           SymbolOFF(20,3)
	#define   _LCD_VOLUME_OFF         SymbolOFF(19,3)
	#define   _LCD_COOL_OFF           SymbolOFF(32,3)
	#define   _LCD_TEMP_OFF           SymbolOFF(31,3)
	#define   _LCD_HEAT_OFF           SymbolOFF(38,3)
	#define   _LCD_FREESCALE_OFF      SymbolOFF(37,3)
	#define   _LCD_MODE_OFF           SymbolOFF(14,3)
	#define   _LCD_CONTRAST_OFF       SymbolOFF(43,3)

/*
MapSegments
Give the apropiate mask to set one segment of the display
param: BitNumber  -- Number of bit that needs to be turn on
*/ 
#define  SEG1         MapSegment (0)
#define  SEG2         MapSegment (1)
#define  SEG3         MapSegment (2)
#define  SEG4         MapSegment (3)
#define  SEG5         MapSegment (4)
#define  SEG6         MapSegment (5)
#define  SEG7         MapSegment (6)
#define  SEG8         MapSegment (7)

/*
Name Segments 
Create a mask to turn on alphanumeric segments
*/ 
#define SEGH	SEG1
#define SEGF	SEG2
#define SEGE	SEG3
#define SEGN	SEG4

#define SEGA	SEG1   
#define SEGJ    SEG2    
#define SEGG	SEG3   
#define SEGM	SEG4   

#define SEGK	SEG1   
#define SEGL	SEG2    
#define SEGD	SEG3   

#define SEGB	SEG1   
#define SEGC	SEG2    

#define _Backupa	(SEGH+ SEGF + SEGE + SEGN) ^ 0xFF 
#define _Backupb	(SEGA + SEGJ + SEGG + SEGM)^ 0xFF
#define _Backupc	(SEGK + SEGL + SEGD) ^ 0xFF
#define _Backupd 	(SEGB + SEGC) ^ 0xFF

//Ascii table DEMO9S08LG32
#define  _0				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 0 ,   offset =0
#define  _1             (!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 1 ,   offset =2
#define  _2             (!SEGH + !SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB + !SEGC)  ,  //Char = 2 ,   offset =4
#define  _3      		(!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 3 ,   offset =6
#define  _4      		(!SEGH +  SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 4 ,   offset =8
#define  _5      		(!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB +  SEGC)  ,  //Char = 5 ,   offset =10
#define  _6      		(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB +  SEGC)  ,  //Char = 6 ,   offset =12
#define  _7             (!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 7 ,   offset =14
#define  _8            	(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 8 ,   offset =16
#define  _9            	(!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = 9 ,   offset =18
#define  _AllOff      	(!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = AllOff ,   offset =20
#define  _SemiColon   	(!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG +  SEGM)  ,     (!SEGK +  SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = SemiColon ,   offset =22
#define  _MinusThan   	(!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     ( SEGK +  SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = MinusThan ,   offset =24
#define  _Equal			(!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = Equal ,   offset =26
#define  _GreaterThan   ( SEGH + !SEGF + !SEGE +  SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = GreaterThan ,   offset =28
#define  _Question      ( SEGH + !SEGF + !SEGE +  SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     ( SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = Question ,   offset =30
#define  _AllOn     	( SEGH +  SEGF +  SEGE +  SEGN)  ,     ( SEGA +  SEGJ +  SEGG +  SEGM)  ,     ( SEGK +  SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = AllOn ,   offset =32
#define  _A      		(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = A ,   offset =34
#define  _B      		(!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB +  SEGC)  ,  //Char = B ,   offset =36
#define  _C      		(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = C ,   offset =38
#define  _D      		(!SEGH + !SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = D ,   offset =40
#define  _E      		(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = E ,   offset =42
#define  _F				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = F ,   offset =44
#define  _G				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB +  SEGC)  ,  //Char = G ,   offset =46
#define  _H				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = H ,   offset =48
#define  _I				(!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA +  SEGJ + !SEGG +  SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = I ,   offset =50
#define  _J				(!SEGH + !SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = J ,   offset =52
#define  _K				(!SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA +  SEGJ + !SEGG +  SEGM)  ,     ( SEGK +  SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = K ,   offset =54
#define  _L				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = L ,   offset =56
#define  _M				( SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     ( SEGK + !SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = M ,   offset =58
#define  _N				( SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK +  SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = N ,   offset =60
#define  _O				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = O ,   offset =62
#define  _P				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     ( SEGB + !SEGC)  ,  //Char = P ,   offset =64
#define  _Q				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK +  SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = Q ,   offset =66
#define  _R				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK +  SEGL + !SEGD)  ,     ( SEGB + !SEGC)  ,  //Char = R ,   offset =68
#define  _S				(!SEGH +  SEGF + !SEGE + !SEGN)  ,     ( SEGA + !SEGJ +  SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     (!SEGB +  SEGC)  ,  //Char = S ,   offset =70
#define  _T				(!SEGH + !SEGF + !SEGE + !SEGN)  ,     ( SEGA +  SEGJ + !SEGG +  SEGM)  ,     (!SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = T ,   offset =72
#define  _U				(!SEGH +  SEGF +  SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK + !SEGL +  SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = U ,   offset =74
#define  _V				(!SEGH +  SEGF + !SEGE +  SEGN)  ,     (!SEGA + !SEGJ + !SEGG +  SEGM)  ,     (!SEGK +  SEGL + !SEGD)  ,     ( SEGB + !SEGC)  ,  //Char = V ,   offset =76
#define  _W				(!SEGH +  SEGF +  SEGE +  SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     (!SEGK +  SEGL + !SEGD)  ,     ( SEGB +  SEGC)  ,  //Char = W ,   offset =78
#define  _X				( SEGH + !SEGF + !SEGE +  SEGN)  ,     (!SEGA + !SEGJ + !SEGG + !SEGM)  ,     ( SEGK +  SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = X ,   offset =80
#define  _Y				( SEGH + !SEGF + !SEGE + !SEGN)  ,     (!SEGA + !SEGJ + !SEGG +  SEGM)  ,     ( SEGK + !SEGL + !SEGD)  ,     (!SEGB + !SEGC)  ,  //Char = Y ,   offset =82
#define  _Z				(!SEGH + !SEGF + !SEGE +  SEGN)  ,     ( SEGA + !SEGJ + !SEGG + !SEGM)  ,     ( SEGK + !SEGL +  SEGD)  ,     (!SEGB + !SEGC)    //Char = Z ,   offset =84

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __LCD_HAL_H */
