/*
 * File:		slcd_drv.c
 * Purpose:		Example showing the segement LCD driver use.  and  LCD fault detect measurements
 *                      For fault detect requires the board to be conneted to the P&E terminal 115200,8,n,1
                        and press any key to measure the current capacitance on the pin, and display the value
                        a basic test to observe the difference consist in measure the current capacitance, then remove the sLCD poanel and
                        perform another measurement

 * Date:                September 5,2011
 */

#include "common.h"
#include "uart.h"


#include "LCD.h"



// Following functions are implemented to show how FAULT DETECTION feature.
void ldc_fault_detection_measure(void);  // measure the LCD pin capacitance and stor in the lcd_pin_cap[] array
void  lcd_fault_example(void);           // calls ldc_fault_detection_measure() and display results.


/* 
   Variables for LCD fault detect demonstration
*/

/* Reserve space for fault detect measurments */
uint8  lcd_pin_cap[_LCDUSEDPINS];     // Store the value of the Capacitance measured in each pin

/* 
   Fault detection variables 
      The Fault detect prescaler and fault detect sample width, should be selected according to the LCD,  in this case only was required 
      to diferentiate between front plane and backplanes.  In some circumstances this value can be different for each pin.

    The values selected here were obtained experimentally

 Fault detect initial parameters and limits 
        FAULTD_FP_FDPRS  FDPRS_32
        FAULTD_FP_FDSWW  FDSWW_128
         FAULTD_BP_FDPRS  FDPRS_64
       FAULTD_BP_FDSWW  FDSWW_128

*/
uint8  lcd_fp_fdprs_val;
uint8  lcd_fp_fdsww_val;
uint8  lcd_bp_fdprs_val;
uint8  lcd_bp_fdsww_val;



uint32 sLCDIsrvCount;

/****************************************************************************************************/
/**
* \brief  LCD frame interrupt callback   
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnLcdInterruptCallBack(void)
 {
   sLCDIsrvCount++;
 }


/****************************************************************************************************/
/**
* \brief  main function
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/

void main(void) 
{
  char DispBuffer[10];   // Temporal buffer to store formatted output from sprintf function
  uint16 mainLoopCount;
    
  vfnLCD_Init();

  vfnLCD_Set_Display();
  vfnLCD_Clear_Display();
  
  vfnLCD_Write_Msg ("1234"); // the 6363P 1st character can only write 1, that is why a place holder is set at beginning
  
  // Symbols ON
  _FREESCALE_ON();
  _ONE_ON();
  _COL_ON();
  _GRADE_ON();
  _PERCENTAGE_ON();
  _AM_ON();
  _PM_ON();
  
    // Symbols OFF
  _FREESCALE_OFF();
  _ONE_OFF();
  _COL_OFF();
  _GRADE_OFF();
  _PERCENTAGE_OFF();
  _AM_OFF();
  _PM_OFF();
  _FREESCALE_ON(); 
  
 
   
  vfnLCD_Write_Msg ("1999");  //Write an asccii string: Limited by what LCD type can display
  EnableInterrupts; 
  for(;;)
 {
   if (mainLoopCount++>1999) mainLoopCount=0;      // This LCD only can represent numbers until 1999
   sprintf(DispBuffer,"%04i",sLCDIsrvCount % 2000); //prepare to display sLCD interrupt counter "sLCDIsrvCount"
     
  //format examples:
  //sprintf(DispBuffer,"%04i",mainLoopCount);       //Display main loop counter   mainLoopCount
  //sprintf(DispBuffer,"%02i%02i",hour,min);               // Display as HH:mm
  
   vfnLCD_Write_Msg (DispBuffer);     // Display formatted buffer 
   
   
   /* For fault detect measurments press any key */
   if (uart_getchar_present(TERM_PORT)) 
   {
    (void)uart_getchar(TERM_PORT);   //clear UART flag
    lcd_fault_example();   //take measurement of all active LCD pins and display its value 
   }
   
  } 
}






/*********************   ldc_fault_detection_measure   ******************************************/
/**
* \brief  Measure the capacitance of each used LCD pin and store it on lcd_pin_cap[] array.
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void ldc_fault_detection_measure(void)
  {
    uint8  i;
    uint8 lcd_cap_val;
    
    vfnlcd_pinmux(7);  // Configures LCD for Fault detection mode  (port control enabled)
    for(i=0;i<_LCDUSEDPINS;i++)
    { 
      if (i<_LCDFRONTPLANES)
      {  
      lcd_cap_val = u8fnlcd_measure_pin_cap(WF_ORDERING_TABLE[i],FP_TYPE,lcd_fp_fdprs_val,lcd_fp_fdsww_val);
      } 
      else
     { 
       lcd_cap_val = u8fnlcd_measure_pin_cap(WF_ORDERING_TABLE[i],BP_TYPE,lcd_bp_fdprs_val,lcd_bp_fdsww_val);
     }  
     lcd_pin_cap[i] = lcd_cap_val;
    }
   vfnlcd_pinmux(0);   // Configures sLCD for normal operation
  }
  



/*********************   lcd_fault_measure_all   ******************************************/
/**
* \brief  lcd_fault_measure_all, this function shows how to use the fault detection functions
*   to measure the capacitance in all used LCD pins.
* \param  void 
* \return void
* \todo     
*/
/****************************************************************************************************/
void  lcd_fault_example(void)
 {
         uint8 i;
        
  /*  Configure */ 
         
        lcd_fp_fdprs_val =  FAULTD_FP_FDPRS;  //FDPRS_32;
         lcd_fp_fdsww_val =  FAULTD_FP_FDSWW;  //FDSWW_128;
         lcd_bp_fdprs_val =  FAULTD_BP_FDPRS;  //FDPRS_64;
         lcd_bp_fdsww_val =  FAULTD_BP_FDSWW;  //FDSWW_128;
    

         
         printf("\n\r LCD Fault Detect: Measure and display LCD pin capacitances of pin used.");
         ldc_fault_detection_measure();
         
         
        /*Display value of capacitance */
         for(i=0;i<_LCDUSEDPINS;i++)
         { 
           if (i<_LCDFRONTPLANES)
           {  
           printf("\n\r FP[%i],LCDWF[%i] = %i ",i,WF_ORDERING_TABLE[i],lcd_pin_cap[i]); //print front plane capacitance
           }
           else  // it is a backplane
           {
            printf("\n\r BP[%i],LCDWF[%i] = %i ",i- _LCDFRONTPLANES, WF_ORDERING_TABLE[i],lcd_pin_cap[i]);
           }
          }  
    }

