/**************************************************************************/
/*                                            COPYRIGHT (c) FREESCALE 2005 */
/* FILE NAME: m_H7b.h													                            */
/*                                                                        */
/* INCLUDE FILES: m_common.h                                              */
/* VERSION: 1.0                                                           */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* DESCRIPTION: This file completes registers definition for H7F Flash   */
/*				on the H7F memory module.  Re-use from M-Hip7fa.h file         */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* COMPILER: Diab Data        VERSION: 4.4b                               */
/*                                                                        */
/* AUTHOR:		Vincent Vu/D.Connelly       CREATION DATE:  04/04/2005      */
/* LOCATION:	Austin, TX            		                                  */
/*                                                                        */
/*	UPDATE HISTORY                                                        */
/*	REV     AUTHOR		    DATE		    DESCRIPTION OF CHANGE               */
/*	---		-----------     ---------   ---------------------			       	  */
/*	0.1		Vincent Vu	    03/14/03	  Initial Release						          */
/*	0.2		David Connelly  04/04/05	  Modified for Hip7b						      */
/*	0.3		C. He/V. Vu	05/16/05	Fix Bit misalignment for PCLW register*/
/*									Add ISM:5 bits field in MON1		  */
/*									Add BSM:4 bits field in MON1		  */
/*																		  */
/**************************************************************************/

#ifndef _M_H7F_H
	#define _M_H7F_H								 

	#include "MPC5500_H7F.h"	//	MCU Specific definitions

	#ifndef H7F_CTL_REG_BASE
	    #if DEVICE_5516
	        #define H7F_CTL_REG_BASE 0xFFFF8000 // Control Reg base addr for 5516
	    #else    
	    	#define H7F_CTL_REG_BASE 0xC3F88000	// Control Registers Base Address (default)
	    #endif
	#endif

	#include "m_common.h"

	#ifdef  __cplusplus
	extern "C" {
	#endif

	// **************************************************************************
	//                               MODULE :C3F                                 
	// **************************************************************************
	typedef struct H7F_tag
		{
			// HiP7a FLASH EEPROM Configuration Register
			// Register Base + 0x0
			union
			{
				VUINT32 R;
				struct 
				{
					VUINT32:3;			  // UNUSED
					VUINT32 SFS:1;    // Special Flash Selector
					VUINT32 SIZE:4;		// Array Space Size
					VUINT32:1;			  // UNUSED
					VUINT32 LAS:3;		// Low Address Space Size
					VUINT32:3;			  // UNUSED
					VUINT32 MAS:1;		// Mid Address Space Size
					VUINT32 EER:1;		// ECC Event Error
					VUINT32 RWE:1;		// Read While Write Even Error
					VUINT32 BBEPE:1;	// Boot Block External Program/Erase Status
					VUINT32 EPE:1;		// External Program/Erase Status
					VUINT32 PEAS:1;		// Program/Erase Access Space
					VUINT32 DONE:1;		// State Machine Status
					VUINT32 PEG:1;		// Program/Erase Good
					VUINT32:1;			  // UNUSED
					VUINT32 PRD:1;    // Pipelined reads 0=enabled, 1=disabled
					VUINT32 STOP:1;		// Stop Mode Enabled
					VUINT32:1;		  	// UNUSED
					VUINT32 PGM:1;		// Program
					VUINT32 PSUS:1;		// Program Suspend
					VUINT32 ERS:1;		// Erase
					VUINT32 ESUS:1;		// Erase Suspend
					VUINT32 EHV:1;		// Enable High Voltage
				} B;
			} MCR;

			union
			{
				// HiP7a FLASH EEPROM Low/Mid Address Space Block Lock Register (LML)
				// Register Base + 0x4
				VUINT32 R;
				struct
				{
					VUINT32 LME:1;		// Low and Mid Address Lock Enable
					VUINT32:10;			// UNUSED
					VUINT32 SLOCK:1;	// Shadow Lock
					VUINT32 MLOCK:4;	// Mid Address Block Lock
					VUINT32 LLOCK:16;	// Low Address Block Lock
				} B;
			} LML;

			union 
			{
				// HiP7a FLASH EEPROM High Address Space Block Lock Register (HBL)
				// Register Base + 0x8
				VUINT32 R;
				struct 
				{
					VUINT32 HBE:1;		// High Address Lock Enable
					VUINT32:3;			// UNUSED
					VUINT32 HBLOCK:28;	// High Address Space Block Lock
				} B;
			} HBL;

			union
			{
				// HiP7a FLASH EEPROM Secondary Low/Mid Address Space Block Lock Register (SLL)
				// Register Base + 0xC
				VUINT32 R;
				struct
				{
					VUINT32 SLE:1;		// Secondary Low and Mid Address Lock Enable
					VUINT32:10;			// UNUSED
					VUINT32 SSLOCK:1;	// Secondary Shadow Lock
					VUINT32 SMLOCK:4;	// Secondary Mid Address Block Lock
					VUINT32 SLLOCK:16;	// Secondary Low Address Block Lock
				} B;
			} SLL;

			union 
			{
				// HiP7a FLASH EEPROM Low/Mid Address Space Block Select Register (LMS)
				// Register Base + 0x10
				VUINT32 R;
				struct 
				{
					VUINT32:12;			// UNUSED
					VUINT32 MSEL:4;		// Mid Address Space Block Select
					VUINT32 LSEL:16;	// Low Address Space Block Select
				} B;
			} LMS;

			union 
			{
				// HiP7a FLASH EEPROM High Address Space Block Select Register (HBS)
				// Register Base + 0x14
				VUINT32 R;
				struct 
				{
					VUINT32:4;			// UNUSED
					VUINT32 HBSEL:28;	// High Address Space Block Select
				} B;
			} HBS;

			union 
			{
				// HiP7a FLASH EEPROM Address Register (ADR)
				// Register Base + 0x18
				VUINT32 R;
				struct 
				{
					VUINT32:10;			// UNUSED
					VUINT32 ADDR:19;	// Address
					VUINT32:3;			// UNUSED
				} B;
			} ADR;

#if DEVICE_5516	  //5516 has platform flash control regs, not BIU reg's

			union 
	        {                 /* Platform Flash Configuration Register for Port 0 */
                VUINT32 R;
                struct 
                {
                    VUINT32 LBCFG:4;
                    VUINT32 ARB:1;
                    VUINT32 PRI:1;
                    VUINT32:2;
                    VUINT32 M7PFE:1;
                    VUINT32 M6PFE:1;
                    VUINT32 M5PFE:1;
                    VUINT32 M4PFE:1;
                    VUINT32 M3PFE:1;
                    VUINT32 M2PFE:1;
                    VUINT32 M1PFE:1;
                    VUINT32 M0PFE:1;
                    VUINT32 APC:3;
                    VUINT32 WWSC:2;
                    VUINT32 RWSC:3;
                    VUINT32:1;
                    VUINT32 DPFEN:1;
                    VUINT32:1;
                    VUINT32 IPFEN:1;
                    VUINT32:1;
                    VUINT32 PFLIM:2;
                    VUINT32 BFEN:1;
                } B;
            } PFCRP0;

        union 
        {                 /* Platform Flash Configuration Register for Port 1 */
            VUINT32 R;
            struct 
            {
                VUINT32 LBCFG:4;
                VUINT32:4;
                VUINT32 M7PFE:1;
                VUINT32 M6PFE:1;
                VUINT32 M5PFE:1;
                VUINT32 M4PFE:1;
                VUINT32 M3PFE:1;
                VUINT32 M2PFE:1;
                VUINT32 M1PFE:1;
                VUINT32 M0PFE:1;
                VUINT32 APC:3;
                VUINT32 WWSC:2;
                VUINT32 RWSC:3;
                VUINT32:1;
                VUINT32 DPFEN:1;
                VUINT32:1;
                VUINT32 IPFEN:1;
                VUINT32:1;
                VUINT32 PFLIM:2;
                VUINT32 BFEN:1;
            } B;
        } PFCRP1;
	
	    VUINT32 biu_res_5516[3];
	
#else
			union 
			{
				// HiP7a FLASH EEPROM Bus Interface Unit 0 (BIU0)
				// Register Base + 0x1C
				VUINT32 R;
				struct 
				{
					VUINT32 BIU:32;		// BIU0 Generic Registers
				} B;
			} BIU0;

			union 
			{
				// HiP7a FLASH EEPROM Bus Interface Unit 1 (BIU1)
				// Register Base + 0x20
				VUINT32 R;
				struct 
				{
					VUINT32:24;		
					VUINT32 M3AP:2;		// Master 3 Access Protection Configurations
					VUINT32 M2AP:2;		// Master 2 Access Protection Configurations
					VUINT32 M1AP:2;		// Master 1 Access Protection Configurations
					VUINT32 M0AP:2;		// Master 0 Access Protection Configurations
				} B;
			} BIU1;
			
			union 
			{
				// HiP7a FLASH EEPROM Bus Interface Unit s (BIUs)
				// Register Base + 0x1C
				VUINT32 R;
				struct 
				{
					VUINT32 BIU:32;		// BIU Generic Registers
				} B;
			} BIU2;

			union 
			{
				// HiP7a FLASH EEPROM Bus Interface Unit s (BIUs)
				// Register Base + 0x1C
				VUINT32 R;
				struct 
				{
					VUINT32 BIU:32;		// BIU Generic Registers
				} B;
			} BIU3;

			union 
			{
				// HiP7a FLASH EEPROM Bus Interface Unit s (BIUs)
				// Register Base + 0x1C
				VUINT32 R;
				struct 
				{
					VUINT32 BIU:32;		// BIU Generic Registers
				} B;
			} BIU4;
    
#endif //5516 has PFCRP0,1 registers, not BIU registers

			// Address 0x24 to 0x30 is unused (3 - 32 bits word)
			//VUINT32 UNUSED1[3];
			//3 sections unused for Hip7a, used for Hip7b for BIU2-4

			union
			{
				// HiP7a FLASH EEPROM Test 0 Register
				// Register Base + 0x30
				VUINT32 R;
				struct 
				{
					VUINT32 TRE:1;		// Test Row Enable
					VUINT32 SRE:1;		// Shadow Row Enable	
					VUINT32 RBE:1;		// Reference Bit Enable
					VUINT32 VSVP:1;		// Vsup to Vpos (High Voltage)
					VUINT32 VSVV:1;		// Vsup to Verify Voltage
					VUINT32 VSVR:1;		// Vsup to Read Voltage
					VUINT32 VSVH:1;		// Vsup to High Current Voltage (Vpp Controlled)
					VUINT32 VSVL:1;		// Vsup to Vxds (Low Voltage)
					VUINT32:8;			// UNUSED
					VUINT32 ITLK:1;		// Array Interlock
					VUINT32 VT:1;		// Vt Mode
					VUINT32 MANPLS:1;	// Manual Pulse Control
					VUINT32 MANVFY:1;	// Manual Verify Control
					VUINT32 AG:1;		// All Gates Shorted
					VUINT32 AD:1;		// all Drains Shorted
					VUINT32 NOVFY:1;	// No Verify Applied
					VUINT32 NOPLS:1;	// No Pulse Applied
					VUINT32 NOPG:1;		// No Program State Machine Control
					VUINT32 NOERS:1;	// No Erase State Machine Control
					VUINT32 NOCMP:1;	// No Compaction State Machine Control
					VUINT32 NOSPG:1;	// No Soft Program State Machine Control
					VUINT32 NOG:1;		// No Gate Voltage Array Control
					VUINT32 NOS:1;		// No Source Voltage Array Control
					VUINT32 NOD:1;		// No Drain Voltage Array Control
					VUINT32 NOPW:1;		// No Pwell Voltage Array Control
				} B;
			} TST0;

			union
			{
				// HiP7a FLASH EEPROM Test 1 Register
				// Register Base + 0x34
				VUINT32 R;
				struct
				{
					VUINT32 PLS:1;		// Pulse Indicator
					VUINT32 PIP:1;		// Program In Progress
					VUINT32 EIP:1;		// Erase In Progress
					VUINT32 CIP:1;		// Compaction In Progress
					VUINT32 SIP:1;		// Soft Program In Progress
					VUINT32:8;			// UNUSED
					VUINT32 FUPD:1;		// Fuse Update
					VUINT32 REP:1;		// Repair Bit
					VUINT32 RFO:1;		// Redundancy Fill Option
					VUINT32 IVB:1;		// Iout to Bandgap voltage reference
					VUINT32 SPR:1;		// Vsup to Positive Pump (HV) Reference
					VUINT32:4;			// UNUSED
					VUINT32 ETO:1;		// ECC Test Option
					VUINT32 DSE:1;    // DSE Disable Smart Erase	 (H7F specific)
					VUINT32:3;			// UNUSED
					VUINT32 ID:5;		// Identification Code
				} B;
			} TST1;

			union
			{
				// HiP7a FLASH EEPROM Test 2 Register
				// Register Base + 0x38
				VUINT32 R;
				struct
				{
					VUINT32 OPL:1;		// One Pulse
					VUINT32 OAD:1;		// One Address
					VUINT32 SEC:1;		// Save Erase Count
					VUINT32 EDC:1;		// ECC Detection and Correction
					VUINT32 EIO:1;		// ECC I/O Mode
					VUINT32 ED:1;		// ECC Disable Mode
					VUINT32 DMP:1;		// Array Dump
					VUINT32 SPD:1;		// Speed Read
					VUINT32 OBPE:1;		// Operation Break Point Enable
					VUINT32 NOBP:1;		// Next Operation Break Point
					VUINT32 PBPE:1;		// Pulse Break Point Enable
					VUINT32 NPBP:1;		// Next Pulse Break Point
					VUINT32 PEM:1;		// Parallel Erase Mode
					VUINT32 CIO:1;		// Clock Input/Output
					VUINT32 SCR:1;		// S Clock Read
					VUINT32 PCR:1;		// Pump Clock Read
					VUINT32 PATT:3;		// Pattern Designator
					VUINT32 VWLSEL:5;	// Vsup Voltage Select
					VUINT32 LRE:1;			// Local Reference Enable (H7F specific)
					VUINT32 BL2IO:1;	// Bit Line to Iout
					VUINT32 BLA:6;		// Bit Line Access
				} B;
			} TST2;

			union
			{
				// HiP7a FLASH EEPROM Data 0 Register
				// Register Base + 0x3C
				VUINT32 R;
				struct
				{
					VUINT32 DATA:32;	// Data
				} B;
			} DATA0;

			union
			{
				// HiP7a FLASH EEPROM Data 1 Register
				// Register Base + 0x40
				VUINT32 R;
				struct
				{
					VUINT32 DATA:32;	// Data
				} B;
			} DATA1;

			union
			{
				// HiP7a FLASH EEPROM Monitor 0 Register
				// Register Base + 0x44
				VUINT32 R;
				struct
				{
					VUINT32 SMECC:12;	// State Machine ECC Count
					VUINT32:1;			// UNUSED
					VUINT32 ECNT:19;	// Erase Count
				} B;
			} MON0;

			union
			{
				// HiP7a FLASH EEPROM Monitor 1 Register
				// Register Base + 0x48
				VUINT32 R;
				struct
				{
					VUINT32 ISM:5;		// Internal State Machine Monitor. Added 05-16-05
					VUINT32:2;			// UNUSED
					VUINT32 IPCNT:9;	// Interleaved Program Count
					VUINT32 BSM:4;		// BIST State Machine Monitor. Added 05-16-05
					VUINT32:3;			// UNUSED
					VUINT32 ICCNT:9;	// Interleaved Compaction Count
				} B;
			} MON1;

			union
			{
				// HiP7a FLASH EEPROM Monitor 2 Register
				// Register Base + 0x4C
				VUINT32 R;
				struct
				{
					VUINT32:3;			// UNUSED
					VUINT32 PCSCNT:29;	// Program/Compaction/Soft Program Count
				} B;
			} MON2;

			union
			{
				// HiP7a FLASH EEPROM Pulse Count Limit and Width Register (PWCL)
				// Register Base + 0x50
				VUINT32 R;
				struct 
				{
					VUINT32 PPW:2;
					VUINT32:4;
					VUINT32 PCPL:9;	 	// correct size (from 8 to 9) 05-16-05
					VUINT32 PCPLE:1;
					VUINT32 EPW:2;
					VUINT32 ESPL:13;
					VUINT32 ESPLE:1;
				} B;
			} PCLW;

			union
			{
				// HiP7a FLASH EEPROM BIST IO Address Register (BIOA)
				// Register Base + 0x54
				VUINT32 R;
				struct 
				{
					VUINT32 IOA:32;
				} B;
			} BIOA;

			union
			{
				// HiP7a FLASH EEPROM BIST IO Data Register (BIOD)
				// Register Base + 0x58
				VUINT32 R;
				struct 
				{
					VUINT32 IOD:32;
				} B;
			} BIOD;

			union
			{
				// HiP7a FLASH EEPROM Redundancy Fuse Latch 0 Register (FUSELAT0)
				// Register Base + 0x5C
				VUINT32 R;
				struct 
				{
					VUINT32:1;
					VUINT32 FUSE7_EN_B:1;
					VUINT32 FUSEDATA7:6;
					VUINT32:1;
					VUINT32 FUSE6_EN_B:1;
					VUINT32 FUSEDATA6:6;
					VUINT32:1;
					VUINT32 FUSE5_EN_B:1;
					VUINT32 FUSEDATA5:6;
					VUINT32:1;
					VUINT32 FUSE4_EN_B:1;
					VUINT32 FUSEDATA4:6;
				} B;
			} FUSELAT0;


			union
			{
				// HiP7a FLASH EEPROM Redundancy Fuse Latch 1 Register (FUSELAT1)
				// Register Base + 0x60
				VUINT32 R;
				struct 
				{
					VUINT32:1;
					VUINT32 FUSE3_EN_B:1;
					VUINT32 FUSEDATA3:6;
					VUINT32:1;
					VUINT32 FUSE2_EN_B:1;
					VUINT32 FUSEDATA2:6;
					VUINT32:1;
					VUINT32 FUSE1_EN_B:1;
					VUINT32 FUSEDATA1:6;
					VUINT32:1;
					VUINT32 FUSE0_EN_B:1;
					VUINT32 FUSEDATA0:6;
				} B;
			} FUSELAT1;
 
			union
			{
				// HiP7a FLASH EEPROM Fail Latch 0 Register (FAILLAT0)
				// Register Base + 0x64
				VUINT32 R;
				struct 
				{
					VUINT32:1;
					VUINT32 FUSEDATA7:7;
					VUINT32:1;
					VUINT32 FUSEDATA6:7;
					VUINT32:1;
					VUINT32 FUSEDATA5:7;
					VUINT32:1;
					VUINT32 FUSEDATA4:7;
				} B;
			} FAILLAT0;

			union
			{
				// HiP7a FLASH EEPROM Fail Latch 1 Register (FAILLAT1)
				// Register Base + 0x68
				VUINT32 R;
				struct 
				{
					VUINT32:1;
					VUINT32 FUSEDATA3:7;
					VUINT32:1;
					VUINT32 FUSEDATA2:7;
					VUINT32:1;
					VUINT32 FUSEDATA1:7;
					VUINT32:1;
					VUINT32 FUSEDATA0:7;
				} B;
			} FAILLAT1;

			union
			{
				// HiP7a FLASH EEPROM Option 0 Register (OPT0)
				// Register Base + 0x6C
				VUINT32 R;
				struct 
				{
					VUINT32 PWO:2;		// Program Width Option
					VUINT32 CSO:1;		// Compaction/Soft Program Width Option
					VUINT32:1;			// UNUSED
					VUINT32 SBO:1;		// Source Bias Resistance Option
					VUINT32 SPO:1;		// Source Bias Pulse Option
					VUINT32 PVO:2;		// Program Verify Voltage Option
					VUINT32 EVO:3;		// Erase Verify Voltage Option
					VUINT32 SVO:1;		// Soft Program Verify Option
					VUINT32 CVO:2;		// Compaction Verify Votlage Option
					VUINT32 RVO:2;		// Read Voltage Option
					VUINT32 SSO:2;		// High Current Voltage Option
					VUINT32 HVVO:2;		// High Voltage Voltage Option
					VUINT32:1;			// UNUSED
					VUINT32 BGO:3;		// Band Gap Option
					VUINT32 TCO:2;		// Temperature Coefficient Option
					VUINT32 NVO:6;		// Negative Votlage Option
				} B;
			} OPT0;

			union
			{
				// HiP7a FLASH EEPROM Option 0 Register (OPT1)
				// Register Base + 0x70
				VUINT32 R;
				struct 
				{
					VUINT32 STW:1;		// Salvage Option Enable
					VUINT32 GCR:3;    // Generic Configuration Registers (H7F specific)
					VUINT32:4;			  // UNUSED
					VUINT32 REFA:2;   // Reference A control option
					VUINT32 REFB:2;   // Reference B control option
					VUINT32 RAT:2;		// Read Address Timing
					VUINT32 WAT:2;		// Write Address Timing
					VUINT32 RTO:16;		// Read Timing Option
				} B;
			} OPT1;
			
			//CE BIST register - Register Base + 0x74
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CEB;
			
			//CE Address Register - Register Base + 0x78
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CADR;		
			
			//CE Start Count Register - Register Base + 0x7C
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CSCT;
			
			//CE End Count Register - Register Base + 0x80
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CECT;
			
			//CE MISR0 register - Register Base + 0x84
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CEM0;			
			
			//CE MISR1 Register - Register Base + 0x88
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CEM1;	
			
			//CE MISR2 Register - Register Base + 0x8C
			union
			{
			    VUINT32 R;
			    struct
			    {
			        VUINT32 BITS:32;
			    } B;
			} CEM2;												

			//VUINT32 UNUSED2[35];
			VUINT32 UNUSED2[28];   //updated after BIST registers added
		} sH7F, *psH7F;


	//  There are three way to create an instance of the CMF module:   
	//  -Use a fixed structure (Default)                               
	//  -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  
	//  -Use a pointer (if HEADER_POINTERS is defined)                 
	#ifdef DIAB_SECTIONS            //  Diab Compiler Only 
		#pragma section H7F  address=H7F_CTL_REG_BASE  //  Map modules to fixed addresses. 
		#pragma use_section H7F H7F
			EXT sH7F H7F;

	#else
		#ifdef HEADER_POINTERS

			//  Create a global pointer. 
			#ifdef Main_Program
				sH7F *H7F = (sH7F *)(INTERNAL_MEMORY_BASE + H7F_CTL_REG_BASE);
			#else
				EXT sH7F *H7F;
			#endif
		#else
			//  Use a fixed structure, this is the default 
			#define H7F  (*( sH7F *)(INTERNAL_MEMORY_BASE + H7F_CTL_REG_BASE))
		#endif                          //  HEADER_POINTERS 
	#endif                          //  DIAB_SECTIONS 

	#ifdef  __cplusplus
	}
	#endif
#endif	//	_M_H7F_H

