/*****************************************************************************/
/* Freescale reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Freescale does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Freescale */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale */
/* was negligent regarding the  design  or manufacture of the part. Freescale */
/* and the Freescale logo* are registered trademarks of Freescale Ltd.         */
/*****************************************************************************/
/*****************************************************************************/
/*                                            COPYRIGHT (c) MOTOROLA 2003	 */
/* FILE NAME: m_common.h													 */
/* VERSION:  1.0                                  All Rights Reserved		 */
/*																			 */
/* DESCRIPTION:																 */
/* Common Types definitions													 */
/*===========================================================================*/
/* AUTHOR: Vincent Vu														 */
/* COMPILER: Diab Data        VERSION: 4.4b									 */
/*                                                                           */
/* UPDATE HISTORY                                                            */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                     */
/* ---   -----------  ---------    ---------------------                     */
/* 1.0   V. Vu		  15/Apr/03    Initial version of file.                  */
/*****************************************************************************/

#ifndef _M_COMMON_H_
	#define	_M_COMMON_H_

	#define FALSE  0
	#define TRUE (!FALSE)

	// Pad Configuration MACROS
	#define	GPIO		0
	#define ALTERNATE   2
	#define PRIMARY     3
	//#define ALTERNATE	1
	//#define	PRIMARY		2
	
	// Pad Config - added for 5516 
    #define FIRST_FUNC  1
	#define SECOND_FUNC 2
	#define THIRD_FUNC  3

	// GPIO pin function
	#define	INPUT		0
	#define	OUTPUT		1
	#define NO_IO       2   //turn off both input and output buffers
	#define IN_OUT      3   //turn ON both input and output buffers

	// GPIO output state
	#define	LO			0
	#define	HI			1

	typedef unsigned char BOOL;

	typedef signed char INT8;
	typedef unsigned char UINT8;
	typedef volatile signed char VINT8;
	typedef volatile unsigned char VUINT8;

	typedef signed short INT16;
	typedef unsigned short UINT16;
	typedef volatile signed short VINT16;
	typedef volatile unsigned short VUINT16;

	typedef signed int INT32;
	typedef unsigned int UINT32;
	typedef volatile signed int VINT32;
	typedef volatile unsigned int VUINT32;

	typedef signed long long INT64;
	typedef unsigned long long UINT64;
	typedef volatile signed long long VINT64;
	typedef volatile unsigned long long VUINT64;
	
	typedef double FLOAT64;

	//	macro defintions for accessing addresses/registers
	#define WriteAddrLongLong(addr, value)  (*((VUINT64 *) (addr)) = (value))
	#define WriteAddrLong(addr, value)  	(*((VUINT32 *) (addr)) = (value))
	#define WriteAddrShort(addr, value)		(*((VUINT16 *) (addr)) = (value))
	#define WriteAddrByte(addr, value)		(*((VUINT8 *)  (addr)) = (value))
	#define ReadAddrLong(addr)  			(*((VUINT32 *) (addr)))
	#define ReadAddrLongLong(addr)			(*((VUINT64 *) (addr)))
	#define ReadAddrShort(addr)  			(*((VUINT16 *) (addr)))
	#define ReadAddrByte(addr)  			(*((VUINT8 *)  (addr)))
	#define OrAddrLong(addr, value)   		(*((VUINT32 *) (addr)) |= (value))
	#define OrAddrShort(addr, value)   		(*((VUINT16 *) (addr)) |= (value))
	#define AndAddrLong(addr, value)   		(*((VUINT32 *) (addr)) &= (value))
	#define AndAddrShort(addr, value)   	(*((VUINT16 *) (addr)) &= (value))
#endif	//	_M_COMMON_H_