 /****************************************************************************
 * FILE NAME: $RCSfile: knock_window_example.c,v $                           *
 *                                             COPYRIGHT (c) FREESCALE 2009 *
 * DESCRIPTION:                                        All Rights Reserved   *
 * This is a sample MPC5500 program to show a simple use of the eTPU         *
 * KNOCK_WINDOW function.                                                     *
 *===========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                   *
 * $Log: knock_window_example.c,v $
 * Revision 1.1  2009/02/05 10:33:13  r47354
 * first version
 *
 *...........................................................................*
 *****************************************************************************/

/* Freescale provided include files */
#include "mpc563m.h"    /* mpc5554 register definitions */
#include "etpu_util.h"   /* useful utility routines */
#include "fs_gpio.h"     /* GPIO API for the MPC5500 family */
#include "knock_window_etpu_gct_example.h"     /* eTPU engine initialization - generated by eTPU GCT */

/* User written include files */

#define ETPU_OUTPUT_PAD_CONFIG FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_MAXIMUM_SLEW_RATE + \
                               FS_GPIO_OUTPUT_DRAIN_DISABLE + \
                               FS_GPIO_READBACK_ENABLE + \
                               FS_GPIO_OUTPUT_BUFFER_ENABLE

#define ETPU_INPUT_PAD_CONFIG  FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_INPUT_BUFFER_ENABLE



int32_t init_error;    /*initialization error code. */
uint32_t my_knock_window_angle_table[16];

main()
{
  int32_t error_code;
  vuint16_t *upper_SCR16_cam; /* Pointers used to reference interrupt bits */
  vuint32_t *upper_SCR32_cam;
  vuint16_t *upper_SCR16_crank;
  vuint32_t *upper_SCR32_crank;


  my_knock_window_angle_table[0] = 3000;
  my_knock_window_angle_table[1] = 1500; 
  my_knock_window_angle_table[2] = 9000;
  my_knock_window_angle_table[3] = 3000;
  my_knock_window_angle_table[4] = 15000;
  my_knock_window_angle_table[5] = 3000;
  my_knock_window_angle_table[6] = 21000;
  my_knock_window_angle_table[7] = 3000;
  my_knock_window_angle_table[8] = 27000;
  my_knock_window_angle_table[9] = 3000;
  my_knock_window_angle_table[10] = 33000;
  my_knock_window_angle_table[11] = 3000;
  my_knock_window_angle_table[12] = 39000;
  my_knock_window_angle_table[13] = 3000;
  my_knock_window_angle_table[14] = 44000;
  my_knock_window_angle_table[15] = 3000;
  
  FMPLL.SYNCR.R = 0x03000000; /*  8MHz*10=80MHz*/

  /* configure the eTPU channel pads */

  fs_gpio_config( FS_GPIO_ETPUA0, ETPU_INPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA14, ETPU_INPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA1, ETPU_OUTPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA15, ETPU_OUTPUT_PAD_CONFIG);
  fs_gpio_config( FS_GPIO_ETPUA10, ETPU_OUTPUT_PAD_CONFIG);



  upper_SCR32_crank = &ETPU.CHAN[APP_ENG_POS0_CRANK].SCR.R;
  upper_SCR16_crank = (vuint16_t *) upper_SCR32_crank;
  *upper_SCR16_crank = 0xC0C0;        /* clear DMA/interrupt service request */
  upper_SCR32_cam = &ETPU.CHAN[APP_ENG_POS0_CAM].SCR.R;
  upper_SCR16_cam = (vuint16_t *) upper_SCR32_cam;
  *upper_SCR16_cam = 0xC0C0;        /* clear DMA/interrupt service request */
  upper_SCR32_cam = &ETPU.CHAN[KNOCK_WINDOW0_KNOCK_WINDOW].SCR.R;
  upper_SCR16_cam = (vuint16_t *) upper_SCR32_cam;
  *upper_SCR16_cam = 0xC0C0;        /* clear DMA/interrupt service request */  


  error_code = my_system_etpu_init ();

  my_system_etpu_start();


  for (;;)
  {

  /* update calls may be added here */

  } /*Foo.*/
}