 /****************************************************************************
 * FILE NAME: $RCSfile: fuel_example.c,v $      COPYRIGHT (c) FREESCALE 2009 *
 * DESCRIPTION:                                        All Rights Reserved   *
 * This is a sample MPC5500 program to show a simple use of the FUEL function*
 *===========================================================================*
 * ORIGINAL AUTHOR: Michal Princ(prnm001)                                    *
 * $Log: fuel_example.c,v $
 * Revision 1.1  2009/01/15 12:41:08  prnm001
 * Initial revision
 *
 *
 *...........................................................................*
 *****************************************************************************/

/* Freescale provided include files */
#include "mpc563m.h"    /* mpc5554 register definitions */
#include "etpu_util.h"   /* useful utility routines */
#include "fs_gpio.h"     /* GPIO API for the MPC5500 family */
#include "etpu_fuel.h"   /* eTPU FUEL API */
#include "fuel_etpu_gct_example.h"     /* eTPU engine initialization - generated by eTPU GCT */

/* User written include files */
#include "fuel_example.h"  /* include application specific defines. */

#define ETPU_OUTPUT_PAD_CONFIG FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_MAXIMUM_SLEW_RATE + \
                               FS_GPIO_OUTPUT_DRAIN_DISABLE + \
                               FS_GPIO_READBACK_ENABLE + \
                               FS_GPIO_OUTPUT_BUFFER_ENABLE
                               
#define ETPU_INPUT_PAD_CONFIG  FS_GPIO_PRIMARY_FUNCTION + \
                               FS_GPIO_INPUT_BUFFER_ENABLE                               

extern	IVO4Handler();
extern	uint32_t	__IV_ADDR; /* Interrupt Vector Prefix value from link file */
extern	const	vuint32_t	IntcIsrVectorTable[];

void initIrqVectors(void)
{
	asm ("lis r5, __IV_ADDR@h");   /* IVPR = address base used with IVOR's */
	asm ("mtIVPR r5 ");
	asm ("lis r5, IVOR4Handler@h"); /* IVOR4 = address of handler */ 							
	asm ("ori r5, r5, IVOR4Handler@l");	
	asm ("mtIVOR4 r5");
}

void initINTC(void) 
{
	/* Use the first 3 or next 3 lines: */
	/* Use the first 3 or next 3 lines for MPC551x or MPC555x: */
	/* INTC.MCR.B.HVEN_PRC0 = 0;*/ /* MPC551x Proc'r 0: initialize for SW vector mode */
	/* INTC.MCR.B.VTES_PRC0 = 0;*/ /* MPC551x Proc'r 0: default vector table 4B offsets*/
	/* ITC.IACKR_PRC0.R= (uint32_t) &IntcIsrVectorTable[0];*//*MPC551x ISR table base*/
	INTC.MCR.B.HVEN = 0; /* MPC555x: initialize for SW vector mode */
	INTC.MCR.B.VTES = 0; /* MPC555x: Use default vector table 4B offsets */
	INTC.IACKR.R = (uint32_t) &IntcIsrVectorTable[0]; /* MPC555x INTC ISR table base */
	INTC.CPR.R = 0;	

	
	INTC.PSR[73].R = 2;	/* etpu ch5 interrupt priority */
}

void enableIrq(void) 
{
	/* Use one of the following two lines to lower the INTC current priority */
	/*INTC.CPR_PRC0.B.PRI = 0; */ /* MPC551x Proc'r 0: Lower INTC's current priority */
	INTC.CPR.B.PRI = 0; /* MPC555x: Lower INTC's current priority */
	asm(" wrteei 1"); /* Enable external interrupts */
}

int32_t init_error;    /*initialization error code. */

vuint32_t j;
vuint32_t cnt = 0;

void	etpu_ch05_isr(void)
{
	cnt++;

	/* clear CISR flag */
	ETPU.CISR_A.B.CIS5 = 1;	
}


main()
{
	int32_t error_code;
	vuint16_t *upper_SCR16_cam; /* Pointers used to reference interrupt bits */
	vuint32_t *upper_SCR32_cam;	
	vuint16_t *upper_SCR16_crank; 
	vuint32_t *upper_SCR32_crank;	
      
	FMPLL.SYNCR.R = 0x03000000; /*  8MHz*10=80MHz*/

	/* configure interrupts */
	initIrqVectors(); /* Initialize exceptions: only need to load IVPR */
	initINTC(); /* Initialize INTC for software vector mode */

	/* configure the eTPU channel pads */
	fs_gpio_config( FS_GPIO_ETPUA0, ETPU_INPUT_PAD_CONFIG); 
	fs_gpio_config( FS_GPIO_ETPUA14, ETPU_INPUT_PAD_CONFIG);   
	fs_gpio_config( FS_GPIO_ETPUA1, ETPU_OUTPUT_PAD_CONFIG);   
	fs_gpio_config( FS_GPIO_ETPUA15, ETPU_OUTPUT_PAD_CONFIG);   

	fs_gpio_config( FS_GPIO_ETPUA5, ETPU_OUTPUT_PAD_CONFIG);   
	fs_gpio_config( FS_GPIO_ETPUA6, ETPU_OUTPUT_PAD_CONFIG);   
	fs_gpio_config( FS_GPIO_ETPUA7, ETPU_OUTPUT_PAD_CONFIG);   
	fs_gpio_config( FS_GPIO_ETPUA8, ETPU_OUTPUT_PAD_CONFIG);   
                         
	upper_SCR32_crank = &ETPU.CHAN[APP_ENG_POS0_CRANK].SCR.R;
	upper_SCR16_crank = (vuint16_t *) upper_SCR32_crank;
	*upper_SCR16_crank = 0xC0C0;        /* clear DMA/interrupt service request */
	upper_SCR32_cam = &ETPU.CHAN[APP_ENG_POS0_CAM].SCR.R;
	upper_SCR16_cam = (vuint16_t *) upper_SCR32_cam;
	*upper_SCR16_cam = 0xC0C0;        /* clear DMA/interrupt service request */



	error_code = my_system_etpu_init ();

	my_system_etpu_start();  

	enableIrq();

                                
	for (;;)
	{
    		/* update calls may be added here */
	} /*Foo.*/
}

