/************************************************************************
 *    This file was generated by eTPU Graphical Configuration Tool        
 *                                                                        
 *    DO NOT EDIT !!! DO NOT EDIT !!! DO NOT EDIT !!! DO NOT EDIT !!!     
 *                                                                        
 *  DESCRIPTION:
 *  This file contains my_system_etpu_init and my_system_etpu_start
 *  functions and related items. The function initialize the eTPU 
 *  global and channel settings, based on the user settings 
 *  in the eTPU GCT, and runs the eTPU.               
 *  A header file of the same name .h is also generated.                   
 *
 *  Creation Date:  13/01/2009 16:29:55 
 *
 **************************************************************************/

/* general routines */
#include "etpu_util.h"             /* Utility routines for working eTPU */
#include "mpc563m_vars.h"          /* Processor dependent variables */

/* eTPU function set used */
#include "etpu_set2/etpu_set2.h"       

/* eTPU functions APIs */
#include "eng_pos/etpu_app_eng_pos.h" /* Engine Position (CAM and CRANK channels): main header file */
#include "tooth_gen/etpu_toothgen.h" /* ToothGen - Tooth Generator */

/* our private header file (generated by eTPU GCT) */
#include "eng_pos_etpu_gct_example.h"



/* External object declarations */
/* ... no external variables used */


/**************************************************************************
 * 
 * Global Variables
 *
 **************************************************************************/

uint32_t *fs_free_param;

/**************************************************************************
 *
 * CPU and clock configuration:
 *
 *   CPU = MPC563M
 *   SYSCLK = 80 MHz
 *   Input_TCRCLK_A = OFF
 *   Input_TCRCLK_B = OFF
 *   
 **************************************************************************/

uint32_t etpu_a_tcr1_freq = 8000000;
uint32_t etpu_a_tcr2_freq = 0;
uint32_t etpu_b_tcr1_freq = 0;
uint32_t etpu_b_tcr2_freq = 10000000;


/**************************************************************************
 * 
 * etpu_config structure filled accodring to the user settings
 *
 **************************************************************************/

struct etpu_config_t my_etpu_config =
{
  /* etpu_config.mcr */
  FS_ETPU_VIS_OFF	/* SCM not visible (VIS=0) */
  | FS_ETPU_MISC_DISABLE	/* SCM operation disabled (SCMMISEN=0) */,

  /* etpu_config.misc */
  FS_ETPU_MISC,

  /* etpu_config.ecr_a */
  FS_ETPU_ENTRY_TABLE_ADDR	/* entry table base address = shifted FS_ETPU_ENTRY_TABLE */
  | FS_ETPU_CHAN_FILTER_2SAMPLE	/* channel filter mode = two-sample mode (CDFC=0) */
  | FS_ETPU_ENGINE_ENABLE	/* engine is enabled (MDIS=0) */
  | FS_ETPU_FILTER_CLOCK_DIV2	/* channel filter clock = etpuclk div 2 (FPSCK=0) */,

  /* etpu_config.tbcr_a */
  FS_ETPU_ANGLE_MODE_ENABLE	/* TCR2 works in angle mode (AM=1) */
  | FS_ETPU_TCR2_PRESCALER(1)	/* TCR2 prescaler = 1 (TCR2P='1-1') */
  | FS_ETPU_TCR1_PRESCALER(5)	/* TCR1 prescaler = 5 (TCR1P='5-1') */
  | FS_ETPU_TCRCLK_MODE_INTEGRATION	/* TCRCLK signal is filtered using integration mode (TCRCF=1x) */
  | FS_ETPU_TCR2CTL_FALL	/* TCR2 source = fall TCRCLK transition (TCR2CTL=2) */
  | FS_ETPU_TCRCLK_INPUT_CHANCLOCK	/* TCRCLK signal is filtered with filter clock = channel filter clock (TCRCF=x1) */
  | FS_ETPU_TCR1CTL_DIV2	/* TCR1 source = etpuclk div 2 (TCR1CTL=2) */,

  /* etpu_config.stacr_a */
  FS_ETPU_TCR1_STAC_SERVER	/* TCR1 resource operates as server (RSC1=1) */
  | FS_ETPU_TCR2_STAC_SERVER	/* TCR2 resource operates as server (RSC2=1) */
  | FS_ETPU_TCR1_STAC_DISABLE	/* TCR1 operation on STAC bus disabled (REN1=0) */
  | FS_ETPU_TCR2_STAC_DISABLE	/* TCR2 operation on STAC bus disabled (REN2=0) */
  | FS_ETPU_TCR1_STAC_SRVSLOT(0)	/* TCR1 resource server slot = 0 (SRV1=0) */
  | FS_ETPU_TCR2_STAC_SRVSLOT(0)	/* TCR2 resource server slot = 0 (SRV2=0) */,

  /* etpu_config.ecr_b */
  0,

  /* etpu_config.tbcr_b */
  0,

  /* etpu_config.stacr_b */
  0
};

/**************************************************************************
 * 
 *  FUNCTION : my_system_etpu_init
 * 
 *  PURPOSE  : Initializes the eTPU settings and channel settings, based
 *             on the user settings in the eTPU GCT:
 *
 *             1. Initialize global setting using fs_etpu_init function
 *                and the my_etpu_config structure.
 *             2. Initialize channel setting using channel function APIs 
 *                or standard eTPU routines.
 *
 *  RETURNS  : If the initialization of all channel functions passed OK, 
 *             the return value is 0. If the initialization of a channel 
 *             failed, the returned value is a number of the channel that
 *             failed to initialized increased by 1.
 *
 **************************************************************************/

int32_t my_system_etpu_init()
{
  int32_t err_code;

  /*
   *  Initialization of eTPU global settings
   */

  fs_etpu_init( my_etpu_config, (uint32_t *)etpu_code, sizeof(etpu_code),
                (uint32_t *)etpu_globals, sizeof(etpu_globals));

  /*
   *  Initialization of eTPU channel settings
   */

  /* 
   *  eTPU API Function initialization: 'Engine Position (CAM and CRANK channels)'
   */
  err_code = fs_etpu_app_eng_pos_init (APP_ENG_POS0_CAM,	/* engine: A; channel: 14 */
                                       FS_ETPU_CAM_PRIORITY_MIDDLE,	/* cam_priority: Middle */
                                       FS_ETPU_CAM_FM0_FALLING_EDGE,	/* cam_edge_polarity: FS_ETPU_CAM_FM0_FALLING_EDGE */
                                       0,	/* cam_angle_window_start: 0 */
                                       71999,	/* cam_angle_window_width: 71999 */
                                       APP_ENG_POS0_CRANK,	/* engine: A; channel: 0 */
                                       FS_ETPU_CRANK_PRIORITY_MIDDLE,	/* crank_priority: Middle */
                                       FS_ETPU_CRANK_FM0_FALLING_EDGE,	/* crank_edge_polarity: FS_ETPU_CRANK_FM0_FALLING_EDGE */
                                       35,	/* crank_number_of_physical_teeth: 35 */
                                       1,	/* crank_number_of_missing_teeth: 1 */
                                       10,	/* crank_blank_tooth_count: 10 */
                                       100,	/* crank_tcr2_ticks_per_tooth: 100 */
                                       0x199999,	/* crank_windowing_ratio_normal: 0x199999 */
                                       0x199999,	/* crank_windowing_ratio_after_gap: 0x199999 */
                                       0x199999,	/* crank_windowing_ratio_across_gap: 0x199999 */
                                       0x299999,	/* crank_windowing_ratio_timeout: 0x299999 */
                                       0x9fffff,	/* crank_gap_ratio: 0x9fffff */
                                       5,	/* crank_blank_time_ms: 5 */
                                       40000,	/* crank_first_tooth_timeout_us: 40000 */
                                       0x0E070707,	/* crank_link_1: 0x0E070707 */
                                       0x07070707,	/* crank_link_2: 0x07070707 */
                                       0x07070707,	/* crank_link_3: 0x07070707 */
                                       0x07070707,	/* crank_link_4: 0x07070707 */
                                       etpu_a_tcr1_freq);	/* tcr1_timebase_freq: 8000000 */
  if (err_code != 0)
  	return ((APP_ENG_POS0_CAM) + 1);
  
  /* 
   *  eTPU API Function initialization: 'ToothGen - Tooth Generator'
   */
  err_code = fs_etpu_toothgen_init (TOOTHGEN0_CRANK,	/* engine: A; channel: 1 */
                                    TOOTHGEN0_CAM,	/* engine: A; channel: 15 */
                                    FS_ETPU_PRIORITY_MIDDLE,	/* priority: Middle */
                                    35,	/* crank_number_of_physical_teeth: 35 */
                                    1,	/* crank_number_of_missing_teeth: 1 */
                                    0x7FFFFF,	/* tooth_duty_cycle: 0x7FFFFF */
                                    1,	/* tooth_number: 1 */
                                    4000,	/* engine_speed_rpm: 4000 */
                                    etpu_a_tcr1_freq,	/* tcr1_timebase_freq: 8000000 */
                                    3,	/* cam_start: 3 */
                                    5);	/* cam_stop: 5 */
  if (err_code != 0)
  	return ((TOOTHGEN0_CRANK) + 1);
  
  

  return(0);
}

/**************************************************************************
 *
 *  FUNCTION : my_system_etpu_start
 *
 *  PURPOSE  : Initializes the eTPU settings and channel settings, based
 *             on the user settings in the eTPU GCT:
 *
 *             1. Initialize
 *                - Interrupt Enable
 *                - DMA Enable
 *                - Output Disable
 *                options of each channel.
 *             2. Run eTPU using Global Timebase Enable (GTBE) bit.
 *
 **************************************************************************/

void my_system_etpu_start()
{
  /*
   *  Initialization of Interrupt Enable, DMA Enable
   *  and Output Disable channel options
   */

  uint8_t i;
  uint32_t odis_a;
  uint32_t opol_a;

  eTPU->CIER_A.R = ETPU_CIE_A;

  eTPU->CDTRER_A.R = ETPU_DTRE_A;

  odis_a = ETPU_ODIS_A;
  opol_a = ETPU_OPOL_A;
  for(i=0; i<32; i++) {
    eTPU->CHAN[i].CR.B.ODIS = odis_a & 0x00000001;
    eTPU->CHAN[i].CR.B.OPOL = opol_a & 0x00000001;
    odis_a >>= 1;
    opol_a >>= 1;
  }

  /*
   *  Synchronous start of all TCR time bases
   */

  fs_timer_start();
}

/**************************************************************************
 *
 * Private GCT-generated data may follow this comment
 *
 **************************************************************************/

/* app_eng_pos load expression inputs:
  engine_speed=8000;
*/

