/**************************************************************************/
/* FILE NAME: mpc5500_xcptn.h               COPYRIGHT (c) Freescale 2004  */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This file contains prototypes and definitions for the MPC5500          */
/*     exception and interrupt functions.                                 */
/*     Additions to this file should be made only if additional defines   */
/*     are needed.                                                        */
/*     New definitions will need to be unique for this file and for the   */
/*     assembly equates in mpc5500_defs.inc.                              */
/*========================================================================*/
/*                                                                        */
/* REV      AUTHOR        DATE       DESCRIPTION OF CHANGE                */
/* ---   -----------   -----------   ---------------------                */
/* 0.1   G. Jackson     30/Jul/04    Initial version.                     */
/* 0.2   C. Baker       19/Jul/06    Fixed typos                          */
/**************************************************************************/


#ifdef  __cplusplus
extern "C" {
#endif


/*************************************************************/
/*************************************************************/
/* The user should not modify any of the definitions below   */

/**************************************************************************/
/*                       Function Prototypes                              */
/**************************************************************************/

/**************************************************************************/
/*                Exception and Interrupt Prototypes                      */
/**************************************************************************/
/* Initialize the IVPR register */
void initIrqVectors(void);

/* Set up the INTC and vector table base address */
void initINTC(void);

/* Initialize the eMIOS block for interrupts */
void initEMIOS(void);

/* Interrupt Service Routine for Channel 4   */
void initSwIrq4(void);

/* Interrupt Service Routine for Channel 0   */
void emiosCh0ISR(void);

/* Interrupt Initialization for Channel 4   */
void SwIrq4ISR(void);

/* Set INTC current priority to 0 and enable */
void enableIrq(void);

/* Overall function to setup and run the interrupts */
void xcptn_xmpl(void);

#ifdef  __cplusplus
}
#endif

