Imports System.Runtime.InteropServices

Structure USB_INTERFACE_DESCRIPTOR
    Dim bLength As Byte
    Dim bDescriptorType As Byte
    Dim bInterfaceNumber As Byte
    Dim bAlternateSetting As Byte
    Dim bNumEndpoints As Byte
    Dim bInterfaceClass As Byte
    Dim bInterfaceSubClass As Byte
    Dim bInterfaceProtocol As Byte
    Dim iInterface As Byte
End Structure

Structure WINUSB_SETUP_PACKET
    Dim RequestType As Byte
    Dim Request As Byte
    Dim Value As UShort
    Dim Index As UShort
    Dim Length As UShort
End Structure

Enum USBD_PIPE_TYPE
    UsbdPipeTypeControl
    UsbdPipeTypeIsochronous
    UsbdPipeTypeBulk
    UsbdPipeTypeInterrupt
End Enum

Public Enum DESCRIPTOR_TYPE
    DEVICE_DESCRIPTOR = 1
    CONFIGURATION_DESCRIPTOR = 2
    STRING_DESCRIPTOR = 3
    INTERFACE_DESCRIPTOR = 4
    ENDPOINT_DESCRIPTOR = 5
End Enum

Structure WINUSB_PIPE_INFORMATION
    Dim PipeType As USBD_PIPE_TYPE
    Dim PipeId As Byte
    Dim MaximumPacketSize As UShort
    Dim Interval As Byte
End Structure

Structure GUID_APP
    Dim DataA As Integer
    Dim DataB As UShort
    Dim DataC As UShort
    Dim Data0 As Byte
    Dim Data1 As Byte
    Dim Data2 As Byte
    Dim Data3 As Byte
    Dim Data4 As Byte
    Dim Data5 As Byte
    Dim Data6 As Byte
    Dim Data7 As Byte
End Structure

Module USB_API

    Public Const PIPE_TRANSFER_TIMEOUT As Integer = &H3

    ' initialize all: register, GUID, etc
    Declare Function usb_open_device Lib "C:\Windows\System32\drivers\FSLwinusb" _
         (ByRef my_guid As GUID_APP) _
         As Boolean

    ' The usb_Free function frees all of the resources that 
    '  WinUsb_Initialize allocated 
    Declare Function usb_Free Lib "C:\Windows\System32\drivers\FSLwinusb" _
         () _
         As Boolean

    ' Returns a requested descriptor
    Declare Function usb_GetDescriptor Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal DescriptorType As Byte, _
         ByVal Index As Byte, _
         ByVal LanguageID As Integer, _
         <[In](), Out()> ByVal Buffer() As Byte, _
         ByVal BufferLength As Integer, _
         ByRef LengthTransferred As Integer) _
        As Boolean

    ' Returns the interface descriptor for the specified 
    '  alternate interface settings for a particular interface handle
    Declare Function usb_QueryInterfaceSettings Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal AlternateInterfaceNumber As Byte, _
         ByRef UsbAltInterfaceDescriptor As USB_INTERFACE_DESCRIPTOR) _
        As Boolean

    ' returns information about the physical device that is associated
    '  with a WinUSB interface
    Declare Function usb_QueryDeviceInformation Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal InformationType As Byte, _
         ByRef BufferLength As ULong, _
         <[In](), Out()> ByVal Buffer() As Byte) _
        As Boolean

    ' sets the alternate setting of an interface
    Declare Function usb_SetCurrentAlternateSetting Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal SettingNumber As Byte) _
        As Boolean

    ' gets the alternate setting of an interface
    Declare Function usb_GetCurrentAlternateSetting Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByRef SettingNumber As Byte) _
        As Boolean

    ' returns information about a pipe that is 
    ' associated with an interface
    Declare Function usb_QueryPipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal AlternateInterfaceNumber As Byte, _
         ByVal PipeIndex As Byte, _
         ByRef PipeInformation As WINUSB_PIPE_INFORMATION) _
        As Boolean

    ' sets the policy for a specific pipe (endpoint) 
    '  note this data type varies depending policy (Value)
    Declare Function usb_SetPipePolicy Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte, _
         ByVal PolicyType As UInteger, _
         ByVal ValueLength As UInteger, _
         ByRef Value As Object) _
        As Boolean

    ' retrieves the policy for a specific pipe (endpoint) 
    '  note this data type varies depending policy (Value)
    Declare Function usb_GetPipePolicy Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte, _
         ByVal PolicyType As UInteger, _
         ByRef ValueLength As UInteger, _
         ByRef Value As Object) _
        As Boolean

    ' reads data from a pipe
    Declare Function usb_ReadPipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte, _
         <[In](), Out()> ByVal Buffer() As Byte, _
         ByVal BufferLength As Integer, _
         ByRef LengthTransferred As Integer) _
        As Boolean

    ' writes data to a pipe
    Declare Function usb_WritePipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte, _
         <[In](), Out()> ByVal Buffer() As Byte, _
         ByVal BufferLength As Integer, _
         ByRef LengthTransferred As Integer) _
        As Boolean

    ' transmits control data over a default control endpoint
    '<[In](), Out()> ByVal SetupPacket() As Integer, _
    Declare Function usb_ControlTransfer Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByRef SetupPacket As WINUSB_SETUP_PACKET, _
         <[In](), Out()> ByVal Buffer() As Byte, _
         ByVal BufferLength As Integer, _
         ByRef LengthTransferred As Integer) _
        As Boolean

    ' resets the data toggle and clears the stall condition on a pipe
    Declare Function usb_ResetPipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte) _
        As Boolean

    ' aborts all of the pending transfers for a pipe
    Declare Function usb_AbortPipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte) _
        As Boolean

    ' discards any data that is cached in a pipe
    Declare Function usb_FlushPipe Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PipeID As Byte) _
        As Boolean

    ' " WinUsb_SetInterfacePowerPolicy "
    '  routine sets the power policy for a device
    '  note name is different from msdn2.microsoft.com
    '  note Value depends on policy, but Byte should work
    Declare Function usb_SetPowerPolicy Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PolicyType As Integer, _
         ByVal ValueLength As Integer, _
         ByRef Value As Byte) _
        As Boolean

    ' " WinUsb_GetInterfacePowerPolicy "
    '  retrieves the power policy for a device
    '  note name is different from msdn2.microsoft.com
    '  note Value depends on policy, but Byte should work
    Declare Function usb_GetPowerPolicy Lib "C:\Windows\System32\drivers\FSLwinusb" _
        (ByVal PolicyType As Integer, _
         ByRef ValueLength As Integer, _
         ByRef Value As Byte) _
        As Boolean

End Module
