/****************************************************************************
 *
 *            Copyright (c) 2006-2007 by CMX Systems, Inc.
 *
 * This software is copyrighted by and is the sole property of
 * CMX.  All rights, title, ownership, or other interests
 * in the software remain the property of CMX.  This
 * software may only be used in accordance with the corresponding
 * license agreement.  Any unauthorized use, duplication, transmission,
 * distribution, or disclosure of this software is expressly forbidden.
 *
 * This Copyright notice may not be removed or modified without prior
 * written consent of CMX.
 *
 * CMX reserves the right to modify this software without notice.
 *
 * CMX Systems, Inc.
 * 12276 San Jose Blvd. #511
 * Jacksonville, FL 32223
 * USA
 *
 * Tel:  (904) 880-1840
 * Fax:  (904) 880-1632
 * http: www.cmx.com
 * email: cmx@cmx.com
 *
 ***************************************************************************/

/*************************** USB Descriptor ********************************/

#include "usb.h"

#define USB_VENDOR_ID   0x1983u
#define USB_PRODUCT_ID  (0x0101)
#define USB_DEVICE_REL_NUM  0x1


hcc_u8 string_descriptor0[4] = {4, 0x3, 0x09, 0x04 };
hcc_u8 str_manufacturer[28] = { 28, 0x3, 
				  'F',0, 
				  'S',0, 
				  'L',0, 
				  ' ',0, 
				  'C',0, 
				  'o',0, 
				  'l',0, 
				  'd',0, 
				  'F',0, 
				  'i',0, 
				  'r',0, 
				  'e',0, 
				  ' ',0
				  };
				  
hcc_u8 * const usb_string_descriptors[USB_NO_OF_STRING_DESC] = {
  string_descriptor0, str_manufacturer
};

#define CUSTOMIZED_CLASS	0

hcc_u8 usb_device_descriptor[] = {
  USB_FILL_DEV_DESC(0x0110, CUSTOMIZED_CLASS, 0, 0, EP0_PACKET_SIZE, USB_VENDOR_ID, USB_PRODUCT_ID
      , USB_DEVICE_REL_NUM, 1, 0, 0, 1)
};

#define NUMBER_OF_INTERFACES	0x01

hcc_u8 usb_config_descriptor[] = {
  /* configuration */
  USB_FILL_CFG_DESC(9+9+7+7, NUMBER_OF_INTERFACES, 1, 0, CFGD_ATTR_BUS_PWR, 0),
  /* interface */
  USB_FILL_IFC_DESC(0, 0, 2 /* number of endpoints */, 0, 0, 0, 0), /* Comm interface/ abstract contorl model/ 00 no class protocol*/
  /* 
   * Endpoints:
   * directions: from device to host
   * Example: 
   * EPD_DIR_TX: IN transaction
   * EPD_DIR_RX: OUT transaction
   */
  USB_FILL_EP_DESC(0x1, EPD_DIR_TX, EPD_ATTR_INT, EP1_PACKET_SIZE, 0x5 /* 16ms */),
  USB_FILL_EP_DESC(0x2, EPD_DIR_RX, EPD_ATTR_BULK, EP2_PACKET_SIZE, 0x0)
};

void *get_device_descriptor(void)
{
  return(usb_device_descriptor);
}

hcc_u8 is_cfgd_index(hcc_u16 cndx)
{
  return((hcc_u8)(cndx == 1 ? 1 : 0));
}

void *get_cfg_descriptor(hcc_u8 cndx)
{
  return(cndx ? usb_config_descriptor : usb_config_descriptor);
}

hcc_u8 is_str_index(hcc_u8 sndx)
{
  return((hcc_u8)(sndx < (sizeof(usb_string_descriptors)/sizeof(usb_string_descriptors[0]) ? 1 : 0)));
}

void *get_str_descriptor(hcc_u8 sndx)
{
  return(usb_string_descriptors[sndx]);
}


hcc_u8 is_ifc_ndx(hcc_u8 c, hcc_u8 i, hcc_u8 is)
{
  if (c==1 &&  is == 0)
  {
    if (i==0)
    {
      return(1);
    }
  }
  return(0);
}

hcc_u8 is_ep_ndx(hcc_u8 c, hcc_u8 i, hcc_u8 is, hcc_u8 ep)
{
  if (c==1 && is==0)
  {
    if (i==0 && ep < 2)
    {
      return(1);
    }
  }
  return(0);
}

void * get_ep_descriptor(hcc_u8 c, hcc_u8 i, hcc_u8 is, hcc_u8 ep)
{
  if(i == 0)
  {
	  if (ep == 0)
	  {
	    return(&usb_config_descriptor[9+9]);
	  }
	  if (ep == 1)
	  {
	    return(&usb_config_descriptor[9+9+7]);
	  }
  }
  return((void *)(c + is ? 0 : 0));
}

/* control endpoint #0 */
hcc_u8 buf_ep00[EP0_PACKET_SIZE];
hcc_u8 buf_ep01[EP0_PACKET_SIZE];

/* IN endpoints' buffers */

/* bulk endpoint #1 */
hcc_u8 buf_ep20[EP2_PACKET_SIZE];
hcc_u8 buf_ep21[EP2_PACKET_SIZE];

void *get_ep_rx_buffer(hcc_u8 ep, hcc_u8 buf)
{
  switch(ep)
  {
  case 0:
    if (!buf)
    {
      return(buf_ep00);
    }
    else
    {
      return(buf_ep01);    
    }
    break;
  case 2:
    if (!buf)
    {
      return(buf_ep20);
    }
    else
    {
      return(buf_ep21);    
    }
    break;   
  }
  return(0);
}
/****************************** END OF FILE **********************************/