/*
 * File:        dma-uart.h
 * Purpose:     driver
 *
 * Notes:
 */

#ifndef __UART_DMA_H__
#define __UART_DMA_H__

/********************************************************************/

/* Driver-specific defines */
#define			SYS_CLOCK			80			/* system clock in MHz */
#define			SERIAL_BAUD		115200 			/* UART baudrate in RX/TX */

#define			UARTCHANNEL			1
#define			DMATRANSMIT			0

/* Source Start Address SRAM */
#define sourceSA(x)  (hcc_u32)(&MCF_UART_UTB(x))
/* UART access control address */
#define MCF_SCM_PACR_UART      		 (*(hcc_reg16 *)(void*)(&_IPSBAR[0x000026]))

#define MCF_SCM_DMAREQC        		 (*(hcc_reg32*)(&_IPSBAR[0x000014])) // new...

/* x = DMA Channel; y = UART port */
#define MCF_SCM_DMAREQC_DMAC_RX(x,y)        (((y+8)&0x0000000F)<<((x)*4))
#define MCF_SCM_DMAREQC_DMAC_TX(x,y)  		(((y+12)&0x0000000F)<<((x)*4))
/* y = UART port */
#define MCF_SCM_PACR_UART_USERMODE(y) (0x4<<(12-(y*4)))

/* Specific Data types */

typedef struct
{
	hcc_u8 dmaChannel;
	hcc_u32 source;
	hcc_u32 destination;
	hcc_u32 byteCount;
} dma_state_t;

/****************************Prototypes*********************************/

void DMAIRQinit();
void UARTDMAinit(hcc_u8 port);
void UARTprint(char *text, hcc_u8 size, hcc_u8 port);
void DMAstart(dma_state_t *dma_state);
void DMARXinit(hcc_u8 dmaChannel);
void DMATXinit(hcc_u8 dmaChannel);
void DMATXstart();
__declspec(interrupt:0x2000) void DMA0ISR();
__declspec(interrupt:0x2000) void DMA1ISR();
__declspec(interrupt:0x2000) void DMA2ISR();
__declspec(interrupt:0x2000) void DMA3ISR();

/********************************************************************/

#endif /* __UART_DMA_H__ */