/*****************************Macros********************************/
#define QSPI_TRANSMIT_ADDRESS 0x00          /*QSPI RAM transmit addres*/
#define QSPI_RECEIVE_ADDRESS  0x10          /*QSPI RAM receive address*/
#define QSPI_COMMAND_ADDRESS  0x20          /*QSPI RAM command address*/
#define BUS_CLOCK				40			/* system clock (MHz) */
#define QSPI_VECTOR             18          /*interrupt vector*/
#define INT_LVL                  2          /*interrupt level*/
#define INT_PRI                  2          /*interrupt priority*/
#define WAIT                  0
#define SENDED                1	

/* QSPI memory commands */
#define QSPI_MEMORY_WREN	0x06
#define QSPI_MEMORY_WRDI	0x04
#define QSPI_MEMORY_RDSR	0x05
#define QSPI_MEMORY_WRSR	0x01
#define QSPI_MEMORY_READ	0x03
#define QSPI_MEMORY_WRITE	0x02



/****************************Prototypes*********************************/

/**********************************/

void WRENcommand();
void WRDIcommand();
void WRSRcommand(hcc_u8 data);
hcc_u8 RDSRcommand();
hcc_u8 READcommand(hcc_u8 u8Address);
void WRITEcommand(hcc_u8 u8Address, hcc_u8 u8Data);

/**********************************/

/*Driver to configure all the QSPI module*/
void QSPIinit(hcc_u8 u8TransferBits, hcc_u8 u8BaudRate); 

void QSPISendData(hcc_u8 u8cs, hcc_u16* message, hcc_u8 u8MessageSize);

__declspec(interrupt:0) void QSPIIsr();