/*
 * File:        i2c.h
 * Purpose:     I2C buffer structure information
 *
 * Notes:
 */

#ifndef __I2C_H__
#define __I2C_H__

/********************************************************************/

/* I2C parameters */
#define I2C_BUFFER_SIZE		(258)
#define I2C_TXRX			(2)
#define I2C_TX				(0)
#define	I2C_RX				(1)

#define TRUE				 1
#define FALSE				 0

/* Driver-specific defines */

/* Function prototypes */
void I2Cinit(hcc_u8 slave_address);
void I2Caction(hcc_u8, hcc_u8);
__declspec(interrupt:0)
void i2c_handler(void);

/* Function prototypes */

void I2CwriteCharacter(hcc_u8 address, hcc_u8 character);
void I2CreceiveString(hcc_u8 address, hcc_u16 length);
void cpu_pause(hcc_u32 usecs);

void I2CsetRxBuffer(hcc_u16 length);
void I2CsetTxBuffer(hcc_u8 *data, hcc_u16 length);
void I2CsetStartAddress(hcc_u8 address);
void printArray(hcc_u8 *data, hcc_u16 length);

/* Structure for storing I2C transfer data */
typedef struct {
    int tx_index;			/* TX index */
    int rx_index;			/* RX index */
    volatile int data_present;/* Data present flag */
    hcc_u16 length;			/* Length of the buffer in bytes */
    hcc_u8 buf[I2C_BUFFER_SIZE];		/* Data buffer */
} I2C_BUFFER;

/********************************************************************/

#endif /* __I2C_H__ */
