/*
 * File:        dma-uart.h
 * Purpose:     driver
 *
 * Notes:
 */

#ifndef __ADC_H__
#define __ADC_H__

/********************************************************************/

/* Driver-specific defines */

/* Pin Functions*/
#define ALL_ADC          0xFF

/* Samples Enable SDIS Register */
#define ALL_ENABLED      0x00
#define SAMPLE0_DISABLE  MCF_ADC_ADSDIS_DS0
#define SAMPLE1_DISABLE  MCF_ADC_ADSDIS_DS1
#define SAMPLE2_DISABLE  MCF_ADC_ADSDIS_DS2
#define SAMPLE3_DISABLE  MCF_ADC_ADSDIS_DS3
#define SAMPLE4_DISABLE  MCF_ADC_ADSDIS_DS4
#define SAMPLE5_DISABLE  MCF_ADC_ADSDIS_DS5
#define SAMPLE6_DISABLE  MCF_ADC_ADSDIS_DS6
#define SAMPLE7_DISABLE  MCF_ADC_ADSDIS_DS7
#define ALL_DISABLED     0xFF

/* Setup and Init*/
#define DEFAULT_DELAY    0x00D0              /* Delay in the POWER Reg by reset */

/* Specific Data types */

typedef struct
{
	hcc_u16 x_axis;
	hcc_u16 y_axis;
	hcc_u16 z_axis;
}accel_state_t;

/****************************Prototypes*********************************/

void ADCgetACCdata(accel_state_t *accel_state);
void ADCinit();
void ADCstart();
void ACCinit();

/********************************************************************/

#endif /* __ADC_H__ */