/*****************************************************************************
 * Copyright (c) 2008, Freescale Semiconductor                               *
 * Freescale Application Note                                                *
 *                                                                           *
 * File name   : main.c                                                      *
 * Project name: USB demo software using CMX USB stack                       *
 *                                                                           *
 * Author      : Paolo Alcantara                                             *
 * Department  : RTAC Americas                                               *
 *                                                                           *
 * Description :                                                             *
 *                                                                           *
 * History     :                                                             *
 * 08/27/2007  : First version of the software                               *
 * 01/04/2007  : Second version                                              *
 *                                                                           *
 *****************************************************************************/

#include "target.h"
#include "drivers/usb/usb_driver.h"
#include "drivers/adc/adc.h"
#include "drivers/uart-dma/uart-dma.h"

/*
 * MAIN FUNCTION:
 */

hcc_u8 bulk_transfer;
extern hcc_u16 variable_length;

void main()
{
  hcc_u8 accelerometer[6];		//ep1 (interrupt)
  hcc_u8 dma_uart[1024];		//ep2 (bulk)

  /* controllers' descriptors */  
  ep_state_t endpoints[2];
  accel_state_t state;
  dma_state_t dma_channel0;

  /* ep IN: accelerometer */
  endpoints[0].ep_state = EP_NOT_READY;
  endpoints[0].ep_buffer = accelerometer;
  endpoints[0].ep_length = 6;

  /* ep OUT: UART-DMA */
  endpoints[1].ep_state = EP_NOT_READY;
  endpoints[1].ep_buffer = dma_uart;
  endpoints[1].ep_length = 0; 

  /* flag to start bulk out transfer */
  bulk_transfer = 0;

  /****************** init chip *********************/
  hw_init(); 
	
  /**************** accelerometer init *******************/
  ADCinit(); 
  ACCinit();	
  ADCstart();

  /**************** UART-DMA init ************************/
  /* configure UART channel */
  UARTDMAinit(UARTCHANNEL);
  /* configure DMA Tx channel */
  DMATXinit(DMATRANSMIT);
  dma_channel0.dmaChannel = DMATRANSMIT;
  dma_channel0.source = (hcc_u32)&dma_uart;
  dma_channel0.destination = sourceSA(UARTCHANNEL);
  dma_channel0.byteCount = 0;

  /***************** USB init ****************************/
  /* USB irq is level = 6, priority = 6. */
  usb_init((6<<3) | 6, 0); 

  while(1)
  {	
	/***************** IN interrupt ****************************/
	
	/* getting Accelerometer information */
	ADCgetACCdata(&state);
	//x axis
	accelerometer[0] = (hcc_u8)((state.x_axis)&0xFF00)>>8;
	accelerometer[1] = (hcc_u8)((state.x_axis)&0x00FF);
	//y axis
	accelerometer[2] = (hcc_u8)((state.y_axis)&0xFF00)>>8;
	accelerometer[3] = (hcc_u8)((state.y_axis)&0x00FF);
	//z axis
	accelerometer[4] = (hcc_u8)((state.z_axis)&0xFF00)>>8;
	accelerometer[5] = (hcc_u8)((state.z_axis)&0x00FF);
	/* IN interrupt transaction */
	USBsend(1,&endpoints[0]);
	
	/***************** OUT bulk ****************************/
	
	if(bulk_transfer)
	{
		endpoints[1].ep_length = variable_length; 
		dma_channel0.byteCount = variable_length;
		/* prepare to transmit received data */
  		DMAstart(&dma_channel0);
		
		if(USBinput_ready(2, &endpoints[1]))
		{
			/* allow transmission */
			DMATXstart();
			bulk_transfer = 0;
		}
	}
		
  }
}
/****************************** END OF FILE **********************************/
