
/*
 * File:	mcf5282_lo.s
 * Purpose:	Lowest level routines for the MCF5282.
 *
 * Notes:	
 */

/*#ifdef _UNDERSCORE_
#define exception_handler	_exception_handler
#define mcf5282_init		_mcf5282_init
#define main				_main
#endif*/
 
	.extern ___IPSBAR
	.extern ___SRAM
	.extern ___FLASH
	.extern ___SP_INIT
	.extern ___SRAM_SIZE
	.extern VECTOR_TABLE
	.extern _exception_handler
	.extern mcf5xxx_wr_rambar0
	.extern mcf5xxx_wr_rambar1
	.extern _mcf5282_init
	.extern _main

	.global asm_startmeup
	.global _asm_startmeup
	.global	asm_exception_handler
	.global	_asm_exception_handler
	.global cpu_cache_flush
	.global _cpu_cache_flush
	.global	mcf5xxx_wr_cacr
	.global _mcf5xxx_wr_cacr
	.global	mcf5xxx_wr_vbr
	.global	_mcf5xxx_wr_vbr

	// add these definitions to make the original names visible when debug
	.function "asm_startmeup",_asm_startmeup,_asm_startmeup_end-_asm_startmeup
	.function "asm_exception_handler",_asm_exception_handler,_asm_exception_handler_end-_asm_exception_handler
	.function "cpu_cache_flush",_cpu_cache_flush,_cpu_cache_flush_end-_cpu_cache_flush
	.function "mcf5xxx_wr_cacr",_mcf5xxx_wr_cacr,_mcf5xxx_wr_cacr_end-_mcf5xxx_wr_cacr
	.function "mcf5xxx_wr_vbr",_mcf5xxx_wr_vbr,_mcf5xxx_wr_vbr_end-_mcf5xxx_wr_vbr
	.text

/********************************************************************
 * This is the main entry point upon hard reset.
 */
asm_startmeup:
_asm_startmeup:

	move.w	#0x2700,sr

	/* Initialize IPSBAR */
	move.l	#(___IPSBAR + 1),d0
	move.l	d0,0x40000000
	
	/* Initialize FLASHBAR: locate internal Flash and validate it */
	/* Initialize RAMBAR0: This is the FLASHBAR */
	/** this sets bit 6 of the FLASHBAR.  Bit 6 is not documented, however,
	***	Freescale states that it is a workaround for the FLASH speculative
	*** read issues. See Errata data for the PCF5282, mask 0L95M. ***/ 
	//move.l	#(___FLASH + 0x161),d0
    //movec d0,RAMBAR0

	/* Initialize RAMBAR1: locate SRAM and validate it */
	move.l	#(___SRAM + 0x21),d0
    movec d0,RAMBAR1
    
    /* Initialize FLASHBAR */
    move.l  #___FLASH,d0
    cmp.l   #0x00000000,d0
    bne     change_flashbar
    add.l   #0x61,d0
    movec   d0,RAMBAR0

_continue_startup:    
  /* At this point the memory should be correctly setup */
	/* Point Stack Pointer into SRAM temporarily */
	move.l	#(___SRAM + 0x10000),sp

	/* Initialize mcf5282 periphs, etc */
	jsr		_mcf5282_init

	/* Relocate Stack Pointer */ 
	move.l	#___SP_INIT,sp

	/* Jump to the main process */
	jmp		_main
	
	bra		.
	nop
	nop
	halt

change_flashbar:
    /* 
     * The following sequence is used to set FLASHBAR. Since we may 
     * be executing from Flash, we must put the routine into SRAM for
     * execution and then jump back to Flash using the new address.
     *
     * The following instructions are coded into the SRAM:
     *
     * move.l	#(___FLASHBAR + 0x61),d0
     * movec	d0, RAMBAR
     * jmp		_continue_startup
     *
     * An arbitrary SRAM address is chosen until the real address
     * can be loaded.
     *
     * This routine is not necessary if the default Flash address
     * (0x00000000) is used.
     *
     * If running in SRAM, change_flashbar should not be executed 
     */

	move.l  #___SRAM,a0

	/* Code "move.l #(___FLASHBAR + 0x61),d0" into SRAM */
	move.w  #0x203C,d0
	move.w  d0,(a0)+
	move.l  #___FLASH,d0
	add.l   #0x61,d0
	move.l  d0,(a0)+
	
	/* Code "movec d0,FLASHBAR" into SRAM */
	move.l  #0x4e7b0C04,d0
	move.l  d0,(a0)+
		
	/* Code "jmp _continue_startup" into SRAM */
	move.w  #0x4EF9,d0
	move.w  d0,(a0)+
	move.l  #_continue_startup,d0
	move.l  d0,(a0)+

	/* Jump to code segment in internal SRAM */
	jmp	    ___SRAM
_asm_startmeup_end:

/********************************************************************
/*
 * This routine is the lowest-level exception handler.
 */
asm_exception_handler:
_asm_exception_handler:

	lea     -20(sp), sp
	movem.l d0-d2/a0-a1, (sp)
	pea.l   20(sp)              /* push exception frame address */
	jsr		_exception_handler
	movem.l 4(sp), d0-d2/a0-a1
	lea     24(sp), sp
	rte
_asm_exception_handler_end:

/********************************************************************
 * The MCF5282 cache can be configured as instruction, data or split.
 * Invalidate the entire cache.
 */
cpu_cache_flush:
_cpu_cache_flush:
	nop						/* sync */
	move.l	#0x01000000,d0	/* Invalidate the I-Cache */
	movec 	d0,cacr
	rts
_cpu_cache_flush_end:
/********************************************************************/
/*
 * These routines write to the special purpose registers in the ColdFire
 * core.  Since these registers are write-only in the supervisor model,
 * no corresponding read routines exist.
 */
 
mcf5xxx_wr_cacr:
_mcf5xxx_wr_cacr:
    move.l  4(sp),d0
    movec d0,cacr	 
    nop
    rts
_mcf5xxx_wr_cacr_end:

mcf5xxx_wr_vbr:
_mcf5xxx_wr_vbr:
	move.l	4(sp),d0
	movec d0,VBR	
	nop
	rts
_mcf5xxx_wr_vbr_end:


	.end
