
#include "mcf5282.h"
#include "init.h"
#include <stdio.h>

int main()
{	
	printf("\r***********  Queued analog to digital converter - example code no.1  ***********\n\r");
	printf("*                                                                              *\n\r");
	printf("*  IRQ7 button increase digital state on QB port (4 channels below)            *\n\r");
	printf("*  JP24 of EVB determines output voltage: 1-2 sets 3.3V                        *\n\r");
	printf("*                                         3-4 sets 5V                          *\n\r");
	printf("*                                         5-6 sets voltage on pin J5-18        *\n\r");	
	printf("*  LITE board uses fixed 3.3V.                                                 *\n\r");
	printf("*  You can see watch signal state on the scope.                                *\n\r");
	printf("*                                                                              *\n\r");
	printf("*  QADC channel:       AN3   AN2   AN1   AN0                                   *\n\r");
	printf("*  EVB-J5 pin:         19    17    16    5                                     *\n\r");
	printf("*  LITE-MCU_PORT pin:  11    12    13    14                                    *\n\r");
	printf("*                                                                              *\n\r");
	printf("********************************************************************************\n\r");
	printf("\n");

	/**** initialize Edge Port Module ****/
	
	MCF5282_EPORT_EPPAR = MCF5282_EPORT_EPPAR_EPPA7_RISING;
    MCF5282_EPORT_EPIER = MCF5282_EPORT_EPIER_EPIE7;
	
	
	/**** initialize Interrupt Controller ****/
	
	/* note: IRQ7 have hardwired level 7 and fixed midpoint priority - no ICR settings */
	MCF5282_INTC0_IMRL &= ~( MCF5282_INTC_IMRL_INT7    |   // unmask IRQ7 
	                         MCF5282_INTC_IMRL_MASKALL ); 
	/* note: MASKALL have to be unmasked earlier or in the same time then the rest of IMRL register!!! */
	asm (move.w #0x2000,SR); // unmask interrupts in core
		
	/**** initialize Queued Analog to Digital Converter (possibility to using CFInit) ****/
	
	MCF5282_QADC_DDRQB = MCF5282_QADC_DDRQB_DDQB3 |
                         MCF5282_QADC_DDRQB_DDQB2 |
                         MCF5282_QADC_DDRQB_DDQB1 |
                         MCF5282_QADC_DDRQB_DDQB0;  // set the whole QP port as GPIO output
	
	/**** idle ****/	
	
	while(1);
	return 0;
	
}
