/*
 * File:		main.c
 * Purpose:		sample program
 *
 */
#include "support_common.h" /* include peripheral declarations and more */
#include <stdio.h> 

void ADC_init(void);

int main()
{	
	printf("\r**************   Analog to digital converter - example code no.3  **************\n\r");
	printf("*                                                                              *\n\r");
	printf("* Push SW1 for start/stop ADC converter (sequential loop mode)                 *\n\r");
	printf("*            - Sample slot 0 (channel 0) - potentiometer                       *\n\r");
	printf("*            - Sample slot 1 (channel 4) - accelerometer X-axis                *\n\r");
	printf("*            - Sample slot 2 (channel 5) - accelerometer Y-axis                *\n\r");
	printf("*            - Sample slot 3 (channel 6) - accelerometer Z-axis                *\n\r");
	printf("* Pushing SW2 takes no action                                                  *\n\r");
	printf("*                                                                              *\n\r");
	printf("********************************************************************************\n\r");
	printf("\n\r");
	
	/**** initialize Interrupt Controller ****/
	
	MCF_INTC0_ICR49 = MCF_INTC_ICR_IP(1) | MCF_INTC_ICR_IL(1);
	MCF_INTC0_ICR50 = MCF_INTC_ICR_IP(2) | MCF_INTC_ICR_IL(1);
	MCF_INTC0_ICR51 = MCF_INTC_ICR_IP(3) | MCF_INTC_ICR_IL(1);
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_INT_MASK49; // ADCA conversion complete
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_INT_MASK50; // ADCB conversion complete
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_INT_MASK51; // ADC Zero Crossing or Limit Error
	MCF_INTC0_IMRL &= ~MCF_INTC_IMRL_MASKALL; // global 
	asm (move.w #0x2000,SR); // unmask interrupts in Core status register
	
	
	/**** initialize General Purpose I/O Module ****/

	MCF_GPIO_PANPAR = MCF_GPIO_PANPAR_AN0_AN0 |
	                  MCF_GPIO_PANPAR_AN1_AN1 |
	                  MCF_GPIO_PANPAR_AN2_AN2 |
	                  MCF_GPIO_PANPAR_AN3_AN3 |
	                  MCF_GPIO_PANPAR_AN4_AN4 |
	                  MCF_GPIO_PANPAR_AN5_AN5 |
	                  MCF_GPIO_PANPAR_AN6_AN6 |
	                  MCF_GPIO_PANPAR_AN7_AN7 ;  // all ANn pins set for their primary function
	
	MCF_GPIO_PASPAR = MCF_GPIO_PASPAR_SYNCA_SYNCA |
	                  MCF_GPIO_PASPAR_SYNCB_SYNCB ; // SYNCA and SYNCB pins set for their primary function
	
	ADC_init();	
		
	while(1) asm (nop); // idle 

	return 0;
}

void ADC_init(void)
{
	/**** initialize Analog-to-Digital Converter (possibility using CFInit) ****/

	MCF_ADC_POWER &= ~(MCF_ADC_POWER_PD0 | MCF_ADC_POWER_PD1 | MCF_ADC_POWER_PD2);
		// power-up converter A, converter B and voltage reference circuit 

	while (MCF_ADC_POWER & (MCF_ADC_POWER_PSTS0 | MCF_ADC_POWER_PSTS1 | MCF_ADC_POWER_PSTS2)) 
	{}; // stay here as long as converter A, B and voltage reference circuit are power-down
	
	MCF_ADC_CTRL1 = MCF_ADC_CTRL1_EOSIE0    |  // ADCA end of scan interrupt enable
	                MCF_ADC_CTRL1_CHNCFG(0) |  // all inputs as single ended
	                MCF_ADC_CTRL1_SMODE(2)  |  // 0 - once sequential, 1 - once parallel,
	                                           // 2 - loop sequential, 3 - loop parallel,
	                                           // 4 - triggered sequential, 5-triggered parallel           
	                MCF_ADC_CTRL1_STOP0;       // stop until button pushing

	if (CORE_CLOCK % 20000) // set conversion time as short as possible but don't exceed 5MHz frequency
		MCF_ADC_CTRL2 = MCF_ADC_CTRL2_DIV(CORE_CLOCK / 20000); // divison remainder != 0	
	else
		MCF_ADC_CTRL2 = MCF_ADC_CTRL2_DIV((CORE_CLOCK / 20000) - 1); // divison reminder = 0
					

	MCF_ADC_ADLST1 = MCF_ADC_ADLST1_SAMPLE0(0) | // sample slot 0 for channel 0
	                 MCF_ADC_ADLST1_SAMPLE1(4) | // sample slot 1 for channel 4
	                 MCF_ADC_ADLST1_SAMPLE2(5) | // sample slot 2 for channel 5
	                 MCF_ADC_ADLST1_SAMPLE3(6) ; // sample slot 3 for channel 6
	                 
	MCF_ADC_ADSDIS = MCF_ADC_ADSDIS_DS4 ; // disable SAMPLE4 slot (and all higher !!)
	
	MCF_ADC_ADOFS0 = MCF_ADC_ADOFS_OFFSET(2047); 
	MCF_ADC_ADOFS1 = MCF_ADC_ADOFS_OFFSET(2047);
	MCF_ADC_ADOFS2 = MCF_ADC_ADOFS_OFFSET(2047);
	MCF_ADC_ADOFS3 = MCF_ADC_ADOFS_OFFSET(2047);
		// offset value (0 - positive results, 2047 - signed results, 4095 - negative results)			
}
